/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.jdt.internal.compiler.util.Util;

public class RecoveredMethod
extends RecoveredElement
implements TerminalTokens {
    public AbstractMethodDeclaration methodDeclaration;
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock methodBody;
    public boolean discardBody = true;

    public RecoveredMethod(AbstractMethodDeclaration methodDeclaration, RecoveredElement parent, int bracketBalance, Parser parser2) {
        super(parent, bracketBalance, parser2);
        this.methodDeclaration = methodDeclaration;
        boolean bl = this.foundOpeningBrace = !this.bodyStartsAtHeaderEnd();
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
    }

    public RecoveredElement add(Block nestedBlockDeclaration, int bracketBalanceValue) {
        if (this.methodDeclaration.declarationSourceEnd > 0 && nestedBlockDeclaration.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(nestedBlockDeclaration, bracketBalanceValue);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.methodBody = new RecoveredBlock(nestedBlockDeclaration, (RecoveredElement)this, bracketBalanceValue);
        if (nestedBlockDeclaration.sourceEnd == 0) {
            return this.methodBody;
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int bracketBalanceValue) {
        char[][] fieldTypeName;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (fieldTypeName = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(fieldTypeName[0], TypeBinding.VOID.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, bracketBalanceValue);
        }
        if (this.methodDeclaration.declarationSourceEnd > 0 && fieldDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(fieldDeclaration, bracketBalanceValue);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int bracketBalanceValue) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, bracketBalanceValue);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement currentBlock = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int i = 0;
                while (i < this.bracketBalance - 1) {
                    currentBlock = currentBlock.add(new Block(0), 1);
                    ++i;
                }
                this.bracketBalance = 1;
            }
            return currentBlock.add(localDeclaration, bracketBalanceValue);
        }
        return this.methodBody.add(localDeclaration, bracketBalanceValue, true);
    }

    public RecoveredElement add(Statement statement, int bracketBalanceValue) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, bracketBalanceValue);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement currentBlock = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int i = 0;
                while (i < this.bracketBalance - 1) {
                    currentBlock = currentBlock.add(new Block(0), 1);
                    ++i;
                }
                this.bracketBalance = 1;
            }
            return currentBlock.add(statement, bracketBalanceValue);
        }
        return this.methodBody.add(statement, bracketBalanceValue, true);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalanceValue) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, bracketBalanceValue);
        }
        if ((typeDeclaration.bits & 0x100) != 0 || this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated) {
            if (this.methodBody == null) {
                Block block = new Block(0);
                block.sourceStart = this.methodDeclaration.bodyStart;
                this.add(block, 1);
            }
            return this.methodBody.add(typeDeclaration, bracketBalanceValue, true);
        }
        switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
            case 2: 
            case 4: {
                this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(typeDeclaration.declarationSourceStart - 1));
                if (this.parent == null) {
                    return this;
                }
                return this.parent.add(typeDeclaration, bracketBalanceValue);
            }
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType element = new RecoveredType(typeDeclaration, (RecoveredElement)this, bracketBalanceValue);
        this.localTypes[this.localTypeCount++] = element;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return element;
    }

    public boolean bodyStartsAtHeaderEnd() {
        return this.methodDeclaration.bodyStart == this.methodDeclaration.sourceEnd + 1;
    }

    public ASTNode parseTree() {
        return this.methodDeclaration;
    }

    public int sourceEnd() {
        return this.methodDeclaration.declarationSourceEnd;
    }

    public String toString(int tab) {
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered method:\n");
        this.methodDeclaration.print(tab + 1, result);
        if (this.localTypes != null) {
            int i = 0;
            while (i < this.localTypeCount) {
                result.append("\n");
                result.append(this.localTypes[i].toString(tab + 1));
                ++i;
            }
        }
        if (this.methodBody != null) {
            result.append("\n");
            result.append(this.methodBody.toString(tab + 1));
        }
        return result.toString();
    }

    public void updateBodyStart(int bodyStart) {
        this.foundOpeningBrace = true;
        this.methodDeclaration.bodyStart = bodyStart;
    }

    public AbstractMethodDeclaration updatedMethodDeclaration() {
        Block block;
        if (this.methodBody != null && (block = this.methodBody.updatedBlock()) != null) {
            this.methodDeclaration.statements = block.statements;
            if (this.methodDeclaration.isConstructor()) {
                ConstructorDeclaration constructor = (ConstructorDeclaration)this.methodDeclaration;
                if (this.methodDeclaration.statements != null && this.methodDeclaration.statements[0] instanceof ExplicitConstructorCall) {
                    constructor.constructorCall = (ExplicitConstructorCall)this.methodDeclaration.statements[0];
                    int length = this.methodDeclaration.statements.length;
                    this.methodDeclaration.statements = new Statement[length - 1];
                    System.arraycopy(this.methodDeclaration.statements, 1, this.methodDeclaration.statements, 0, length - 1);
                }
                if (constructor.constructorCall == null) {
                    constructor.constructorCall = SuperReference.implicitSuperConstructorCall();
                }
            }
        }
        if (this.localTypeCount > 0) {
            this.methodDeclaration.bits |= 2;
        }
        return this.methodDeclaration;
    }

    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.parent != null) {
            Parser parser2 = this.parser();
            if (parser2.listLength > 0 && parser2.astLengthPtr > 0) {
                if (this.methodDeclaration.sourceEnd == parser2.rParenPos) {
                    boolean canConsume;
                    int length = parser2.astLengthStack[parser2.astLengthPtr];
                    int astPtr = parser2.astPtr - length;
                    boolean bl = canConsume = astPtr >= 0;
                    if (canConsume) {
                        if (!(parser2.astStack[astPtr] instanceof AbstractMethodDeclaration)) {
                            canConsume = false;
                        }
                        int i = 1;
                        int max = length + 1;
                        while (i < max) {
                            if (!(parser2.astStack[astPtr + i] instanceof TypeReference)) {
                                canConsume = false;
                            }
                            ++i;
                        }
                    }
                    if (canConsume) {
                        parser2.consumeMethodHeaderThrowsClause();
                    } else {
                        parser2.listLength = 0;
                    }
                } else {
                    if (parser2.currentToken == 28 || parser2.currentToken == 27) {
                        int n = parser2.astLengthPtr;
                        parser2.astLengthStack[n] = parser2.astLengthStack[n] - 1;
                        --parser2.astPtr;
                        --parser2.listLength;
                        parser2.currentToken = 0;
                    }
                    int argLength = parser2.astLengthStack[parser2.astLengthPtr];
                    int argStart = parser2.astPtr - argLength + 1;
                    boolean needUpdateRParenPos = parser2.rParenPos < parser2.lParenPos;
                    MemberValuePair[] memberValuePairs = null;
                    if (argLength > 0 && parser2.astStack[parser2.astPtr] instanceof MemberValuePair) {
                        memberValuePairs = new MemberValuePair[argLength];
                        System.arraycopy(parser2.astStack, argStart, memberValuePairs, 0, argLength);
                        --parser2.astLengthPtr;
                        parser2.astPtr -= argLength;
                        argLength = parser2.astLengthStack[parser2.astLengthPtr];
                        argStart = parser2.astPtr - argLength + 1;
                        needUpdateRParenPos = true;
                    }
                    int count = 0;
                    while (count < argLength) {
                        ASTNode aNode = parser2.astStack[argStart + count];
                        if (aNode instanceof Argument) {
                            Argument argument = (Argument)aNode;
                            char[][] argTypeName = argument.type.getTypeName();
                            if ((argument.modifiers & 0xFFFFFFEF) != 0 || argTypeName.length == 1 && CharOperation.equals(argTypeName[0], TypeBinding.VOID.sourceName())) {
                                parser2.astLengthStack[parser2.astLengthPtr] = count;
                                parser2.astPtr = argStart + count - 1;
                                parser2.listLength = count;
                                parser2.currentToken = 0;
                                break;
                            }
                            if (needUpdateRParenPos) {
                                parser2.rParenPos = argument.sourceEnd + 1;
                            }
                        } else {
                            parser2.astLengthStack[parser2.astLengthPtr] = count;
                            parser2.astPtr = argStart + count - 1;
                            parser2.listLength = count;
                            parser2.currentToken = 0;
                            break;
                        }
                        ++count;
                    }
                    if (parser2.listLength > 0 && parser2.astLengthPtr > 0) {
                        boolean canConsume;
                        int length = parser2.astLengthStack[parser2.astLengthPtr];
                        int astPtr = parser2.astPtr - length;
                        boolean bl = canConsume = astPtr >= 0;
                        if (canConsume) {
                            if (!(parser2.astStack[astPtr] instanceof AbstractMethodDeclaration)) {
                                canConsume = false;
                            }
                            int i = 1;
                            int max = length + 1;
                            while (i < max) {
                                if (!(parser2.astStack[astPtr + i] instanceof Argument)) {
                                    canConsume = false;
                                }
                                ++i;
                            }
                        }
                        if (canConsume) {
                            parser2.consumeMethodHeaderRightParen();
                            if (parser2.currentElement == this) {
                                this.methodDeclaration.sourceEnd = this.methodDeclaration.arguments[this.methodDeclaration.arguments.length - 1].sourceEnd;
                                parser2.lastCheckPoint = this.methodDeclaration.bodyStart = this.methodDeclaration.sourceEnd + 1;
                            }
                        }
                    }
                    if (memberValuePairs != null) {
                        System.arraycopy(memberValuePairs, 0, parser2.astStack, parser2.astPtr + 1, memberValuePairs.length);
                        parser2.astPtr += memberValuePairs.length;
                        parser2.astLengthStack[++parser2.astLengthPtr] = memberValuePairs.length;
                    }
                }
            }
        }
    }

    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        int modifiers;
        if (this.methodDeclaration.isAnnotationMethod()) {
            this.updateSourceEndIfNecessary(braceStart, braceEnd);
            if (!this.foundOpeningBrace && this.parent != null) {
                return this.parent.updateOnClosingBrace(braceStart, braceEnd);
            }
            return this;
        }
        if (this.parent != null && this.parent instanceof RecoveredType && TypeDeclaration.kind(modifiers = ((RecoveredType)this.parent).typeDeclaration.modifiers) == 2 && !this.foundOpeningBrace) {
            this.updateSourceEndIfNecessary(braceStart - 1, braceStart - 1);
            return this.parent.updateOnClosingBrace(braceStart, braceEnd);
        }
        return super.updateOnClosingBrace(braceStart, braceEnd);
    }

    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance == 0) {
            switch (this.parser().lastIgnoredToken) {
                case -1: 
                case 105: {
                    break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        return super.updateOnOpeningBrace(braceStart, braceEnd);
    }

    public void updateParseTree() {
        this.updatedMethodDeclaration();
    }

    public void updateSourceEndIfNecessary(int braceStart, int braceEnd) {
        if (this.methodDeclaration.declarationSourceEnd == 0) {
            if (this.parser().rBraceSuccessorStart >= braceEnd) {
                this.methodDeclaration.declarationSourceEnd = this.parser().rBraceEnd;
                this.methodDeclaration.bodyEnd = this.parser().rBraceStart;
            } else {
                this.methodDeclaration.declarationSourceEnd = braceEnd;
                this.methodDeclaration.bodyEnd = braceStart - 1;
            }
        }
    }

    void attach(TypeParameter[] parameters, int startPos) {
        if (this.methodDeclaration.modifiers != 0) {
            return;
        }
        int lastParameterEnd = parameters[parameters.length - 1].sourceEnd;
        Parser parser2 = this.parser();
        Scanner scanner = parser2.scanner;
        if (Util.getLineNumber(this.methodDeclaration.declarationSourceStart, scanner.lineEnds, 0, scanner.linePtr) != Util.getLineNumber(lastParameterEnd, scanner.lineEnds, 0, scanner.linePtr)) {
            return;
        }
        if (parser2.modifiersSourceStart > lastParameterEnd && parser2.modifiersSourceStart < this.methodDeclaration.declarationSourceStart) {
            return;
        }
        if (this.methodDeclaration instanceof MethodDeclaration) {
            ((MethodDeclaration)this.methodDeclaration).typeParameters = parameters;
            this.methodDeclaration.declarationSourceStart = startPos;
        } else if (this.methodDeclaration instanceof ConstructorDeclaration) {
            ((ConstructorDeclaration)this.methodDeclaration).typeParameters = parameters;
            this.methodDeclaration.declarationSourceStart = startPos;
        }
    }
}

