/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.hibernate.ejb.packaging.AbstractJarVisitor;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.JarVisitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamZippedJarVisitor
extends AbstractJarVisitor {
    private final Logger log = LoggerFactory.getLogger(InputStreamZippedJarVisitor.class);
    private String entry;

    public InputStreamZippedJarVisitor(URL url, Filter[] filters, String entry) {
        super(url, filters);
        this.entry = entry;
    }

    public InputStreamZippedJarVisitor(String fileName, Filter[] filters) {
        super(fileName, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessElements() throws IOException {
        JarEntry jarEntry;
        JarInputStream jis;
        try {
            jis = new JarInputStream(this.jarUrl.openStream());
        }
        catch (Exception ze) {
            this.log.warn("Unable to find file (ignored): " + this.jarUrl, ze);
            return;
        }
        if (this.entry != null && this.entry.length() == 1) {
            this.entry = null;
        }
        if (this.entry != null && this.entry.startsWith("/")) {
            this.entry = this.entry.substring(1);
        }
        while ((jarEntry = jis.getNextJarEntry()) != null) {
            String name = jarEntry.getName();
            if (this.entry != null && !name.startsWith(this.entry) || jarEntry.isDirectory()) continue;
            if (name.equals(this.entry)) {
                JarInputStream subJis = null;
                try {
                    subJis = new JarInputStream(jis);
                    ZipEntry subZipEntry = jis.getNextEntry();
                    while (subZipEntry != null) {
                        if (!subZipEntry.isDirectory()) {
                            byte[] entryBytes = JarVisitorFactory.getBytesFromInputStream(jis);
                            String subname = subZipEntry.getName();
                            if (subname.startsWith("/")) {
                                subname = subname.substring(1);
                            }
                            this.addElement(subname, new ByteArrayInputStream(entryBytes), new ByteArrayInputStream(entryBytes));
                        }
                        subZipEntry = jis.getNextJarEntry();
                    }
                    continue;
                }
                finally {
                    if (subJis != null) {
                        subJis.close();
                    }
                    continue;
                }
            }
            byte[] entryBytes = JarVisitorFactory.getBytesFromInputStream(jis);
            if (this.entry != null) {
                name = name.substring(this.entry.length());
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            this.addElement(name, new ByteArrayInputStream(entryBytes), new ByteArrayInputStream(entryBytes));
        }
        jis.close();
    }
}

