/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest.jmsbridge;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.DeleteNot;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.TopicForwardNot;
import org.objectweb.joram.mom.dest.TopicImpl;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeAckNot;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeDeliveryNot;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeModule;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.SubscribeRequest;
import org.objectweb.joram.mom.notifications.UnsubscribeRequest;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JMSBridgeTopicImpl
extends TopicImpl {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger(JMSBridgeTopicImpl.class.getName());
    private JMSBridgeModule jmsModule;
    private long arrivalsCounter = 0L;
    private Hashtable outTable = new Hashtable();

    public JMSBridgeTopicImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
        this.jmsModule = new JMSBridgeModule(prop);
    }

    public void initialize(boolean firstTime) {
        block7: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("initialize(" + firstTime + ')'));
            }
            super.initialize(firstTime);
            this.jmsModule.init(this.getId());
            try {
                org.objectweb.joram.mom.messages.Message momMsg;
                this.jmsModule.connect();
                if (!this.subscribers.isEmpty()) {
                    this.jmsModule.setMessageListener();
                }
                Vector<org.objectweb.joram.mom.messages.Message> outMessages = new Vector<org.objectweb.joram.mom.messages.Message>();
                Enumeration keys = this.outTable.keys();
                while (keys.hasMoreElements()) {
                    int i;
                    momMsg = (org.objectweb.joram.mom.messages.Message)this.outTable.get(keys.nextElement());
                    for (i = 0; i < outMessages.size(); ++i) {
                        org.objectweb.joram.mom.messages.Message currentMsg = (org.objectweb.joram.mom.messages.Message)outMessages.get(i);
                        if (momMsg.order < currentMsg.order) break;
                    }
                    outMessages.insertElementAt(momMsg, i);
                }
                while (!outMessages.isEmpty()) {
                    momMsg = (org.objectweb.joram.mom.messages.Message)outMessages.remove(0);
                    this.jmsModule.send(momMsg.getFullMessage());
                }
            }
            catch (Exception exc) {
                if (!JoramTracing.dbgDestination.isLoggable(BasicLevel.ERROR)) break block7;
                JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
        }
    }

    public String toString() {
        return "BridgeTopicImpl:" + this.getId().toString();
    }

    public void bridgeDeliveryNot(AgentId from, JMSBridgeDeliveryNot not) {
        ClientMessages clientMessages = new ClientMessages();
        clientMessages.addMessage(not.getMessage());
        super.doClientMessages(this.getId(), clientMessages);
    }

    public void bridgeAckNot(JMSBridgeAckNot not) {
        this.outTable.remove(not.getIdentifier());
    }

    public void postSubscribe(SubscribeRequest not) {
        block3: {
            try {
                if (this.subscribers.size() == 1) {
                    this.jmsModule.setMessageListener();
                }
            }
            catch (Exception exc) {
                if (!JoramTracing.dbgDestination.isLoggable(BasicLevel.ERROR)) break block3;
                JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)"Failing subscribe request on remote destination: ", (Throwable)exc);
            }
        }
    }

    public void preUnsubscribe(UnsubscribeRequest not) {
        if (this.subscribers.isEmpty()) {
            this.jmsModule.unsetMessageListener();
        }
    }

    public void topicForwardNot(AgentId from, TopicForwardNot not) {
        if (not.toFather && this.fatherId != null) {
            this.forward(this.fatherId, not);
        }
        DMQManager dmqManager = null;
        Enumeration msgs = not.messages.getMessages().elements();
        while (msgs.hasMoreElements()) {
            org.objectweb.joram.mom.messages.Message message = new org.objectweb.joram.mom.messages.Message((Message)msgs.nextElement());
            ++this.arrivalsCounter;
            message.order = message.order;
            this.outTable.put(message.getIdentifier(), message);
            try {
                this.jmsModule.send(message.getFullMessage());
            }
            catch (Exception exc) {
                this.outTable.remove(message.getIdentifier());
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)6);
            }
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages not) {
        if (this.getId().equals(from)) {
            return not;
        }
        this.forwardMessages(not);
        DMQManager dmqManager = null;
        Enumeration msgs = not.getMessages().elements();
        while (msgs.hasMoreElements()) {
            org.objectweb.joram.mom.messages.Message message = new org.objectweb.joram.mom.messages.Message((Message)msgs.nextElement());
            ++this.arrivalsCounter;
            message.order = message.order;
            this.outTable.put(message.getIdentifier(), message);
            try {
                this.jmsModule.send(message.getFullMessage());
            }
            catch (Exception exc) {
                this.outTable.remove(message.getIdentifier());
                if (dmqManager == null) {
                    dmqManager = new DMQManager(not.getDMQId(), this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
            }
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        return null;
    }

    protected void doDeleteNot(DeleteNot not) {
        this.jmsModule.close();
        super.doDeleteNot(not);
    }
}

