/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.interceptor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.objectweb.carol.rmi.jrmp.interceptor.JInitializer;
import org.ow2.carol.rmi.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsGroup;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JRMPInitInfoImpl;
import org.ow2.carol.rmi.jrmp.interceptor.impl.legacy.JInterceptorConverter;
import org.ow2.carol.util.configuration.TraceCarol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JInterceptorStore {
    public static final String INTIALIZER_PREFIX = "org.ow2.PortableInterceptor.JRMPInitializerClass";
    private static JInterceptorStore jiStore = null;
    private final List<JInterceptorsGroup> jinterceptorsList;
    private JClientRequestInterceptor[] rcis;
    private final JRMPInitInfoImpl jrmpInfo = new JRMPInitInfoImpl();
    private final org.objectweb.carol.rmi.jrmp.interceptor.JRMPInitInfoImpl legacyJrmpInfo = new org.objectweb.carol.rmi.jrmp.interceptor.JRMPInitInfoImpl();

    private JInterceptorStore() {
        this.jinterceptorsList = new ArrayList<JInterceptorsGroup>();
        try {
            Properties sys = System.getProperties();
            Enumeration<?> e = sys.propertyNames();
            while (e.hasMoreElements()) {
                JInterceptorsGroup jInterceptors;
                Object jinit;
                String pkey = (String)e.nextElement();
                if (!pkey.startsWith(INTIALIZER_PREFIX)) continue;
                String initializer = pkey.substring(INTIALIZER_PREFIX.length() + 1);
                Object object = this.getClass().getClassLoader().loadClass(initializer).newInstance();
                if (object instanceof org.ow2.carol.rmi.interceptor.spi.JInitializer) {
                    jinit = (org.ow2.carol.rmi.interceptor.spi.JInitializer)object;
                    this.jrmpInfo.clear();
                    jinit.preInit(this.jrmpInfo);
                    jinit.postInit(this.jrmpInfo);
                    jInterceptors = new JInterceptorsGroup(initializer, this.jrmpInfo.getServerRequestInterceptors(), this.jrmpInfo.getClientRequestInterceptors());
                } else {
                    jinit = (JInitializer)object;
                    this.legacyJrmpInfo.clear();
                    jinit.pre_init(this.legacyJrmpInfo);
                    jinit.post_init(this.legacyJrmpInfo);
                    jInterceptors = new JInterceptorsGroup(initializer, JInterceptorConverter.convertJServerRequestInterceptor(this.legacyJrmpInfo.getServerRequestInterceptors()), JInterceptorConverter.convertJClientRequestInterceptor(this.legacyJrmpInfo.getClientRequestInterceptors()));
                }
                this.jinterceptorsList.add(jInterceptors);
            }
            this.resetRemoteInterceptors();
        }
        catch (Exception e) {
            TraceCarol.error("JrmpPRODelegate(), No interceptors found", e);
            throw new RuntimeException("Cannot initialize the JInterceptorStore", e);
        }
    }

    public static synchronized JInterceptorStore getJInterceptorStore() {
        if (jiStore == null) {
            jiStore = new JInterceptorStore();
        }
        return jiStore;
    }

    public List<JInterceptorsGroup> getJInterceptors() {
        return this.jinterceptorsList;
    }

    public synchronized JClientRequestInterceptor[] setRemoteInterceptors(String[] ia) {
        ArrayList<JClientRequestInterceptor> result = new ArrayList<JClientRequestInterceptor>();
        for (String className : ia) {
            try {
                Object jinit;
                Object object = Class.forName(className).newInstance();
                if (object instanceof org.ow2.carol.rmi.interceptor.spi.JInitializer) {
                    jinit = (org.ow2.carol.rmi.interceptor.spi.JInitializer)object;
                    this.jrmpInfo.clear();
                    jinit.preInit(this.jrmpInfo);
                    jinit.postInit(this.jrmpInfo);
                    result.addAll(Arrays.asList(this.jrmpInfo.getClientRequestInterceptors()));
                    continue;
                }
                jinit = (JInitializer)object;
                this.legacyJrmpInfo.clear();
                jinit.pre_init(this.legacyJrmpInfo);
                jinit.post_init(this.legacyJrmpInfo);
                result.addAll(Arrays.asList(JInterceptorConverter.convertJClientRequestInterceptor(this.legacyJrmpInfo.getClientRequestInterceptors())));
            }
            catch (Exception e) {
                TraceCarol.error("Can not load interceptors " + ia, e);
                throw new RuntimeException("Can not load interceptors " + ia, e);
            }
        }
        this.rcis = result.toArray(new JClientRequestInterceptor[result.size()]);
        return this.rcis;
    }

    public synchronized void addLocalInterceptor(Class<?> jinitClass) {
        String jinitClassname = jinitClass.getName();
        for (JInterceptorsGroup jInterceptors : this.jinterceptorsList) {
            if (!jInterceptors.getInitializer().equals(jinitClassname)) continue;
            TraceCarol.debugRmiCarol("Interceptors already registered for class " + jinitClassname);
            return;
        }
        try {
            JInterceptorsGroup jInterceptors;
            Object object = jinitClass.newInstance();
            if (object instanceof org.ow2.carol.rmi.interceptor.spi.JInitializer) {
                org.ow2.carol.rmi.interceptor.spi.JInitializer jinit = (org.ow2.carol.rmi.interceptor.spi.JInitializer)object;
                this.jrmpInfo.clear();
                jinit.preInit(this.jrmpInfo);
                jinit.postInit(this.jrmpInfo);
                jInterceptors = new JInterceptorsGroup(jinitClassname, this.jrmpInfo.getServerRequestInterceptors(), this.jrmpInfo.getClientRequestInterceptors());
            } else {
                JInitializer jinit = (JInitializer)object;
                this.legacyJrmpInfo.clear();
                jinit.pre_init(this.legacyJrmpInfo);
                jinit.post_init(this.legacyJrmpInfo);
                jInterceptors = new JInterceptorsGroup(jinitClassname, JInterceptorConverter.convertJServerRequestInterceptor(this.legacyJrmpInfo.getServerRequestInterceptors()), JInterceptorConverter.convertJClientRequestInterceptor(this.legacyJrmpInfo.getClientRequestInterceptors()));
            }
            this.jinterceptorsList.add(jInterceptors);
            this.resetRemoteInterceptors();
        }
        catch (Exception e) {
            TraceCarol.error("Cannot add interceptors for class " + jinitClassname, e);
        }
    }

    public synchronized void removeLocalInterceptor(Class<? extends org.ow2.carol.rmi.interceptor.spi.JInitializer> jinitClass) {
        Iterator<JInterceptorsGroup> iterator = this.jinterceptorsList.iterator();
        while (iterator.hasNext()) {
            JInterceptorsGroup interceptors = iterator.next();
            if (!interceptors.getInitializer().equals(jinitClass.getName())) continue;
            iterator.remove();
            break;
        }
        this.resetRemoteInterceptors();
    }

    private void resetRemoteInterceptors() {
        this.rcis = JInterceptorHelper.getInterceptorsByType(this.jinterceptorsList).getJClientRequestInterceptors();
    }

    public String[] getJRMPInitializers() {
        ArrayList<String> jrmpInitializers = new ArrayList<String>();
        for (JInterceptorsGroup jInterceptorsGroup : this.jinterceptorsList) {
            jrmpInitializers.add(jInterceptorsGroup.getInitializer());
        }
        return jrmpInitializers.toArray(new String[jrmpInitializers.size()]);
    }

    public JClientRequestInterceptor[] getRemoteClientInterceptors() {
        return this.rcis;
    }

    public JServerRequestInterceptor[] getLocalServerInterceptors() {
        return JInterceptorHelper.getInterceptorsByType(this.jinterceptorsList).getJServerRequestInterceptors();
    }

    public JClientRequestInterceptor[] getLocalClientInterceptors() {
        return JInterceptorHelper.getInterceptorsByType(this.jinterceptorsList).getJClientRequestInterceptors();
    }
}

