/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.delegate;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class UtilDelegateImpl
implements UtilDelegate {
    private static Logger logger = Logger.getLogger(UtilDelegateImpl.class.getName());
    private static UtilDelegate proxied = null;

    public UtilDelegateImpl() {
        String[] vendorDelegates = new String[]{"com.sun.corba.se.internal.POA.ShutdownUtilDelegate", "com.sun.corba.se.impl.javax.rmi.CORBA.Util", "com.ibm.CORBA.iiop.UtilDelegateImpl"};
        Class<?> clz = null;
        for (int ii = 0; ii < vendorDelegates.length; ++ii) {
            try {
                clz = Class.forName(vendorDelegates[ii]);
                break;
            }
            catch (ClassNotFoundException ex) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, "The class '" + vendorDelegates[ii] + "' was not found.", ex);
                continue;
            }
        }
        if (clz == null) {
            throw new RuntimeException("Couldn't load any of these: " + Arrays.asList(vendorDelegates));
        }
        try {
            proxied = (UtilDelegate)clz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(clz.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(clz.getName() + " does not have a public constructor", ex);
        }
    }

    public Object copyObject(Object obj, ORB orb) throws RemoteException {
        return proxied.copyObject(obj, orb);
    }

    public Object[] copyObjects(Object[] objs, ORB orb) throws RemoteException {
        return proxied.copyObjects(objs, orb);
    }

    public ValueHandler createValueHandler() {
        return proxied.createValueHandler();
    }

    public String getCodebase(Class clz) {
        return proxied.getCodebase(clz);
    }

    public Tie getTie(Remote target) {
        return proxied.getTie(target);
    }

    public boolean isLocal(Stub stub) throws RemoteException {
        return proxied.isLocal(stub);
    }

    public Class loadClass(String className, String remoteCodebase, ClassLoader loader) throws ClassNotFoundException {
        try {
            return proxied.loadClass(className, remoteCodebase, loader);
        }
        catch (ClassNotFoundException ex) {
            ClassNotFoundException cnfe = ex;
            if (className.endsWith("Tie")) {
                String prefix = "org.omg.stub.";
                String mangledName = className.startsWith("org.omg.stub.") ? className.substring("org.omg.stub.".length()) : "org.omg.stub." + className;
                return proxied.loadClass(mangledName, remoteCodebase, loader);
            }
            throw cnfe;
        }
    }

    public RemoteException mapSystemException(SystemException ex) {
        if (ex instanceof TRANSACTION_REQUIRED) {
            RemoteException remoteException = null;
            Class<?> exceptionClass = null;
            try {
                exceptionClass = Thread.currentThread().getContextClassLoader().loadClass("javax.transaction.TransactionRequiredException");
                remoteException = (RemoteException)exceptionClass.newInstance();
            }
            catch (Exception e) {
                remoteException = new TransactionRequiredException("TRANSACTION_REQUIRED");
            }
            remoteException.detail = ex;
            return remoteException;
        }
        if (ex instanceof TRANSACTION_ROLLEDBACK) {
            RemoteException remoteException = null;
            Class<?> exceptionClass = null;
            try {
                exceptionClass = Thread.currentThread().getContextClassLoader().loadClass("javax.transaction.TransactionRolledbackException");
                remoteException = (RemoteException)exceptionClass.newInstance();
            }
            catch (Exception e) {
                remoteException = new TransactionRolledbackException("TRANSACTION_ROLLEDBACK");
            }
            remoteException.detail = ex;
            return remoteException;
        }
        if (ex instanceof INVALID_TRANSACTION) {
            RemoteException remoteException = null;
            Class<?> exceptionClass = null;
            try {
                exceptionClass = Thread.currentThread().getContextClassLoader().loadClass("javax.transaction.InvalidTransactionException");
                remoteException = (RemoteException)exceptionClass.newInstance();
            }
            catch (Exception e) {
                remoteException = new InvalidTransactionException("INVALID_TRANSACTION");
            }
            remoteException.detail = ex;
            return remoteException;
        }
        return proxied.mapSystemException(ex);
    }

    public Object readAny(InputStream in) {
        return proxied.readAny(in);
    }

    public void registerTarget(Tie tie, Remote target) {
        proxied.registerTarget(tie, target);
    }

    public void unexportObject(Remote target) throws NoSuchObjectException {
        proxied.unexportObject(target);
    }

    public RemoteException wrapException(Throwable orig) {
        return proxied.wrapException(orig);
    }

    public void writeAbstractObject(OutputStream out, Object obj) {
        proxied.writeAbstractObject(out, obj);
    }

    public void writeAny(OutputStream out, Object obj) {
        proxied.writeAny(out, obj);
    }

    public void writeRemoteObject(OutputStream out, Object obj) {
        proxied.writeRemoteObject(out, obj);
    }
}

