/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ha.interceptor.jrmp;

import java.io.IOException;
import java.util.Stack;
import org.ow2.carol.rmi.interceptor.api.JClientRequestInfo;
import org.ow2.carol.rmi.interceptor.spi.JClientRequestInterceptor;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HAContext;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.cmi.ha.interceptor.jrmp.HAServiceContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class HAClientInterceptor
implements JClientRequestInterceptor {
    private static final long serialVersionUID = 7391445843768730939L;
    private String interceptorName = "HAClientInterceptor";
    private static Log logger = LogFactory.getLog(HAClientInterceptor.class);

    public String name() {
        return this.interceptorName;
    }

    public void sendRequest(JClientRequestInfo jri) throws IOException {
        HACurrent current = HACurrent.getHACurrent();
        HAContext newHACtx = new HAContext();
        Stack<RequestId> requests = current.getRequests();
        newHACtx.setRequests(requests);
        newHACtx.setOnFailover(current.isOnFailover());
        logger.debug("Propagating requests chain: " + newHACtx, new Object[0]);
        HAServiceContext haServiceContext = new HAServiceContext(newHACtx);
        jri.addRequestServiceContext(haServiceContext);
    }

    public void receiveReply(JClientRequestInfo jri) throws IOException {
        this.getHAContext(jri);
    }

    public void receiveException(JClientRequestInfo jri) throws IOException {
        this.getHAContext(jri);
    }

    public void receiveOther(JClientRequestInfo jri) throws IOException {
        this.getHAContext(jri);
    }

    public void sendPoll(JClientRequestInfo jri) throws IOException {
    }

    private void getHAContext(JClientRequestInfo jri) {
        HAServiceContext receivedCtx = (HAServiceContext)jri.getRequestServiceContext(HAServiceContext.HA_CTX_ID);
        if (receivedCtx == null) {
            return;
        }
        logger.debug("receivedCtx: " + receivedCtx, new Object[0]);
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = ((HAContext)receivedCtx.getContextData()).getRequests();
        current.setRequests(requests);
    }
}

