/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.injection.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.injection.api.ArchiveInjectionException;
import org.ow2.easybeans.resolver.api.EZBJNDIBeanData;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.easybeans.resolver.api.EZBRemoteJNDIResolver;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.metadata.car.api.ICarDeployableMetadata;
import org.ow2.util.ee.metadata.car.impl.CarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.helper.MethodHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JClass;
import org.ow2.util.scan.api.metadata.structures.JField;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveInjection {
    private static Log logger = LogFactory.getLog(ArchiveInjection.class);
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final int GETTER_LENGTH = "get".length();
    private IArchive archive = null;
    private boolean analyzed = false;
    private EZBRemoteJNDIResolver jndiResolver = null;
    private Collection<? extends ICommonClassMetadata<? extends ICommonClassMetadata<?, ?, ?>, ? extends ICommonMethodMetadata<?, ?, ?>, ? extends ICommonFieldMetadata<?, ?, ?>>> metadataCollection = null;

    public ArchiveInjection(IArchive archive) {
        this.archive = archive;
    }

    public ArchiveInjection(ICarDeployableMetadata carMetadata) {
        this.metadataCollection = carMetadata.getCarClassMetadataCollection();
        this.analyzed = true;
    }

    public void analyze(ClassLoader classLoader) throws ArchiveInjectionException {
        ICarDeployableMetadata carDeployableMetadata;
        IDeployable<?> deployable = null;
        try {
            deployable = DeployableHelper.getDeployable(this.archive);
        }
        catch (DeployableHelperException e) {
            throw new ArchiveInjectionException("Unable to get a deployable on archive '" + this.archive + "'.", e);
        }
        if (CARDeployable.class.isInstance(deployable)) {
            carDeployableMetadata = null;
            try {
                carDeployableMetadata = new CarDeployableMetadataFactory().createDeployableMetadata((CARDeployable)CARDeployable.class.cast(deployable), classLoader);
            }
            catch (DeployableMetadataException e) {
                throw new ArchiveInjectionException("Unable to get metadata on archive '" + this.archive + "'.", e);
            }
        } else {
            throw new UnsupportedOperationException("Can only manage injection for Client Deployable. Deployable found is '" + deployable + "'.");
        }
        this.metadataCollection = carDeployableMetadata.getCarClassMetadataCollection();
        this.analyzed = true;
    }

    public void init(Class<?> clazz) throws ArchiveInjectionException {
        if (!this.analyzed) {
            this.analyze(clazz.getClassLoader());
        }
        LinkedList listClasses = new LinkedList();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            listClasses.addFirst(currentClass);
        }
        for (Class clazz2 : listClasses) {
            ICommonClassMetadata<? extends ICommonClassMetadata<?, ?, ?>, ? extends ICommonMethodMetadata<?, ?, ?>, ? extends ICommonFieldMetadata<?, ?, ?>> classMetadata = this.getClassMetadata(clazz2);
            if (classMetadata == null) continue;
            this.inject(classMetadata, clazz2, null);
        }
    }

    protected void inject(ISharedMetadata sharedMetadata, Class<?> clazz, Object instance) throws ArchiveInjectionException {
        IJaxwsWebServiceRef jaxwsWSR;
        IJavaxPersistenceUnit jJavaxPersistenceUnit;
        IJAnnotationResource jAnnotationResource;
        IJEjbEJB jejb = sharedMetadata.getJEjbEJB();
        if (jejb != null) {
            jejb.setBeanInterface(this.getInterfaceName(sharedMetadata));
            this.injectEJB(jejb, sharedMetadata, clazz, instance);
        }
        if ((jAnnotationResource = sharedMetadata.getJAnnotationResource()) != null) {
            jAnnotationResource.setType(this.getInterfaceName(sharedMetadata));
            this.injectResource(jAnnotationResource, sharedMetadata, clazz, instance);
        }
        if ((jJavaxPersistenceUnit = sharedMetadata.getJavaxPersistenceUnit()) != null) {
            this.injectPersistenceUnit(jJavaxPersistenceUnit, sharedMetadata, clazz, instance);
        }
        if ((jaxwsWSR = sharedMetadata.getJaxwsWebServiceRef()) != null) {
            jaxwsWSR.setType(this.getInterfaceName(sharedMetadata));
            this.injectWebServiceRef(jaxwsWSR, sharedMetadata, clazz, instance);
        }
    }

    public void inject(ICommonClassMetadata commonMetadata, Class<?> clazz, Object instance) throws ArchiveInjectionException {
        ArrayList postConstructMethods = new ArrayList();
        ArrayList<ICommonMethodMetadata> preDestroyMethods = new ArrayList<ICommonMethodMetadata>();
        Iterator itField = commonMetadata.getStandardFieldMetadataCollection().iterator();
        while (itField.hasNext()) {
            this.inject((ISharedMetadata)itField.next(), clazz, instance);
        }
        for (ICommonMethodMetadata methodMetadata : commonMetadata.getStandardMethodMetadataCollection()) {
            this.inject(methodMetadata, clazz, instance);
            if (methodMetadata.isPostConstruct()) {
                postConstructMethods.add(methodMetadata);
            }
            if (!methodMetadata.isPreDestroy()) continue;
            preDestroyMethods.add(methodMetadata);
        }
        this.invokePostConstructMethods(postConstructMethods, clazz, instance);
    }

    protected void injectWebServiceRef(IJaxwsWebServiceRef jaxwsWSR, ISharedMetadata sharedMetadata, Class<?> clazz, Object instance) throws ArchiveInjectionException {
        String encName = this.buildENCName(jaxwsWSR.getName(), sharedMetadata);
        Object value = null;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
        }
        catch (NamingException e) {
            logger.error("There was no Web Service Ref bound with ENC name ''{0}'' in the registry. Cannot inject it on metadata ''{1}''.", encName, sharedMetadata, e);
            return;
        }
        this.setValue(sharedMetadata, clazz, instance, value);
    }

    protected void invokePostConstructMethods(List<ICommonMethodMetadata<?, ?, ?>> postConstructMethods, Class<?> clazz, Object instance) throws ArchiveInjectionException {
        if (postConstructMethods == null) {
            return;
        }
        for (ICommonMethodMetadata<?, ?, ?> postConstructMethodMetadata : postConstructMethods) {
            Method postConstructMethod = null;
            try {
                postConstructMethod = clazz.getDeclaredMethod(postConstructMethodMetadata.getJMethod().getName(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            boolean accessible = postConstructMethod.isAccessible();
            try {
                postConstructMethod.setAccessible(true);
                postConstructMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            catch (InvocationTargetException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            finally {
                postConstructMethod.setAccessible(accessible);
            }
        }
    }

    public void injectEJB(IJEjbEJB ejb, ISharedMetadata sharedMetadata, Class<?> clazz, Object instance) throws ArchiveInjectionException {
        String interfaceName = ejb.getBeanInterface();
        String beanName = ejb.getBeanName();
        String mappedName = ejb.getMappedName();
        String encName = this.buildENCName(ejb.getName(), sharedMetadata);
        boolean needToBind = true;
        Object value = null;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
            needToBind = false;
        }
        catch (NamingException e) {
            logger.debug("Value for ENC '{0}' not bound in the registry", encName);
        }
        if (value == null) {
            String jndiName = null;
            jndiName = mappedName != null ? mappedName : this.getRemoteEJBJNDIName(interfaceName, beanName);
            try {
                value = new InitialContext().lookup(jndiName);
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("Cannot get object with JNDI Name '" + jndiName + "' for ejb '" + ejb + "'.", e);
            }
        }
        this.setValue(sharedMetadata, clazz, instance, value);
        if (needToBind) {
            this.bindValue(encName, value);
        }
    }

    public void injectPersistenceUnit(IJavaxPersistenceUnit jJavaxPersistenceUnit, ISharedMetadata sharedMetadata, Class<?> clazz, Object instance) throws ArchiveInjectionException {
        String name = jJavaxPersistenceUnit.getName();
        Object value = null;
        String encName = this.buildENCName(jJavaxPersistenceUnit.getName(), sharedMetadata);
        boolean needToBind = true;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
            needToBind = false;
        }
        catch (NamingException e) {
            logger.debug("Value for ENC '{0}' not bound in the registry", encName);
        }
        if (value == null) {
            try {
                value = new InitialContext().lookup(name);
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("Cannot get object with JNDI Name '" + name + "' for Resource '" + jJavaxPersistenceUnit + "'.", e);
            }
        }
        this.setValue(sharedMetadata, clazz, instance, value);
        if (needToBind) {
            this.bindValue(encName, value);
        }
    }

    public void injectResource(IJAnnotationResource jAnnotationResource, ISharedMetadata sharedMetadata, Class<?> clazz, Object instance) throws ArchiveInjectionException {
        if ("javax.transaction.UserTransaction".equals(jAnnotationResource.getType())) {
            jAnnotationResource.setMappedName("java:comp/UserTransaction");
        } else if ("org.omg.CORBA.ORB".equals(jAnnotationResource.getType())) {
            jAnnotationResource.setMappedName("java:comp/ORB");
        }
        String mappedName = jAnnotationResource.getMappedName();
        Object value = null;
        String encName = this.buildENCName(jAnnotationResource.getName(), sharedMetadata);
        boolean needToBind = true;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
            needToBind = false;
        }
        catch (NamingException e) {
            logger.debug("Value for ENC '{0}' not bound in the registry", encName);
        }
        if (value == null) {
            if (mappedName == null) {
                String messageDestinationLink = jAnnotationResource.getMessageDestinationLink();
                if (messageDestinationLink == null) {
                    logger.warn("Injection of @Resource for {0} is not supported", jAnnotationResource);
                    return;
                }
                mappedName = this.getRemoteMessageDestinationJNDIName(messageDestinationLink);
            }
            try {
                value = new InitialContext().lookup(mappedName);
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("Cannot get object with JNDI Name '" + mappedName + "' for Resource '" + jAnnotationResource + "'.", e);
            }
        }
        this.setValue(sharedMetadata, clazz, instance, value);
        if (needToBind) {
            this.bindValue(encName, value);
        }
    }

    protected void bindValue(String encName, Object value) {
        try {
            new InitialContext().bind("java:comp/env/" + encName, value);
        }
        catch (NamingException e) {
            logger.warn("Unable to bind the value for ENC '{0}'.", encName);
        }
    }

    protected void setValue(ISharedMetadata sharedMetadata, Class<?> clazz, Object instance, Object value) throws ArchiveInjectionException {
        if (sharedMetadata instanceof ICommonFieldMetadata) {
            this.setFieldValue((ICommonFieldMetadata)sharedMetadata, clazz, instance, value);
        } else if (sharedMetadata instanceof ICommonMethodMetadata) {
            this.setMethodValue((ICommonMethodMetadata)sharedMetadata, clazz, instance, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMethodValue(ICommonMethodMetadata<?, ?, ?> methodMetadata, Class<?> clazz, Object instance, Object value) throws ArchiveInjectionException {
        JMethod jMethod = methodMetadata.getJMethod();
        Method method = MethodHelper.getMethod(jMethod, clazz);
        boolean accessible = method.isAccessible();
        try {
            method.setAccessible(true);
            try {
                method.invoke(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveInjectionException("Cannot set given value on the method '" + jMethod + "'.", e);
            }
            catch (IllegalArgumentException e) {
                throw new ArchiveInjectionException("Cannot set given value on the method '" + jMethod + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new ArchiveInjectionException("Cannot set given value on the method '" + jMethod + "'.", e);
            }
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFieldValue(ICommonFieldMetadata<?, ?, ?> fieldMetadata, Class<?> clazz, Object instance, Object value) throws ArchiveInjectionException {
        JField jField = fieldMetadata.getJField();
        Field field = null;
        try {
            field = clazz.getDeclaredField(jField.getName());
        }
        catch (NoSuchFieldException e) {
            throw new ArchiveInjectionException("Cannot get field '" + jField + "' on the class '" + clazz.getName() + "'", e);
        }
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveInjectionException("Cannot set given value on the field '" + jField + "'.", e);
            }
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected String buildENCName(String name, ISharedMetadata sharedMetadata) {
        String encName = name;
        if (encName == null || "".equals(encName)) {
            if (sharedMetadata instanceof ICommonFieldMetadata) {
                ICommonFieldMetadata fieldMetadata = (ICommonFieldMetadata)sharedMetadata;
                encName = ((ICommonClassMetadata)fieldMetadata.getClassMetadata()).getJClass().getName().replace("/", ".") + "/" + fieldMetadata.getJField().getName();
            } else if (sharedMetadata instanceof ICommonMethodMetadata) {
                ICommonMethodMetadata methodMetaData = (ICommonMethodMetadata)sharedMetadata;
                StringBuilder propertyBuilder = new StringBuilder(methodMetaData.getJMethod().getName());
                propertyBuilder.delete(0, GETTER_LENGTH);
                propertyBuilder.setCharAt(0, Character.toLowerCase(propertyBuilder.charAt(0)));
                String descriptor = ((ICommonClassMetadata)methodMetaData.getClassMetadata()).getJClass().getName();
                propertyBuilder.insert(0, descriptor.replace("/", ".") + "/");
                encName = propertyBuilder.toString();
            }
        }
        return encName;
    }

    protected EZBRemoteJNDIResolver getJNDIResolver() throws ArchiveInjectionException {
        if (this.jndiResolver == null) {
            Object o = null;
            try {
                o = new InitialContext().lookup("EZB_Remote_JNDIResolver");
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("No Remote EJB3 JNDI Resolver found", e);
            }
            this.jndiResolver = (EZBRemoteJNDIResolver)PortableRemoteObject.narrow((Object)o, EZBRemoteJNDIResolver.class);
        }
        return this.jndiResolver;
    }

    protected String getRemoteMessageDestinationJNDIName(String messageDestinationName) throws ArchiveInjectionException {
        String jndiName = null;
        List<EZBJNDIData> jndiDataList = null;
        try {
            jndiDataList = this.getJNDIResolver().getMessageDestinationJNDINames(messageDestinationName);
        }
        catch (RemoteException re) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + messageDestinationName + "'", re);
        }
        if (jndiDataList.size() == 0) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for message destination '" + messageDestinationName + "', no data was found on the remote side.");
        }
        if (jndiDataList.size() > 1) {
            logger.warn("There may be a problem for message destination '" + messageDestinationName + "', too many answers : '" + jndiDataList + "'. Using the first entry", new Object[0]);
        }
        EZBJNDIData jndiData = jndiDataList.get(0);
        jndiName = jndiData.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("Found JNDI Name '" + jndiName + "' for message destination '" + messageDestinationName + "', answers : '" + jndiDataList + "'.", new Object[0]);
        }
        return jndiName;
    }

    protected String getRemoteEJBJNDIName(String interfaceName, String beanName) throws ArchiveInjectionException {
        String jndiName = null;
        List<EZBJNDIBeanData> jndiDataList = null;
        try {
            jndiDataList = this.getJNDIResolver().getEJBJNDINames(interfaceName, beanName);
        }
        catch (RemoteException re) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + interfaceName + "'/'" + beanName + "'", re);
        }
        if (jndiDataList.size() == 0) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + interfaceName + "'/'" + beanName + "', no data was found on the remote side.");
        }
        if (jndiDataList.size() > 1) {
            logger.warn("There may be a problem for bean '" + interfaceName + "'/'" + beanName + "', too many answers : '" + jndiDataList + "'. Using the first entry", new Object[0]);
        }
        EZBJNDIBeanData jndiData = jndiDataList.get(0);
        jndiName = jndiData.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("Found JNDI Name '" + jndiName + "' for '" + interfaceName + "'/'" + beanName + "', answers : '" + jndiDataList + "'.", new Object[0]);
        }
        return jndiName;
    }

    protected ICommonClassMetadata<? extends ICommonClassMetadata<?, ?, ?>, ? extends ICommonMethodMetadata<?, ?, ?>, ? extends ICommonFieldMetadata<?, ?, ?>> getClassMetadata(Class<?> clazz) {
        return this.getClassMetadata(clazz.getName());
    }

    protected ICommonClassMetadata<? extends ICommonClassMetadata<?, ?, ?>, ? extends ICommonMethodMetadata<?, ?, ?>, ? extends ICommonFieldMetadata<?, ?, ?>> getClassMetadata(String requestedClassName) {
        for (ICommonClassMetadata<ICommonClassMetadata<?, ?, ?>, ICommonMethodMetadata<?, ?, ?>, ICommonFieldMetadata<?, ?, ?>> tmpMetadata : this.metadataCollection) {
            String className;
            JClass jClass = tmpMetadata.getJClass();
            if (jClass == null || !requestedClassName.equals((className = jClass.getName()).replace('/', '.'))) continue;
            return tmpMetadata;
        }
        return null;
    }

    protected Type validateSetterMethod(ICommonMethodMetadata<?, ?, ?> methodMetaData) {
        JMethod jMethod = methodMetaData.getJMethod();
        if (!jMethod.getName().startsWith("set") || jMethod.getName().equalsIgnoreCase("set")) {
            throw new IllegalStateException("Method '" + jMethod + "' is invalid. Should be in the setter form setXXX().");
        }
        Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
        if (args.length != 1) {
            throw new IllegalStateException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
        }
        return args[0];
    }

    protected String getInterfaceName(ISharedMetadata sharedMetadata) {
        Type typeInterface = null;
        if (sharedMetadata instanceof ICommonFieldMetadata) {
            typeInterface = Type.getType(((ICommonFieldMetadata)sharedMetadata).getJField().getDescriptor());
        } else if (sharedMetadata instanceof ICommonMethodMetadata) {
            typeInterface = this.validateSetterMethod((ICommonMethodMetadata)sharedMetadata);
        }
        if (typeInterface == null) {
            logger.warn("Unable to proceed to injection of metadata ''{0}'' as no interface has been found", sharedMetadata);
            throw new IllegalArgumentException("Unable to proceed to injection of metadata '" + sharedMetadata + "' as no interface has been found");
        }
        return typeInterface.getClassName();
    }
}

