/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.resolver;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.resolver.CommonJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIBeanData;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerJNDIResolver
extends CommonJNDIResolver
implements EZBContainerJNDIResolver {
    private static Log logger = LogFactory.getLog(ContainerJNDIResolver.class);
    private URL containerURL = null;
    private EZBApplicationJNDIResolver applicationJNDIResolver = null;
    private Map<String, Map<String, EZBJNDIBeanData>> interfacesMap;
    private Map<String, EZBJNDIData> messageDestinationMap;

    public ContainerJNDIResolver(IArchive archive) {
        try {
            this.containerURL = archive.getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalArgumentException("Cannot get URL from archive '" + archive + "'.");
        }
        this.interfacesMap = new HashMap<String, Map<String, EZBJNDIBeanData>>();
        this.messageDestinationMap = new HashMap<String, EZBJNDIData>();
    }

    @Override
    public URL getURL() {
        return this.containerURL;
    }

    @Override
    public List<EZBJNDIBeanData> getEJBJNDINames(String interfaceName) {
        return this.getEJBJNDINames(interfaceName, null);
    }

    @Override
    public EZBApplicationJNDIResolver getApplicationJNDIResolver() {
        return this.applicationJNDIResolver;
    }

    @Override
    public void setApplicationJNDIResolver(EZBApplicationJNDIResolver applicationJNDIResolver) {
        this.applicationJNDIResolver = applicationJNDIResolver;
    }

    @Override
    public List<EZBJNDIBeanData> getEJBJNDINames(String interfaceName, String beanName) {
        return this.getEJBJNDINames(interfaceName, beanName, true);
    }

    @Override
    public List<EZBJNDIBeanData> getEJBJNDINames(String interfaceName, String beanName, boolean askParent) {
        Map<String, EZBJNDIBeanData> beansMap = this.interfacesMap.get(interfaceName);
        if (beansMap == null) {
            return this.getEJBJNDINameInEAR(interfaceName, beanName, askParent);
        }
        if (beanName == null || "".equals(beanName)) {
            Collection<EZBJNDIBeanData> beanValues = beansMap.values();
            if (beanValues == null || beanValues.isEmpty()) {
                return this.getEJBJNDINameInEAR(interfaceName, beanName, askParent);
            }
            return new ArrayList<EZBJNDIBeanData>(beanValues);
        }
        String newBeanname = beanName;
        if (beanName.indexOf("#") > 0) {
            newBeanname = beanName.split("#")[1];
            logger.debug("EJB-LINK not fully supported for interface '" + interfaceName + "', and bean name '" + beanName + "' in container '" + this.containerURL + "'.", new Object[0]);
        }
        ArrayList<EZBJNDIBeanData> beanDataList = new ArrayList<EZBJNDIBeanData>();
        EZBJNDIBeanData beanData = beansMap.get(newBeanname);
        if (beanData == null) {
            return this.getEJBJNDINameInEAR(interfaceName, newBeanname, askParent);
        }
        beanDataList.add(beanData);
        return beanDataList;
    }

    protected List<EZBJNDIBeanData> getEJBJNDINameInEAR(String interfaceName, String beanName, boolean enabled) {
        if (!enabled || this.applicationJNDIResolver == null) {
            return Collections.emptyList();
        }
        return this.applicationJNDIResolver.getEJBJNDINames(interfaceName, beanName);
    }

    @Override
    public void addEJBJNDIName(String interfaceName, EZBJNDIBeanData jndiData) {
        String beanName;
        EZBJNDIData existingData;
        Map<String, EZBJNDIBeanData> beansMap = this.interfacesMap.get(interfaceName);
        if (beansMap == null) {
            beansMap = new HashMap<String, EZBJNDIBeanData>();
            this.interfacesMap.put(interfaceName, beansMap);
        }
        if ((existingData = (EZBJNDIData)beansMap.get(beanName = jndiData.getBeanName())) != null) {
            logger.warn("Data already set for '" + jndiData + "' for the container URL '" + this.containerURL + "'.", new Object[0]);
        }
        beansMap.put(beanName, jndiData);
    }

    @Override
    public void addMessageDestinationJNDIName(String messageDestinationName, EZBJNDIData jndiData) {
        EZBJNDIData existingData = this.messageDestinationMap.get(messageDestinationName);
        if (existingData != null) {
            logger.warn("JNDI Name for Message destination name ''{0}'' was already set with value ''{1}}'", messageDestinationName, jndiData.getName());
        }
        this.messageDestinationMap.put(messageDestinationName, jndiData);
    }

    @Override
    public List<EZBJNDIData> getMessageDestinationJNDINames(String messageDestinationName) {
        return this.getMessageDestinationJNDINames(messageDestinationName, true);
    }

    @Override
    public List<EZBJNDIData> getMessageDestinationJNDINames(String messageDestinationName, boolean askParent) {
        EZBJNDIData data;
        ArrayList<EZBJNDIData> dataList = new ArrayList<EZBJNDIData>();
        String newMessageDestinationName = messageDestinationName;
        if (newMessageDestinationName.indexOf("#") > 0) {
            newMessageDestinationName = messageDestinationName.split("#")[1];
        }
        if ((data = this.messageDestinationMap.get(newMessageDestinationName)) == null) {
            return this.getMessageDestinationJNDINameInEAR(newMessageDestinationName, askParent);
        }
        dataList.add(data);
        return dataList;
    }

    protected List<EZBJNDIData> getMessageDestinationJNDINameInEAR(String messageDestinationName, boolean enabled) {
        if (!enabled || this.applicationJNDIResolver == null) {
            return Collections.emptyList();
        }
        return this.applicationJNDIResolver.getMessageDestinationJNDINames(messageDestinationName);
    }
}

