/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.jonas.cmi.internal.BundleContent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class CmiServiceHelper {
    public static final String CMI_CONFIGURATION_FILE_NAME = "cmi-config.xml";
    private static final Log LOGGER = LogFactory.getLog(CmiServiceHelper.class);
    private static final int BUFFER_SIZE = 1024;

    private CmiServiceHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String sendBundle(ServerClusterViewManager clusterViewManager, BundleContent bundle) throws FileNotFoundException {
        String archiveId;
        block14: {
            int len;
            LOGGER.debug("Sending new load balancing archive located at '" + bundle.getLocation() + "' step 2: trying to transfer data array of the archive to the server-side manager", new Object[0]);
            InputStream inputStream = null;
            archiveId = null;
            try {
                URL url = new URL(bundle.getLocation());
                inputStream = url.openStream();
            }
            catch (MalformedURLException e1) {
                LOGGER.error("Unable to send load balancing archive bacause:  ", e1);
            }
            catch (IOException e1) {
                LOGGER.error("Unable to send load balancing archive bacause: ", e1);
            }
            ByteArrayOutputStream baos = null;
            byte[] buf = new byte[1024];
            baos = new ByteArrayOutputStream();
            while ((len = inputStream.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] bytesOfFile = baos.toByteArray();
            archiveId = (String)clusterViewManager.addLoadBalancingArchive(bytesOfFile, bundle.getLocation(), bundle.getPolicyClasses(), bundle.getStrategyClasses());
            try {
                inputStream.close();
                baos.close();
            }
            catch (IOException e) {
                LOGGER.error(" Unable to close archive or stream for file located at ", bundle.getLocation());
            }
            break block14;
            catch (Exception e) {
                try {
                    LOGGER.error("Unable to send load balancing archive", e);
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                        baos.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error(" Unable to close archive or stream for file located at ", bundle.getLocation());
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                    baos.close();
                }
                catch (IOException e3) {
                    LOGGER.error(" Unable to close archive or stream for file located at ", bundle.getLocation());
                }
            }
        }
        return archiveId;
    }
}

