/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.ow2.jonas.deployment.common.xml.AbsJonasParam;
import org.ow2.jonas.deployment.common.xml.JonasPortComponentRef;
import org.ow2.jonas.deployment.common.xml.PortComponentRef;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.lib.util.I18n;

public class PortComponentRefDesc {
    private Class sei;
    private String pcLink = null;
    private PortComponentDesc pcDesc = null;
    private Properties stubProperties = null;
    private Properties callProperties = null;
    private QName wsdlPort = null;
    private static I18n i18n = I18n.getInstance(PortComponentRefDesc.class);

    public PortComponentRefDesc(ClassLoader classLoader, PortComponentRef pcr, JonasPortComponentRef jpcr) throws WSDeploymentDescException {
        String className = null;
        this.stubProperties = new Properties();
        this.callProperties = new Properties();
        try {
            className = pcr.getServiceEndpointInterface().trim();
            this.sei = classLoader.loadClass(className);
            if (pcr.getPortComponentLink() != null) {
                this.pcLink = pcr.getPortComponentLink().trim();
            }
            if (jpcr != null) {
                for (AbsJonasParam jp : jpcr.getJonasCallPropertyList()) {
                    this.callProperties.setProperty(jp.getParamName(), jp.getParamValue());
                }
                for (AbsJonasParam jp : jpcr.getJonasStubPropertyList()) {
                    this.stubProperties.setProperty(jp.getParamName(), jp.getParamValue());
                }
                if (jpcr.getWsdlPort() != null) {
                    this.wsdlPort = jpcr.getWsdlPort().getQName();
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new WSDeploymentDescException(PortComponentRefDesc.getI18n().getMessage("PortComponentRefDesc.seiNotFound", className), e);
        }
    }

    public String getPortComponentLink() {
        return this.pcLink;
    }

    public void setPortComponentDesc(PortComponentDesc pcd) {
        this.pcDesc = pcd;
    }

    public PortComponentDesc getPortComponentDesc() {
        return this.pcDesc;
    }

    public Class getSEI() {
        return this.sei;
    }

    public int hashCode() {
        return this.sei.getName().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PortComponentRefDesc)) {
            return false;
        }
        PortComponentRefDesc ref = (PortComponentRefDesc)other;
        if (!this.sei.getName().equals(ref.getSEI().getName())) {
            return false;
        }
        return this.pcLink.equals(ref.getPortComponentLink());
    }

    protected static I18n getI18n() {
        return i18n;
    }

    public Properties getCallProperties() {
        return this.callProperties;
    }

    public Properties getStubProperties() {
        return this.stubProperties;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }
}

