/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups.comm;

import java.net.UnknownHostException;
import org.jgroups.Address;
import org.jgroups.ExtendedReceiver;
import org.jgroups.Receiver;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.DuplicateServerNameException;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.base.comm.DiscMessage;
import org.ow2.jonas.discovery.jgroups.comm.api.DiscComm;
import org.ow2.jonas.discovery.jgroups.comm.exception.StopDiscException;
import org.ow2.jonas.discovery.jgroups.comm.handler.DiscCommGreetingHandler;
import org.ow2.jonas.discovery.jgroups.comm.handler.DiscCommHandlerImpl;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.cluster.jgroups.IChannel;

public class DiscCommManager
implements DiscComm {
    private IChannel comChannel = null;
    private Logger logger;
    boolean greetingTimeOutExceeded = false;
    private Address sourceAddr = null;
    private long startTime;
    private ExtendedReceiver discMesssageEventHandler = null;
    private String discoveryType = null;

    public DiscCommManager(String discoveryType) {
        this.discoveryType = discoveryType;
    }

    public void run() {
    }

    public void stop() {
        DiscEvent msg = null;
        try {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + JGroupsDiscoveryUtils.getInstance().getJonasName() + " Sending a STOPPING DiscEvent."));
            }
            msg = JGroupsDiscoveryUtils.createNotifMessage("stopping");
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)e);
        }
        if (msg != null) {
            try {
                this.sendNotif(null, msg);
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.DEBUG, (Object)" Unable to stop discovery \n");
            }
        }
        this.logger.log(BasicLevel.DEBUG, (Object)" STOPPING DiscEvent successfully sent.\n");
        this.freeMem();
    }

    public void start() throws StopDiscException {
        this.logger = Log.getLogger("org.ow2.jonas.discovery");
        this.comChannel = JGroupsDiscoveryUtils.getInstance().getComChannel();
        if (this.comChannel == null) {
            this.logger.log(BasicLevel.ERROR, (Object)"Bad initialization of JGroupsDiscoveryUtils");
            throw new StopDiscException("Bad initialization of JGroupsDiscoveryUtils");
        }
        this.sourceAddr = this.comChannel.getLocalAddress();
        DiscCommGreetingHandler greetingReceiver = new DiscCommGreetingHandler(this.sourceAddr);
        this.comChannel.setReceiver((Receiver)greetingReceiver);
        try {
            JGroupsDiscoveryUtils.send(null, JGroupsDiscoveryUtils.objectToBytes(JGroupsDiscoveryUtils.createDiscGreeting(true)));
        }
        catch (UnknownHostException e1) {
            throw new StopDiscException(e1.getMessage());
        }
        catch (Exception e1) {
            throw new StopDiscException(e1.getMessage());
        }
        try {
            this.receiveGreetingMessage();
        }
        catch (DuplicateServerNameException e) {
            this.freeMem();
            throw new StopDiscException(e.getMessage());
        }
        DiscEvent discEventMsg = null;
        try {
            discEventMsg = this.discoveryType.equals("CLUSTERD") ? JGroupsDiscoveryUtils.createNotifMessageForClusterd("starting up") : JGroupsDiscoveryUtils.createNotifMessage("starting up");
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)"DiscoveryComm:  Unable to create a notification message \n", (Throwable)e);
        }
        if (discEventMsg != null) {
            this.sendNotif(null, discEventMsg);
        }
        this.discMesssageEventHandler = new DiscCommHandlerImpl(this.sourceAddr, this.discoveryType);
        this.comChannel.setReceiver((Receiver)this.discMesssageEventHandler);
    }

    private boolean timeOutExceeded() {
        return System.currentTimeMillis() - this.startTime > (long)JGroupsDiscoveryUtils.getInstance().getGreetingAckTimeOut().intValue();
    }

    public void receiveGreetingMessage() throws DuplicateServerNameException {
        this.startTime = System.currentTimeMillis();
        while (!this.timeOutExceeded() && !JGroupsDiscoveryUtils.duplicateExceptionName) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.log(BasicLevel.ERROR, (Object)("InterruptedException when handling greeting message \n" + e));
            }
        }
        if (JGroupsDiscoveryUtils.duplicateExceptionName) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Duplicate server name exception occurred \n");
            throw new DuplicateServerNameException(JGroupsDiscoveryUtils.getInstance().getServerId(), JGroupsDiscoveryUtils.getInstance().getJonasName(), JGroupsDiscoveryUtils.getInstance().getDomainName());
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Time out exceeded: no DuplicateNameException \n GO on starting discovery service");
    }

    private void freeMem() {
        this.logger.log(BasicLevel.DEBUG, (Object)" Closing channel.\n");
        if (this.comChannel != null && this.comChannel.isOpen()) {
            this.comChannel.close();
        }
        this.logger.log(BasicLevel.DEBUG, (Object)" Channel successfully closed.\n");
        this.comChannel = null;
        this.logger = null;
        this.sourceAddr = null;
    }

    public void sendNotif(Address dest, DiscMessage msg) {
        this.logger.log(BasicLevel.DEBUG, (Object)"Attempting to multicast a starting discovery notification\n");
        try {
            JGroupsDiscoveryUtils.send(dest, JGroupsDiscoveryUtils.objectToBytes(msg));
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)e);
        }
        this.logger.log(BasicLevel.DEBUG, (Object)" Discovery notification successfully sent\n");
    }
}

