/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups.comm.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.Message;
import org.jgroups.View;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.comm.ClusterdDiscoveryEvent;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.base.comm.DiscGreeting;
import org.ow2.jonas.discovery.base.comm.DiscMessage;
import org.ow2.jonas.discovery.jgroups.comm.api.DiscCommReceiver;
import org.ow2.jonas.discovery.jgroups.utils.Data;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.util.Log;

public class DiscCommHandlerImpl
implements DiscCommReceiver {
    protected Logger logger = Log.getLogger("org.ow2.jonas.discovery");
    private DomainMonitor domainMonitor = null;
    private Address hostAddress = null;
    private DiscMessage discMsg = null;
    public String discoveryType = "SLAVE";
    protected String hostName = null;
    protected String multicastAddress = null;

    public DiscCommHandlerImpl(Address hostAddress, String discoveryType) {
        this.hostAddress = hostAddress;
        this.domainMonitor = DomainMonitor.getInstance();
        this.discoveryType = discoveryType;
        this.multicastAddress = null;
        this.hostName = JGroupsDiscoveryUtils.getInstance().getJonasName();
        try {
            this.multicastAddress = JGroupsDiscoveryUtils.getMulticastAddress().toString();
        }
        catch (Exception e1) {
            this.logger.log(BasicLevel.ERROR, (Object)("My name is" + this.hostName + " I was unable to get multicast address due to following error \n" + e1));
        }
    }

    public DiscCommHandlerImpl(Address hostAddress) {
        this.hostAddress = hostAddress;
        this.multicastAddress = null;
        this.hostName = JGroupsDiscoveryUtils.getInstance().getJonasName();
        try {
            this.multicastAddress = JGroupsDiscoveryUtils.getMulticastAddress().toString();
        }
        catch (Exception e1) {
            this.logger.log(BasicLevel.ERROR, (Object)("My name is" + this.hostName + " I was unable to get multicast address due to following error \n" + e1));
        }
    }

    public byte[] getState() {
        return null;
    }

    public void receive(Message msg) {
        Object objReceived = null;
        Data data = null;
        Address senderAddress = null;
        try {
            senderAddress = msg.getSrc();
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Exception occured in DiscCommHandlerImpl. Unable to get sender for received message." + e));
        }
        try {
            data = (Data)msg.getObject();
            objReceived = JGroupsDiscoveryUtils.bytesToObject(data);
            if (objReceived != null) {
                if (this.discoveryType.equals("MASTER")) {
                    if (objReceived instanceof ClusterdDiscoveryEvent) {
                        ClusterdDiscoveryEvent event = (ClusterdDiscoveryEvent)objReceived;
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ".I'm MASTER. A cluster daemon named " + event.getServerName() + " hosted on " + msg.getSrc() + " is telling me its state is: " + event.getState()));
                        this.logger.log(BasicLevel.DEBUG, (Object)" Notifying the domain monitor. \n");
                        this.domainMonitor.discoveryNotificationForClusterd(event);
                    } else if (objReceived instanceof DiscEvent) {
                        DiscEvent event = (DiscEvent)objReceived;
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ".I'm MASTER. A server named " + event.getServerName() + " hosted on " + msg.getSrc() + " is telling me its state is: " + event.getState()));
                        this.logger.log(BasicLevel.DEBUG, (Object)" Notifying the domain monitor. \n");
                        this.domainMonitor.discoveryNotification(event);
                    } else if (objReceived instanceof DiscGreeting) {
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm MASTER. Handling a discovery greeting from " + msg.getSrc() + " \n"));
                        this.handleGreeting((DiscGreeting)objReceived, senderAddress);
                    } else if (objReceived instanceof DiscMessage) {
                        DiscMessage mess = (DiscMessage)objReceived;
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm MASTER. Handling a discovery message from " + msg.getSrc() + " \n"));
                        JGroupsDiscoveryUtils.send(senderAddress, JGroupsDiscoveryUtils.objectToBytes(mess));
                    } else {
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm MASTER. Received an unknown message from " + msg.getSrc() + " \n"));
                    }
                } else if (this.discoveryType.equals("SLAVE")) {
                    if (objReceived instanceof DiscEvent) {
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ".I'm a SLAVE. \n"));
                        this.handleEvent((DiscEvent)objReceived, senderAddress);
                    } else if (objReceived instanceof DiscGreeting) {
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm SLAVE. Handling a discovery greeting from " + msg.getSrc() + " \n"));
                        this.handleGreeting((DiscGreeting)objReceived, senderAddress);
                    } else if (objReceived instanceof DiscMessage) {
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm SLAVE. Handling a discovery message from " + msg.getSrc() + " \n"));
                        JGroupsDiscoveryUtils.send(senderAddress, (DiscMessage)objReceived);
                    } else {
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm SLAVE. Received an unknown message from " + msg.getSrc() + " \n"));
                    }
                } else if (this.discoveryType.equals("CLUSTERD")) {
                    if (objReceived instanceof DiscEvent) {
                        DiscEvent event = (DiscEvent)objReceived;
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ".I'm CLUSTER DAEMON. A server named " + event.getServerName() + " hosted on " + msg.getSrc() + " is telling me its state is: " + event.getState()));
                        this.handleEvent((DiscEvent)objReceived, senderAddress);
                    } else if (objReceived instanceof DiscGreeting) {
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm CLUSTER DAEMON. Handling a disovery greeting from " + msg.getSrc() + " \n"));
                        this.handleGreeting((DiscGreeting)objReceived, senderAddress);
                    } else if (objReceived instanceof DiscMessage) {
                        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm CLUSTER DAEMON. Handling a disovery message from " + msg.getSrc() + " \n"));
                        JGroupsDiscoveryUtils.send(senderAddress, (DiscMessage)objReceived);
                    } else {
                        this.logger.log(BasicLevel.DEBUG, (Object)("SLAVE " + this.hostAddress + " Received unknown message type from host " + msg.getSrc()));
                    }
                } else {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Unknown discovery type " + this.hostAddress + " Received message from host " + msg.getSrc()));
                }
            } else {
                this.logger.log(BasicLevel.DEBUG, (Object)("Object received from" + msg.getSrc() + " Must not be null"));
            }
        }
        catch (IOException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" IOException occured in DiscCommReceiver. Unable to cast data received on network into Object. Received packet content must not be the expected one\n" + e));
        }
        catch (ClassNotFoundException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" ClassNotFoundException occured in DiscCommReceiver. Unable to cast data received on network into Object.\n" + e));
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Following exception occurred \n" + e));
        }
    }

    private void handleEvent(DiscEvent discEvent, Address add2Reply) {
        if (discEvent.getState().equalsIgnoreCase("starting up") && discEvent.isDiscoveryMaster()) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Handling discovery event received from starting master hosted on " + discEvent.getSourceAddress() + " on port " + discEvent.getSourcePort() + "\n"));
            DiscEvent discEventMsg = null;
            try {
                discEventMsg = this.discoveryType.equals("CLUSTERD") ? JGroupsDiscoveryUtils.createNotifMessageForClusterd("running") : JGroupsDiscoveryUtils.createNotifMessage("running");
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)"DiscoveryComm:  Unable to create a notification message \n", (Throwable)e);
            }
            if (discEventMsg != null) {
                this.sendNotif(add2Reply, discEventMsg);
            }
        }
    }

    public void sendNotif(Address dest, DiscMessage msg) {
        try {
            JGroupsDiscoveryUtils.send(dest, JGroupsDiscoveryUtils.objectToBytes(msg));
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)e);
        }
    }

    public void setState(byte[] arg0) {
    }

    public void block() {
    }

    public void suspect(Address arg0) {
        if (this.discMsg == null) {
            this.discMsg = new DiscMessage(JGroupsDiscoveryUtils.getInstance().getDiscIp(), JGroupsDiscoveryUtils.getInstance().getDiscPort());
        }
        try {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Sending 'are-you-alive' message to suspect member " + arg0));
            JGroupsDiscoveryUtils.send(arg0, JGroupsDiscoveryUtils.objectToBytes(this.discMsg));
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Unable To send 'are-you-alive' message to " + arg0), (Throwable)e);
        }
    }

    public void viewAccepted(View arg0) {
    }

    public byte[] getState(String arg0) {
        return null;
    }

    public void getState(OutputStream arg0) {
    }

    public void getState(String arg0, OutputStream arg1) {
    }

    public void setState(InputStream arg0) {
    }

    public void setState(String arg0, byte[] arg1) {
    }

    public void setState(String arg0, InputStream arg1) {
    }

    public void unblock() {
    }

    public Address getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(Address hostAddress) {
        this.hostAddress = hostAddress;
    }

    private void handleGreeting(DiscGreeting message, Address add2Reply) {
        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I'm " + JGroupsDiscoveryUtils.getInstance().getDiscType() + ". Handling discovery greeting from a server named " + message.getServerName() + " hosted on " + message.getSourceAddress() + "\n"));
        try {
            if (message.getState().equals("starting up")) {
                if (message.getDomainName().equals(JGroupsDiscoveryUtils.getInstance().getDomainName()) && message.getServerName().equals(JGroupsDiscoveryUtils.getInstance().getJonasName())) {
                    this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I will send DuplicateServerNameException to " + message.getSourceAddress() + " \n"));
                    DiscGreeting duplicateNameNotif = JGroupsDiscoveryUtils.createDiscGreeting(false);
                    JGroupsDiscoveryUtils.send(add2Reply, JGroupsDiscoveryUtils.objectToBytes(duplicateNameNotif));
                }
            } else if (message.getState().equals("duplicate server name found")) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" Received duplicate name notification from " + message.getSourceAddress() + " Named:  " + message.getServerName() + " on domain:" + message.getDomainName() + " with serverId: " + message.getServerId() + "\n"));
                this.logger.log(BasicLevel.DEBUG, (Object)" But Time out for (receiving)greeting messages has already expired \n");
            }
        }
        catch (ChannelClosedException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Unable to send Greeting response to host " + message.getSourceAddress() + ". JGroups Channel is closed\n" + (Object)((Object)e)));
        }
        catch (UnknownHostException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Unable to send Greeting response to host " + message.getSourceAddress() + ". Host is unknown \n" + e));
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Unable to send Greeting response to host " + message.getSourceAddress() + ". Following exception occurred \n" + e));
        }
    }
}

