/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Iterator;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.ee.jdbc.ConnectionImpl;
import org.ow2.jonas.ee.jdbc.DriverWrapper;
import org.ow2.jonas.ee.jdbc.ManagedConnectionFactoryImpl;
import org.ow2.jonas.ee.jdbc.MetaDataImpl;
import org.ow2.jonas.ee.jdbc.XAResourceImpl;

public class ManagedConnectionImpl
implements ManagedConnection,
LocalTransaction {
    public Logger trace = null;
    protected PrintWriter out = null;
    protected DataSource factory = null;
    protected HashSet cels = null;
    protected boolean inLocalTransaction = false;
    ManagedConnectionFactoryImpl mcf = null;
    Connection connection = null;
    PooledConnection poolCon = null;
    XAConnection xaCon = null;
    PasswordCredential pc = null;
    DriverWrapper wrapper = null;
    private XAResource xares;
    private boolean isAutoCommit = true;
    private boolean closed = false;
    private long[] sigList;
    private int maxSigs;
    private long signature;
    private long lastSig;
    private final boolean isDebugOn;

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl _mcf, PasswordCredential _pc, Connection _con, PooledConnection _pcon, XAConnection _xa, DriverWrapper wrp) {
        this.mcf = _mcf;
        this.pc = _pc;
        this.connection = _con;
        this.poolCon = _pcon;
        this.xaCon = _xa;
        this.wrapper = wrp;
        this.xares = null;
        this.out = this.mcf.pw;
        this.cels = new HashSet();
        this.maxSigs = 50;
        this.sigList = new long[this.maxSigs];
        this.signature = 0L;
        this.lastSig = 0L;
        this.trace = this.mcf.trace;
        this.isDebugOn = this.trace.isLoggable(BasicLevel.DEBUG);
    }

    public void signalEvent(int code, Object ch, Exception ex) {
        ConnectionEvent ce = null;
        ce = ex == null ? new ConnectionEvent(this, code) : new ConnectionEvent(this, code, ex);
        if (ch != null) {
            ce.setConnectionHandle(ch);
        }
        Iterator it = this.cels.iterator();
        block7: while (it.hasNext()) {
            switch (code) {
                case 1: {
                    ((ConnectionEventListener)it.next()).connectionClosed(ce);
                    continue block7;
                }
                case 2: {
                    ((ConnectionEventListener)it.next()).localTransactionStarted(ce);
                    continue block7;
                }
                case 3: {
                    ((ConnectionEventListener)it.next()).localTransactionCommitted(ce);
                    continue block7;
                }
                case 4: {
                    ((ConnectionEventListener)it.next()).localTransactionRolledback(ce);
                    continue block7;
                }
                case 5: {
                    ((ConnectionEventListener)it.next()).connectionErrorOccurred(ce);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal eventType: " + code);
        }
    }

    public synchronized boolean getAutoCommit() throws ResourceException {
        return this.isAutoCommit;
    }

    public synchronized void setAutoCommit(boolean ac) throws ResourceException {
        this.isAutoCommit = ac;
        try {
            if (this.connection != null) {
                this.connection.setAutoCommit(ac);
            }
        }
        catch (Exception e) {
            throw new ResourceException(e.getMessage());
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.cels.add(listener);
    }

    public synchronized void associateConnection(Object con) throws ResourceException {
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)("connection:" + con));
        }
        if (!(con instanceof ConnectionImpl)) {
            throw new ResourceException("The managedConnection cannot associate this connection: " + con);
        }
        ConnectionImpl ci = (ConnectionImpl)con;
        long sig = this.getNewSignature(true);
        ci.setSignature(sig);
    }

    public void cleanup() throws ResourceException {
        if (this.inLocalTransaction) {
            throw new IllegalStateException("A local transaction is not complete");
        }
        this.clearSignature();
    }

    public synchronized void destroy() throws ResourceException {
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)("destroy mc=" + this + " with connection=" + this.connection));
        }
        if (this.inLocalTransaction) {
            throw new IllegalStateException("in local transaction");
        }
        if (!this.isAutoCommit) {
            throw new IllegalStateException("in global transaction");
        }
        try {
            if (this.wrapper != null) {
                DriverManager.deregisterDriver(this.wrapper);
            }
        }
        catch (Exception ex) {
            this.trace.log(BasicLevel.ERROR, (Object)"Unable to deregister Driver wrapper", (Throwable)ex);
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.trace.log(BasicLevel.ERROR, (Object)"", (Throwable)e, (Object)"ManagedConnectionImpl", (Object)"destroy");
                throw new ResourceException(e);
            }
            this.connection = null;
            this.poolCon = null;
            this.xaCon = null;
            this.xares = null;
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)("subject:" + subject + " connectionRequest:" + cxRequestInfo));
        }
        long sig = this.getNewSignature(true);
        try {
            return new ConnectionImpl(this, this.connection, sig, this.out);
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"", (Throwable)e, (Object)"ManagedConnectionImpl", (Object)"getConnection");
            throw new ResourceException(e.getMessage());
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new MetaDataImpl(this);
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.inLocalTransaction) {
            throw new ResourceException("The managedConnection is already in a local transaction and an XA resource cannot be obtained");
        }
        if (this.xares == null) {
            if (this.xaCon != null) {
                try {
                    this.xares = this.xaCon.getXAResource();
                }
                catch (Exception ex) {
                    throw new ResourceException("Unable to obtain XAResource: ", ex);
                }
            } else if (this.isDebugOn) {
                this.trace.log(BasicLevel.DEBUG, (Object)"JDBC driver doesn't support XA, simulate it");
            }
            this.xares = new XAResourceImpl(this, this.xares);
        }
        return this.xares;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.cels.remove(listener);
    }

    public void setLogWriter(PrintWriter _out) {
        this.out = _out;
    }

    public void addSignature(long sig) {
        int off = -1;
        for (int i = 0; i < this.maxSigs; ++i) {
            if (this.sigList[i] != 0L) continue;
            off = i;
            break;
        }
        if (off > -1) {
            this.sigList[off] = sig;
        } else {
            this.maxSigs += 20;
            long[] tmp = new long[this.maxSigs];
            System.arraycopy(this.sigList, 0, tmp, 0, this.maxSigs - 20);
            this.sigList = tmp;
            this.sigList[this.maxSigs - 20] = sig;
        }
    }

    public void clearSignature() {
        for (int i = 0; i < this.maxSigs; ++i) {
            this.sigList[i] = 0L;
        }
        this.signature = 0L;
    }

    public void clearSignature(long sig, boolean clear) {
        for (int i = 0; i < this.maxSigs; ++i) {
            if (sig != this.sigList[i]) continue;
            this.sigList[i] = 0L;
            break;
        }
        if (clear) {
            this.signature = 0L;
        }
    }

    public void setSignature(long sig) {
        if (this.signature == 0L) {
            this.signature = sig;
        }
    }

    public long getSignature(long sig) {
        long retSig = 0L;
        if (sig > 0L) {
            for (int i = 0; i < this.maxSigs; ++i) {
                if (sig != this.sigList[i]) continue;
                retSig = sig;
                break;
            }
        }
        return retSig;
    }

    public long getSignature() {
        return this.signature;
    }

    public long getNewSignature(boolean setSig) {
        long sig = System.currentTimeMillis();
        if (sig <= this.lastSig && this.lastSig != 0L) {
            sig = this.lastSig++;
        }
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)("Sig is " + sig + " last Sig was " + this.lastSig));
        }
        this.lastSig = sig;
        this.addSignature(sig);
        if (setSig) {
            this.signature = sig;
        }
        return sig;
    }

    public void close(ConnectionImpl ch) throws ResourceException {
        this.clearSignature(ch.key, true);
        this.signalEvent(1, ch, null);
    }

    public void begin() throws ResourceException {
        if (this.inLocalTransaction) {
            throw new ResourceException("The managedConnection is already in a LocalTransaction");
        }
        try {
            this.inLocalTransaction = true;
            this.connection.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() throws ResourceException {
        try {
            this.connection.commit();
            this.connection.setAutoCommit(true);
            this.inLocalTransaction = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rollback() throws ResourceException {
        try {
            this.connection.rollback();
            this.connection.setAutoCommit(true);
            this.inLocalTransaction = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

