/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.modifier;

import java.io.File;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.AbsArchive;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.FileArchive;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.JarArchive;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.utils.ArchiveStorer;
import org.ow2.jonas.generators.genbase.utils.DirStorer;
import org.ow2.jonas.generators.genbase.utils.JarStorer;
import org.ow2.jonas.lib.util.Log;

public abstract class ArchiveModifier {
    private J2EEArchive archive;
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.genbase");

    public ArchiveModifier(J2EEArchive archive) {
        this.archive = archive;
    }

    public abstract Archive modify() throws GenBaseException;

    protected static Archive save(Config config, String outname, J2EEArchive archive) throws GenBaseException {
        ArchiveStorer storer = null;
        File endfile = new File(config.getOut(), outname);
        AbsArchive out = null;
        if (config.getSaveMode() == 0) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Saving '" + endfile + "' in packed form..."));
            }
            storer = new JarStorer(archive, endfile);
            storer.store();
            out = new JarArchive(endfile);
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Saving '" + endfile + "' in unpacked form..."));
            }
            storer = new DirStorer(archive, endfile);
            storer.store();
            out = new FileArchive(endfile);
        }
        return out;
    }

    protected Archive save(Config config, String outname) throws GenBaseException {
        return ArchiveModifier.save(config, outname, this.archive);
    }

    public static Logger getLogger() {
        return logger;
    }

    public J2EEArchive getArchive() {
        return this.archive;
    }
}

