/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.utils;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.jonas.deployment.client.JonasAppClientDTDs;
import org.ow2.jonas.deployment.client.JonasAppClientSchemas;
import org.ow2.jonas.deployment.common.lib.JEntityResolver;
import org.ow2.jonas.deployment.ear.EarDTDs;
import org.ow2.jonas.deployment.ear.EarSchemas;
import org.ow2.jonas.deployment.ejb.JonasEjbjarDTDs;
import org.ow2.jonas.deployment.ejb.JonasEjbjarSchemas;
import org.ow2.jonas.deployment.web.JonasWebAppDTDs;
import org.ow2.jonas.deployment.web.JonasWebAppSchemas;
import org.ow2.jonas.deployment.web.WebAppDTDs;
import org.ow2.jonas.deployment.web.WebAppSchemas;
import org.ow2.jonas.deployment.ws.JonasWsSchemas;
import org.ow2.jonas.deployment.ws.WsSchemas;
import org.ow2.jonas.generators.genbase.NoJ2EEWebservicesException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static DocumentBuilderFactory factory = null;
    private static final String J2EE_NS = "http://java.sun.com/xml/ns/j2ee";
    private static final String JONAS_NS = "http://www.objectweb.org/jonas/ns";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SESSION_BEAN = "jonas-session";
    private static final String ENTITY_BEAN = "jonas-entity";
    private static final String MESSAGE_BEAN = "jonas-message-driven";
    private static final String EJB_NAME = "ejb-name";
    private static final String SERVLET = "servlet";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String JONAS_SERVICE_REF = "jonas-service-ref";
    private static final String SR_NAME = "service-ref-name";

    private XMLUtils() {
    }

    private static DocumentBuilderFactory newFactory(boolean validating) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(validating);
        XMLUtils.setFactoryValidation(factory, validating);
        return factory;
    }

    private static void setFactoryValidation(DocumentBuilderFactory factory, boolean validating) {
        factory.setValidating(validating);
        factory.setIgnoringElementContentWhitespace(validating);
        factory.setAttribute("http://apache.org/xml/features/validation/schema", new Boolean(validating));
    }

    public static Document newDocument(InputStream is, String name, boolean isDTDsAllowed) throws ParserConfigurationException, SAXException, IOException, NoJ2EEWebservicesException {
        return XMLUtils.newDocument(is, name, isDTDsAllowed, true);
    }

    public static Document newDocument(InputStream is, String name, boolean isDTDsAllowed, boolean validate) throws NoJ2EEWebservicesException, ParserConfigurationException, SAXException, IOException {
        if (factory == null) {
            factory = XMLUtils.newFactory(validate);
        }
        if (factory.isValidating() != validate) {
            XMLUtils.setFactoryValidation(factory, validate);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (factory.isValidating()) {
            JEntityResolver jer = new JEntityResolver();
            jer.addSchemas(new WebAppSchemas());
            jer.addSchemas(new JonasWebAppSchemas());
            jer.addSchemas(new JonasEjbjarSchemas());
            jer.addSchemas(new JonasAppClientSchemas());
            jer.addSchemas(new EarSchemas());
            jer.addSchemas(new WsSchemas());
            jer.addSchemas(new JonasWsSchemas());
            jer.addDtds(new WebAppDTDs());
            jer.addDtds(new JonasWebAppDTDs());
            jer.addDtds(new JonasEjbjarDTDs());
            jer.addDtds(new JonasAppClientDTDs());
            jer.addDtds(new EarDTDs());
            builder.setEntityResolver(jer);
        }
        Document doc = builder.parse(is);
        is.close();
        if (doc.getDoctype() != null && !isDTDsAllowed) {
            throw new NoJ2EEWebservicesException(name + " use a DTD. Only XML Schema are accepted for J2EE 1.4 webservices");
        }
        return doc;
    }

    public static Element getBeanElement(Element base, String bName) {
        Element found = null;
        NodeList sessions = base.getElementsByTagNameNS(JONAS_NS, SESSION_BEAN);
        for (int i = 0; i < sessions.getLength() && found == null; ++i) {
            Element session = (Element)sessions.item(i);
            NodeList names = session.getElementsByTagNameNS(JONAS_NS, EJB_NAME);
            Element name = (Element)names.item(0);
            if (!name.getFirstChild().getNodeValue().equals(bName)) continue;
            found = session;
        }
        NodeList entities = base.getElementsByTagNameNS(JONAS_NS, ENTITY_BEAN);
        for (int i = 0; i < entities.getLength() && found == null; ++i) {
            Element entity = (Element)entities.item(i);
            NodeList names = entity.getElementsByTagNameNS(JONAS_NS, EJB_NAME);
            Element name = (Element)names.item(0);
            if (!name.getFirstChild().getNodeValue().equals(bName)) continue;
            found = entity;
        }
        NodeList messages = base.getElementsByTagNameNS(JONAS_NS, MESSAGE_BEAN);
        for (int i = 0; i < messages.getLength() && found == null; ++i) {
            Element message = (Element)messages.item(i);
            NodeList names = message.getElementsByTagNameNS(JONAS_NS, EJB_NAME);
            Element name = (Element)names.item(0);
            if (!name.getFirstChild().getNodeValue().equals(bName)) continue;
            found = message;
        }
        return found;
    }

    public static Element getServletElement(Element base, String sName) {
        Element found = null;
        NodeList servlets = base.getElementsByTagNameNS(J2EE_NS, SERVLET);
        for (int i = 0; i < servlets.getLength() && found == null; ++i) {
            Element servlet = (Element)servlets.item(i);
            NodeList names = servlet.getElementsByTagNameNS(J2EE_NS, SERVLET_NAME);
            Element name = (Element)names.item(0);
            if (!name.getFirstChild().getNodeValue().equals(sName)) continue;
            found = servlet;
        }
        return found;
    }

    public static Element getJonasServiceRef(Element base, String srName) {
        Element found = null;
        if (base != null) {
            NodeList jsrs = base.getElementsByTagNameNS(JONAS_NS, JONAS_SERVICE_REF);
            for (int i = 0; i < jsrs.getLength() && found == null; ++i) {
                Element jsr = (Element)jsrs.item(i);
                NodeList names = jsr.getElementsByTagNameNS(JONAS_NS, SR_NAME);
                Element name = (Element)names.item(0);
                if (name == null || !name.getFirstChild().getNodeValue().equals(srName)) continue;
                found = jsr;
            }
        }
        return found;
    }

    public static void cleanDummyApplication(Document doc) {
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagNameNS(J2EE_NS, "module");
        root.removeChild(nl.item(0));
    }

    public static void addEjb(Document app, Archive ejbjar) {
        Element module = app.createElementNS(J2EE_NS, "module");
        Element ejb = app.createElementNS(J2EE_NS, "ejb");
        Text ejbText = app.createTextNode(ejbjar.getRootFile().getName());
        ejb.appendChild(ejbText);
        module.appendChild(ejb);
        XMLUtils.insertModule(app, module);
    }

    public static void addClient(Document app, Archive client) {
        Element module = app.createElementNS(J2EE_NS, "module");
        Element clt = app.createElementNS(J2EE_NS, "java");
        Text cltText = app.createTextNode(client.getRootFile().getName());
        clt.appendChild(cltText);
        module.appendChild(clt);
        XMLUtils.insertModule(app, module);
    }

    public static void addWebApp(Document app, Archive webapp, String ctx) {
        Element module = app.createElementNS(J2EE_NS, "module");
        Element web = app.createElementNS(J2EE_NS, "web");
        Element webUri = app.createElementNS(J2EE_NS, "web-uri");
        Element context = app.createElementNS(J2EE_NS, "context-root");
        Text webText = app.createTextNode(webapp.getName());
        Text ctxText = app.createTextNode(ctx);
        webUri.appendChild(webText);
        context.appendChild(ctxText);
        web.appendChild(webUri);
        web.appendChild(context);
        module.appendChild(web);
        XMLUtils.insertModule(app, module);
    }

    private static void insertModule(Document app, Element module) {
        Element application = app.getDocumentElement();
        Element first = XMLUtils.findFirstSecurityRole(application);
        application.insertBefore(module, first);
    }

    private static Element findFirstSecurityRole(Element app) {
        NodeList nl = app.getElementsByTagNameNS(J2EE_NS, "security-role");
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    public static Document newJonasClient() {
        Document root = XMLUtils.createDocument();
        Element jonasClient = root.createElementNS(JONAS_NS, "jonas-client");
        String schema = JonasAppClientSchemas.getLastSchema();
        XMLUtils.addNamespaces(jonasClient, schema);
        root.appendChild(jonasClient);
        return root;
    }

    public static Document newJonasWeb() {
        Document root = XMLUtils.createDocument();
        Element jonasWebApp = root.createElementNS(JONAS_NS, "jonas-web-app");
        int index = JonasWebAppSchemas.JONAS_WEBAPP_SCHEMAS.length - 1;
        String schema = JonasWebAppSchemas.JONAS_WEBAPP_SCHEMAS[index];
        XMLUtils.addNamespaces(jonasWebApp, schema);
        root.appendChild(jonasWebApp);
        return root;
    }

    private static Document createDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return builder.newDocument();
    }

    private static void addNamespaces(Element e, String schema) {
        Document root = e.getOwnerDocument();
        Attr xmlns = root.createAttributeNS(XMLNS_NS, "xmlns");
        xmlns.setValue(JONAS_NS);
        Attr xsi = root.createAttributeNS(XMLNS_NS, "xmlns:xsi");
        xsi.setValue(XSI_NS);
        Attr schemaLocation = root.createAttributeNS(XSI_NS, "xsi:schemaLocation");
        schemaLocation.setValue("http://www.objectweb.org/jonas/ns http://www.objectweb.org/jonas/ns/" + schema);
        e.setAttributeNodeNS(xmlns);
        e.setAttributeNodeNS(xsi);
        e.setAttributeNodeNS(schemaLocation);
    }

    public static boolean isWebModuleAlreadyDeclared(Document app, String name) {
        Element found = null;
        NodeList modules = app.getElementsByTagNameNS(J2EE_NS, "module");
        for (int i = 0; i < modules.getLength() && found == null; ++i) {
            Element module = (Element)modules.item(i);
            NodeList webModules = module.getElementsByTagNameNS(J2EE_NS, "web");
            for (int j = 0; j < webModules.getLength() && found == null; ++j) {
                Element webModule = (Element)webModules.item(j);
                NodeList weburiModules = webModule.getElementsByTagNameNS(J2EE_NS, "web-uri");
                Element webUri = (Element)weburiModules.item(0);
                if (!webUri.getFirstChild().getNodeValue().equals(name)) continue;
                found = webUri;
            }
        }
        return found != null;
    }
}

