/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.Serializable;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.ow2.jonas.lib.ejb21.JavaTypesForSQL;

public class JavaType {
    private static Hashtable tableDefaultValues = new Hashtable();
    private static Hashtable tableWrapperType;

    public static boolean isVoid(Class c) {
        return c.equals(Void.TYPE);
    }

    public static String getName(Class c) {
        String name = c.isArray() ? JavaType.getName(c.getComponentType()) + "[]" : c.getName().replace('$', '.');
        return name;
    }

    public static boolean isSerializable(Class c) {
        boolean isSerializable = false;
        isSerializable = c.isArray() ? JavaType.isSerializable(c.getComponentType()) : (c.isPrimitive() ? true : Serializable.class.isAssignableFrom(c));
        return isSerializable;
    }

    public static boolean isValidForRmi(Class c) {
        return JavaType.isSerializable(c) || Remote.class.isAssignableFrom(c);
    }

    public static boolean isCollecOrEnum(Class c) {
        return Collection.class.isAssignableFrom(c) || Enumeration.class.isAssignableFrom(c);
    }

    public static String getSQLGetMethod(Class c) {
        return JavaTypesForSQL.getSQLGetMethod(c);
    }

    public static String getSQLSetMethod(Class c) {
        return JavaTypesForSQL.getSQLSetMethod(c);
    }

    public static boolean isXxxObjectMethod(String name) {
        return name.equals("getObject") || name.equals("setObject");
    }

    public static String getSQLType(Class c) {
        return JavaTypesForSQL.getSQLType(c);
    }

    public static String getDefaultValue(Class c) {
        String val = null;
        val = c.isPrimitive() ? (String)tableDefaultValues.get(c) : new String("null");
        if (val == null) {
            throw new Error("JavaType ERROR: No default value for the class " + c.getName());
        }
        return val;
    }

    public static String getWrapperType(Class c) {
        String val = null;
        val = c.isPrimitive() ? (String)tableWrapperType.get(c) : new String("");
        if (val == null) {
            throw new Error("JavaType ERROR: No wrapper type for the class " + c.getName());
        }
        return val;
    }

    public static Boolean toObject(boolean val) {
        return new Boolean(val);
    }

    public static Byte toObject(byte val) {
        return new Byte(val);
    }

    public static Short toObject(short val) {
        return new Short(val);
    }

    public static Integer toObject(int val) {
        return new Integer(val);
    }

    public static Long toObject(long val) {
        return new Long(val);
    }

    public static Float toObject(float val) {
        return new Float(val);
    }

    public static Double toObject(double val) {
        return new Double(val);
    }

    public static Character toObject(char val) {
        return new Character(val);
    }

    public static Object toObject(Object val) {
        return val;
    }

    public static String toStringObject(String name, Class c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return "Boolean.valueOf(" + name + ")";
            }
            if (c == Byte.TYPE) {
                return "new Byte(" + name + ")";
            }
            if (c == Character.TYPE) {
                return "new Character(" + name + ")";
            }
            if (c == Short.TYPE) {
                return "new Short(" + name + ")";
            }
            if (c == Integer.TYPE) {
                return "new Integer(" + name + ")";
            }
            if (c == Long.TYPE) {
                return "new Long(" + name + ")";
            }
            if (c == Float.TYPE) {
                return "new Float(" + name + ")";
            }
            if (c == Double.TYPE) {
                return "new Double(" + name + ")";
            }
            return name;
        }
        return name;
    }

    static {
        tableDefaultValues.put(Boolean.TYPE, "false");
        tableDefaultValues.put(Character.TYPE, "'\u0000'");
        tableDefaultValues.put(Byte.TYPE, "(byte)0");
        tableDefaultValues.put(Short.TYPE, "(short)0");
        tableDefaultValues.put(Integer.TYPE, "0");
        tableDefaultValues.put(Long.TYPE, "0L");
        tableDefaultValues.put(Float.TYPE, "0.0f");
        tableDefaultValues.put(Double.TYPE, "0.0d");
        tableWrapperType = new Hashtable();
        tableWrapperType.put(Boolean.TYPE, "java.lang.Boolean");
        tableWrapperType.put(Character.TYPE, "java.lang.Character");
        tableWrapperType.put(Byte.TYPE, "java.lang.Byte");
        tableWrapperType.put(Short.TYPE, "java.lang.Short");
        tableWrapperType.put(Integer.TYPE, "java.lang.Integer");
        tableWrapperType.put(Long.TYPE, "java.lang.Long");
        tableWrapperType.put(Float.TYPE, "java.lang.Float");
        tableWrapperType.put(Double.TYPE, "java.lang.Double");
    }
}

