/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha;

import java.util.Stack;
import javax.ejb.EntityContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.cmi.ha.ReplicationManager;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.SessionId;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.jonas.lib.ejb21.JSessionSwitch;
import org.ow2.jonas.lib.ejb21.JStatefulSwitch;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.ha.EntityBeanRefImpl;
import org.ow2.jonas.lib.ejb21.ha.StatefulBeanRefImpl;
import org.ow2.jonas.lib.ejb21.jorm.JEntityContext;
import org.ow2.jonas.lib.util.Log;

public class JRepUtil {
    protected static Logger cmilogger = Log.getLogger("org.ow2.jonas.lib.ejb21.ha");
    private static ReplicationManager repMgr = null;

    static boolean hasBackupResponse(RequestId requestId) {
        boolean result = false;
        if (cmilogger.isLoggable(BasicLevel.DEBUG)) {
            cmilogger.log(BasicLevel.DEBUG, (Object)(" for: " + requestId));
        }
        try {
            if (HACurrent.getHACurrent().isOnFailover()) {
                result = repMgr.hasBackupResponse(requestId);
            }
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Unable to obtain the info", (Throwable)e);
        }
        return result;
    }

    static void injectState(SessionId clusterOId, JStatefulSwitch bs) {
        if (cmilogger.isLoggable(BasicLevel.DEBUG)) {
            cmilogger.log(BasicLevel.DEBUG, (Object)(" for: " + clusterOId));
        }
        try {
            if (HACurrent.getHACurrent().isOnFailover()) {
                StatefulBeanRefImpl bean = new StatefulBeanRefImpl(bs);
                repMgr.restoreBeanChanges(clusterOId, bean);
            }
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Unable to replicate the state", (Throwable)e);
        }
    }

    static void preInvokeHook(JSessionSwitch bs, SessionId clusterOId, RequestCtx rctx) {
    }

    static void postInvokeHook(RequestCtx rctx, SessionId clusterOId, JSessionSwitch bs, boolean remove) {
        if (cmilogger.isLoggable(BasicLevel.DEBUG)) {
            cmilogger.log(BasicLevel.DEBUG, (Object)(" for: " + clusterOId));
        }
        HACurrent current = HACurrent.getHACurrent();
        RequestId rootId = null;
        try {
            Stack<RequestId> requests = current.getRequests();
            if (requests != null) {
                rootId = (RequestId)requests.get(0);
                if (remove) {
                    JRepUtil.addRemovedBean(clusterOId, rootId);
                } else {
                    JRepUtil.addModifiedBean((JStatefulSwitch)bs, clusterOId, rootId);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Don't need to be replicate.");
        }
    }

    static void addModifiedBean(JStatefulSwitch bs, SessionId clusterOId, RequestId rootId) {
        StatefulBeanRefImpl bean = new StatefulBeanRefImpl(bs);
        try {
            repMgr.addModifiedBean(rootId, clusterOId, bean);
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)("Unable to add modified bean: " + clusterOId), (Throwable)e);
        }
    }

    public static void addRemovedBean(SessionId clusterOId, RequestId rootId) {
        try {
            repMgr.addModifiedBean(rootId, clusterOId, null);
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)("Unable to add removed bean: " + clusterOId), (Throwable)e);
        }
    }

    public static void addEntityBean(EntityContext bctx, RequestId rootId) {
        EntityBeanRefImpl bean = new EntityBeanRefImpl((JEntityContext)bctx);
        try {
            repMgr.addEntityBean(rootId, bean);
        }
        catch (Exception e) {
            try {
                cmilogger.log(BasicLevel.ERROR, (Object)("Unable to add entity bean: " + bean.getPrimaryKey()), (Throwable)e);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    static void removeCurrentRequest() {
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty()) {
            requests.pop();
        }
    }

    public static ReplicationManager getRepMgr() {
        return repMgr;
    }

    public static void setRepMgr(ReplicationManager repMgr) {
        JRepUtil.repMgr = repMgr;
    }
}

