/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans;

import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.jmbeans.J2EEServer;
import org.ow2.jonas.lib.jmbeans.JavaVm;
import org.ow2.jonas.lib.jmbeans.log.LogBuffer;
import org.ow2.jonas.lib.jmbeans.log.LogManagement;
import org.ow2.jonas.lib.management.domain.J2EEDomain;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.management.reconfig.ReconfigManager;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class MBeansRegistration {
    private static final String LOG_CONFIGFILE = "jonas.log.configfile";
    private static final String DEF_LOG_CONFIGFILE = "trace";
    private String logConfigFile = null;
    private Log logger = LogFactory.getLog(MBeansRegistration.class);
    private JmxService jmxService = null;
    private String domainName = null;
    private String serverName = null;
    private J2EEServerService j2eeServer = null;
    private ServerProperties serverProperties = null;
    private ServiceManager serviceManager;
    private ConfigurationManager configurationManager = null;

    public void start() throws Exception {
        this.logger.debug("Starting jonas-mbeans bundle...", new Object[0]);
        try {
            this.domainName = this.serverProperties.getDomainName();
            this.serverName = this.serverProperties.getServerName();
            String logConfigFileName = this.serverProperties.getValue(LOG_CONFIGFILE, DEF_LOG_CONFIGFILE);
            org.ow2.jonas.lib.util.Log.configure(logConfigFileName);
            Properties logProperties = org.ow2.jonas.lib.util.Log.getProperties();
            this.logConfigFile = org.ow2.jonas.lib.util.Log.getConfigFileName();
            ((J2EEServer)this.j2eeServer).setServiceManager(this.serviceManager);
            ((J2EEServer)this.j2eeServer).setConfigManager(this.configurationManager);
            this.registerMBeans(this.serverProperties, logProperties);
        }
        catch (MalformedObjectNameException me) {
            this.logger.error("Failed to register mbeans: " + me.getMessage(), new Object[0]);
            return;
        }
        catch (Exception e) {
            this.logger.error("Failed to register mbeans" + e.getMessage(), new Object[0]);
            return;
        }
    }

    public void stop() throws Exception {
        this.logger.debug("Stopping jonas-mbeans bundle...", new Object[0]);
        if (this.jmxService != null) {
            this.unregisterMBeans(this.domainName, this.serverName);
        }
    }

    private void registerMBeans(ServerProperties serverProperties, Properties logProperties) throws Exception {
        String name = this.domainName + ":j2eeType=J2EEServer,name=" + this.serverName;
        ObjectName objectName = ObjectName.getInstance(name);
        ((J2EEServer)this.j2eeServer).setObjectName(objectName.toString());
        Package p = this.j2eeServer.getClass().getPackage();
        this.jmxService.loadDescriptors(p.getName(), this.getClass().getClassLoader());
        this.jmxService.registerModelMBean((Object)this.j2eeServer, objectName);
        this.logger.debug("MBeans registered: " + objectName, new Object[0]);
        ObjectName domainOn = J2eeObjectName.J2EEDomain(this.domainName);
        J2EEDomain domain = new J2EEDomain(domainOn.toString());
        domain.setJmxService(this.jmxService);
        boolean master = serverProperties.isMaster();
        domain.setMaster(master, this.serverName);
        this.jmxService.registerModelMBean((Object)domain, domainOn);
        this.logger.debug("MBeans registered: " + domainOn.toString(), new Object[0]);
        domain.setMyJ2EEServerOn(objectName.toString());
        String jvmName = this.serverName;
        objectName = J2eeObjectName.JVM(this.domainName, this.serverName, jvmName);
        JavaVm jvm = new JavaVm(objectName.toString(), serverProperties);
        this.jmxService.registerModelMBean((Object)jvm, objectName);
        this.logger.debug("MBeans registered: " + objectName.toString(), new Object[0]);
        ((J2EEServer)this.j2eeServer).addJavaVM(objectName.toString());
        this.logger.debug("MBeans registered: " + objectName, new Object[0]);
        String nameReconfigManager = this.domainName + ":type=management,name=reconfigManager";
        objectName = ObjectName.getInstance(nameReconfigManager);
        ReconfigManager reconfigManager = new ReconfigManager(objectName, serverProperties);
        reconfigManager.setJmxService(this.jmxService);
        reconfigManager.setLogConfigFileName(this.logConfigFile);
        reconfigManager.setServerConfigFileName(serverProperties.getPropFileName());
        reconfigManager.addMBeanServerDelegateListener();
        this.jmxService.registerModelMBean((Object)reconfigManager, objectName);
        this.logger.debug("MBeans registered: " + objectName.toString(), new Object[0]);
        String nameLogging = this.domainName + ":type=service,name=log";
        objectName = ObjectName.getInstance(nameLogging);
        LogManagement logManagement = new LogManagement();
        logManagement.setProps(logProperties);
        logManagement.setConfigFile(this.logConfigFile);
        this.jmxService.registerModelMBean((Object)logManagement, objectName);
        this.logger.debug("MBeans registered: " + objectName.toString(), new Object[0]);
        String nameLogBuffer = this.domainName + ":type=LogBuffer,name=logBuff";
        LogBuffer logBuffer = new LogBuffer("logBuff");
        this.jmxService.registerMBean((Object)logBuffer, nameLogBuffer);
    }

    private void unregisterMBeans(String domainName, String serverName) throws Exception {
        String name = domainName + ":j2eeType=J2EEServer,name=" + serverName;
        ObjectName objectName = ObjectName.getInstance(name);
        this.jmxService.unregisterModelMBean(objectName);
        this.logger.debug("MBeans unregistered: " + objectName.toString(), new Object[0]);
        String jvmName = serverName;
        objectName = J2eeObjectName.JVM(domainName, serverName, jvmName);
        this.jmxService.unregisterModelMBean(objectName);
        this.logger.debug("MBeans unregistered: " + objectName.toString(), new Object[0]);
        objectName = J2eeObjectName.J2EEDomain(domainName);
        this.jmxService.unregisterModelMBean(objectName);
        this.logger.debug("MBeans unregistered: " + objectName.toString(), new Object[0]);
        String nameLogBuffer = domainName + ":type=LogBuffer,name=logBuff";
        objectName = ObjectName.getInstance(nameLogBuffer);
        this.jmxService.unregisterMBean(objectName);
        String nameLogging = domainName + ":type=service,name=log";
        objectName = ObjectName.getInstance(nameLogging);
        this.jmxService.unregisterModelMBean(objectName);
        this.logger.debug("MBeans unregistered: " + objectName.toString(), new Object[0]);
        String nameReconfigManager = domainName + ":type=management,name=reconfigManager";
        objectName = ObjectName.getInstance(nameReconfigManager);
        this.jmxService.unregisterModelMBean(objectName);
        this.logger.debug("MBeans unregistered: " + objectName.toString(), new Object[0]);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void setJ2EEServer(J2EEServerService j2eeServer) {
        this.j2eeServer = j2eeServer;
    }

    public void setConfigurationManager(ConfigurationManager configManager) {
        this.configurationManager = configManager;
    }
}

