/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.base;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.management.extensions.base.AdminException;
import org.ow2.jonas.lib.management.extensions.base.AdminJmxHelper;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.base.ManagementException;
import org.ow2.jonas.lib.management.extensions.base.mbean.CatalinaObjectName;
import org.ow2.jonas.lib.management.extensions.server.ServerItem;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.util.JonasObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminHelper {
    public static final String EXCEPTION_MBEANSERVER_NOTFOUND = "error.mbeanserver.notfound";
    public static final String EXCEPTION_JONASSERVER_NOTFOUND = "error.jonasserver.notfound";
    public static final String EXCEPTION_MBEAN_J2EEDOMAIN_NOTFOUND = "error.mbean.j2eedomain.notfound";
    public static final String EXCEPTION_MBEAN_J2EESERVER_NOTFOUND = "error.mbean.j2eeserver.notfound";
    public static final String SESSION_NAME = "WhereAreYou";
    public static final String TAGS_IMAGES_ROOT_KEY = "tagsimagesroot";
    public static final String CONTEXT_MACRO = "${CONTEXT}";
    public static final String TREE_PAGE_REFRESH = "viewTree.do?select=";
    public static final String NODE_SEPARATOR = "*";
    public static final int DEPLOYMENT = 0;
    public static final int DEPLOYMENT_EAR = 1;
    public static final int DEPLOYMENT_JAR = 2;
    public static final int DEPLOYMENT_WAR = 3;
    public static final int DEPLOYMENT_RAR = 4;
    public static final int DEPLOYMENT_DATASOURCE = 5;
    public static final int DEPLOYMENT_JMS = 6;
    public static final int DEPLOYMENT_MAIL = 7;
    public static final int DOMAIN_DEPLOYMENT_EAR = 8;
    public static final int DOMAIN_DEPLOYMENT_JAR = 9;
    public static final int DOMAIN_DEPLOYMENT_WAR = 10;
    public static final int DOMAIN_DEPLOYMENT_RAR = 11;
    public static final String DEPLOYMENT_STRING_EAR = "ear";
    public static final String DEPLOYMENT_STRING_JAR = "jar";
    public static final String DEPLOYMENT_STRING_WAR = "war";
    public static final String DEPLOYMENT_STRING_RAR = "rar";
    public static final String DEPLOYMENT_STRING = "*";
    public static final String DEPLOYMENT_STRING_DATASOURCE = "datasource";
    public static final String DEPLOYMENT_STRING_JMS = "jms";
    public static final String DEPLOYMENT_STRING_MAILFACTORY = "mail";
    public static final String DOMAIN_DEPLOYMENT_STRING_EAR = "domain-ear";
    public static final String DOMAIN_DEPLOYMENT_STRING_JAR = "domain-jar";
    public static final String DOMAIN_DEPLOYMENT_STRING_WAR = "domain-war";
    public static final String DOMAIN_DEPLOYMENT_STRING_RAR = "domain-rar";
    protected int applicationServerPort = 0;
    protected String applicationContextPath = null;
    protected boolean catalinaServer = false;
    protected String currentCatalinaDomainName = null;
    protected String currentCatalinaServiceName = null;
    protected String currentCatalinaEngineName = null;
    protected String currentCatalinaDefaultHostName = null;
    protected boolean jettyServer = false;
    protected ObjectName currentDomain = null;
    protected ObjectName currentJonasServer = null;
    protected ObjectName currentClusterDaemon = null;
    protected String currentSrvToConfigure = null;
    protected String currentDomainName = null;
    protected String currentJonasServerName = null;
    protected String currentClusterDaemonName = null;
    protected String adminJonasServerName = null;
    protected String adminJonasServerConfDir = null;
    protected boolean theCurrentJonasServer = false;
    protected int currentJonasDeploymentType = 0;
    protected Hashtable<String, Hashtable<String, Integer>> clusterdGraphAttributes = null;
    protected Hashtable<String, ServerItem> configuredServerForClusterDaemonList = null;
    protected MBeanServerConnection newCmiMbeanServerConnection = null;
    protected Hashtable<String, ArrayList<String>> removedServersPerClusterd = null;
    protected Hashtable<String, String> variables = new Hashtable();

    public static String getServerName() {
        JProp oJProp = JProp.getInstance();
        return oJProp.getServerName();
    }

    public static String getDomainName() {
        JProp oJProp = JProp.getInstance();
        return oJProp.getDomainName();
    }

    public String getCurrentJonasServerName() {
        return this.currentJonasServerName;
    }

    public ObjectName getCurrentJonasServer() {
        return this.currentJonasServer;
    }

    public ObjectName getCurrentDomain() {
        return this.currentDomain;
    }

    public String getCurrentDomainName() {
        return this.currentDomainName;
    }

    public void refreshServers(HttpServletRequest p_Request, String domainName, String serverName) throws ManagementException, AdminException {
        this.refreshJonas(p_Request, serverName);
        this.applicationServerPort = p_Request.getServerPort();
        this.applicationContextPath = p_Request.getContextPath();
        this.refreshCatalina(p_Request, domainName);
        this.refreshJetty(p_Request, domainName);
    }

    public void refreshServers(HttpServletRequest p_Request) {
    }

    public void refreshCatalina(HttpServletRequest p_Request, String domainName) {
        this.resetCatalina();
        try {
            String servletServerName = this.getServletServerName(domainName);
            if (servletServerName == null) {
                return;
            }
            String sServer = servletServerName.toLowerCase();
            boolean bl = this.catalinaServer = sServer.indexOf("tomcat") > -1;
            if (this.catalinaServer) {
                ObjectName onServer = AdminJmxHelper.getFirstMbean(CatalinaObjectName.catalinaServer(), this.currentJonasServerName);
                ObjectName[] aonServices = (ObjectName[])JonasManagementRepr.getAttribute(onServer, "serviceNames", this.currentJonasServerName);
                this.currentCatalinaServiceName = aonServices[0].getKeyProperty("serviceName");
                this.currentCatalinaEngineName = this.currentCatalinaDomainName = aonServices[0].getDomain();
                ObjectName onEngine = CatalinaObjectName.catalinaEngine(this.currentCatalinaDomainName);
                this.currentCatalinaDefaultHostName = (String)JonasManagementRepr.getAttribute(onEngine, "defaultHost", this.currentJonasServerName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshJetty(HttpServletRequest p_Request, String domainName) {
        this.resetJetty();
        try {
            String servletServerName = this.getServletServerName(domainName);
            if (servletServerName == null) {
                return;
            }
            String sServer = servletServerName.toLowerCase();
            boolean bl = this.jettyServer = sServer.indexOf("jetty") > -1;
            if (!this.jettyServer) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshJonas(HttpServletRequest p_Request, String serverName) throws ManagementException, AdminException {
        this.resetJonas();
        this.currentJonasServerName = serverName;
        this.currentJonasServer = J2eeObjectName.J2EEServer(this.currentDomainName, serverName);
        this.theCurrentJonasServer = this.adminJonasServerName.equals(this.currentJonasServerName);
    }

    protected String getServletServerName(String domainName) throws ManagementException {
        String servletServerName = null;
        ObjectName on = JonasObjectName.webContainerService(domainName);
        if (JonasManagementRepr.isRegistered(on, this.currentJonasServerName)) {
            servletServerName = (String)JonasManagementRepr.getAttribute(on, "ServerName", this.currentJonasServerName);
        }
        return servletServerName;
    }

    protected void resetCatalina() {
        this.catalinaServer = false;
        this.currentCatalinaServiceName = null;
    }

    protected void resetJetty() {
        this.jettyServer = false;
    }

    protected void resetJonas() {
        this.theCurrentJonasServer = false;
        this.currentJonasServer = null;
        this.currentJonasServerName = null;
    }

    protected void resetDomain() {
        this.currentDomain = null;
        this.currentDomainName = null;
    }

    public boolean isCatalinaServer() {
        return this.catalinaServer;
    }

    public String getCurrentCatalinaServiceName() {
        return this.currentCatalinaServiceName;
    }

    public boolean isCurrentJonasServer() {
        return this.theCurrentJonasServer;
    }

    public int getCurrentJonasDeploymentType() {
        return this.currentJonasDeploymentType;
    }

    public void setCurrentJonasDeploymentType(int currentJonasDeploymentType) {
        this.currentJonasDeploymentType = currentJonasDeploymentType;
    }

    public int getApplicationServerPort() {
        return this.applicationServerPort;
    }

    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    public String getCurrentCatalinaDefaultHostName() {
        return this.currentCatalinaDefaultHostName;
    }

    public String getCurrentCatalinaEngineName() {
        return this.currentCatalinaEngineName;
    }

    public String getCurrentCatalinaDomainName() {
        return this.currentCatalinaDomainName;
    }

    public boolean isJettyServer() {
        return this.jettyServer;
    }

    public String getAdminJonasServerName() {
        return this.adminJonasServerName;
    }

    public String getAdminJonasServerConfDir() {
        return this.adminJonasServerConfDir;
    }

    public ObjectName getCurrentClusterDaemon() {
        return this.currentClusterDaemon;
    }

    public void setCurrentClusterDaemon(ObjectName currentClusterDaemon) {
        this.currentClusterDaemon = currentClusterDaemon;
    }

    public String getCurrentClusterDaemonName() {
        return this.currentClusterDaemonName;
    }

    public void setCurrentClusterDaemonName(String currentClusterDaemonName) {
        this.currentClusterDaemonName = currentClusterDaemonName;
    }

    public Hashtable<String, ?> getClusterdGraphAttributes() {
        return this.clusterdGraphAttributes;
    }

    public void setClusterdGraphAttributes(Hashtable<String, Hashtable<String, Object>> clusterdGraphAttribute) {
        this.clusterdGraphAttributes = this.clusterdGraphAttributes;
    }

    public int getClusterdGraphAttribute(String clusterd, String attKey) throws Exception {
        int ret = -1;
        try {
            Hashtable<String, Integer> myHash = this.clusterdGraphAttributes.get(clusterd);
            if (myHash != null) {
                ret = myHash.get(attKey);
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot find value for attribute " + attKey + " from the cluster daemon named  " + clusterd + e);
        }
        return ret;
    }

    public void setClusterdGraphAttribute(String clusterd, String attKey, Integer val) throws Exception {
        try {
            Hashtable<String, Integer> myHash = this.clusterdGraphAttributes.get(clusterd);
            if (myHash != null) {
                myHash.remove(attKey);
                myHash.put(attKey, val);
            } else {
                this.clusterdGraphAttributes.put(clusterd, new Hashtable());
                this.clusterdGraphAttributes.get(clusterd).put(attKey, val);
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot put value for attribute " + attKey + "for the cluster daemon named " + clusterd + e);
        }
    }

    public String getCurrentSrvToConfigure() {
        return this.currentSrvToConfigure;
    }

    public void setCurrentSrvToConfigure(String currentSrvToConfigure) {
        this.currentSrvToConfigure = currentSrvToConfigure;
    }

    public void addSrvConfiguredForClusterd(ServerItem srv) throws Exception {
        try {
            if (this.configuredServerForClusterDaemonList == null) {
                this.configuredServerForClusterDaemonList = new Hashtable();
            }
            this.configuredServerForClusterDaemonList.put(srv.getName(), srv);
        }
        catch (NullPointerException e) {
            throw new Exception("Server item must not be null" + e);
        }
    }

    public ServerItem getSrvConfiguredForClusterd(String key) throws Exception {
        ServerItem ret = null;
        try {
            ret = this.configuredServerForClusterDaemonList.get(key);
            return ret;
        }
        catch (NullPointerException e) {
            throw new Exception("Server item name must not be Null " + e);
        }
        finally {
            return ret;
        }
    }

    public boolean isConfiguredForClusterd(String srvName) throws Exception {
        boolean ret = false;
        try {
            ret = this.configuredServerForClusterDaemonList.containsKey(srvName);
        }
        catch (Exception e) {
            throw new Exception("Server name or configuredServerForClusterDaemonList attribute is null " + e);
        }
        return ret;
    }

    public void clearConfigureForClusterList() {
        if (this.configuredServerForClusterDaemonList != null) {
            this.configuredServerForClusterDaemonList.clear();
        }
    }

    public void setNewCmiMbeanServerConnection(MBeanServerConnection newCmiMbeanServerConnection) {
        this.newCmiMbeanServerConnection = newCmiMbeanServerConnection;
    }

    public void addRemovedServer(String clusterdName, String srvName) {
        ArrayList<String> removedServers = this.removedServersPerClusterd.get(clusterdName);
        if (removedServers == null) {
            removedServers = new ArrayList();
            removedServers.add(srvName);
            this.removedServersPerClusterd.put(clusterdName, removedServers);
        } else {
            removedServers.add(srvName);
        }
    }

    public boolean isSrvRemovedFromClusterd(String clusterdName, String srvName) {
        ArrayList<String> removedServers = this.removedServersPerClusterd.get(clusterdName);
        if (removedServers != null) {
            return removedServers.contains(srvName);
        }
        return false;
    }

    public void rmvFromClusterdRemovedList(String clusterdName, String srvName) {
        ArrayList<String> removedServers = this.removedServersPerClusterd.get(clusterdName);
        if (removedServers != null) {
            removedServers.remove(srvName);
        }
    }

    public void addVar(String key, String value) {
        this.variables.remove(key);
        this.variables.put(key, value);
    }

    public void removeVar(String key) {
        this.variables.remove(key);
    }

    public String getVar(String key) {
        return this.variables.get(key);
    }
}

