/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.security.jacc.handlers;

import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.security.jacc.handlers.JPolicyContextHandlerData;
import org.ow2.jonas.lib.util.Log;

public class JPolicyContextHandler
implements PolicyContextHandler {
    private static final String CONTAINER_SUBJECT = "javax.security.auth.Subject.container";
    private static final String SOAP_MESSAGE = "javax.xml.soap.SOAPMessage";
    private static final String HTTP_SERVLET_REQUEST = "javax.servlet.http.HttpServletRequest";
    private static final String ENTERPRISE_BEAN = "javax.ejb.EnterpriseBean";
    private static final String EJB_ARGUMENTS = "javax.ejb.arguments";
    private static final String[] SUPPORTED_KEYS = new String[]{"javax.security.auth.Subject.container", "javax.xml.soap.SOAPMessage", "javax.servlet.http.HttpServletRequest", "javax.ejb.EnterpriseBean", "javax.ejb.arguments"};
    private static Logger logger = Log.getLogger("org.ow2.jonas.security.jacc");

    public boolean supports(String key) throws PolicyContextException {
        for (int k = 0; k < SUPPORTED_KEYS.length; ++k) {
            if (!key.equals(SUPPORTED_KEYS[k])) continue;
            return true;
        }
        return false;
    }

    public String[] getKeys() throws PolicyContextException {
        return SUPPORTED_KEYS;
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Asking key" + key));
        }
        if (data == null || !(data instanceof JPolicyContextHandlerData)) {
            logger.log(BasicLevel.WARN, (Object)"No data object or Data object not instance of JPolicyContextHandlerData");
            return null;
        }
        Object contextObject = null;
        JPolicyContextHandlerData jPolicyContextHandlerData = (JPolicyContextHandlerData)data;
        if (key.equals(HTTP_SERVLET_REQUEST)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Key == 'javax.servlet.http.HttpServletRequest'");
            }
            contextObject = jPolicyContextHandlerData.getHttpServletRequest();
        } else if (key.equals(EJB_ARGUMENTS)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Key == 'javax.ejb.arguments'");
            }
            contextObject = jPolicyContextHandlerData.getEjbArguments();
        } else if (key.equals(CONTAINER_SUBJECT)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Key == 'javax.security.auth.Subject.container'");
            }
            contextObject = jPolicyContextHandlerData.getContainerSubject();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Returning object '" + contextObject + "' for key '" + key + "'"));
        }
        return contextObject;
    }
}

