/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.smartclient.internal;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import javax.management.ObjectName;
import org.ow2.easybeans.component.smartclient.server.SmartClientEndPointComponent;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.smartclient.SmartclientService;
import org.ow2.jonas.smartclient.internal.SmartclientServiceImplMBean;
import org.ow2.jonas.smartclient.internal.SmartclientServiceRegistryComponent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

public class SmartclientServiceImpl
extends AbsServiceImpl
implements SmartclientService,
SmartclientServiceImplMBean {
    private static Log logger = LogFactory.getLog(SmartclientService.class);
    private JmxService jmxService = null;
    private int port = 0;
    private SmartClientEndPointComponent smartclient = null;

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static ObjectName getObjectName(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=smartclient");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get smartclient service", e);
        }
    }

    protected void doStart() throws ServiceException {
        try {
            this.smartclient = new SmartClientEndPointComponent();
            this.smartclient.setPortNumber(this.port);
            SmartclientServiceRegistryComponent registry = new SmartclientServiceRegistryComponent();
            this.smartclient.setRegistryComponent(registry);
            File clientJar = new File(System.getProperty("jonas.root"), "lib/client.jar");
            URL[] clientJarURL = new URL[]{URLUtils.fileToURL(clientJar)};
            URLClassLoader clientJarClassLoader = new URLClassLoader(clientJarURL);
            this.smartclient.setClassLoader(clientJarClassLoader);
            this.smartclient.init();
            this.smartclient.start();
        }
        catch (Exception e) {
            throw new ServiceException("Cannot start the EasyBeans Smartclient", e);
        }
        this.jmxService.registerMBean((Object)this, SmartclientServiceImpl.getObjectName(this.getDomainName()));
        logger.info("Smartclient listening on port " + this.getPort(), new Object[0]);
    }

    protected void doStop() throws ServiceException {
        try {
            this.smartclient.stop();
            this.smartclient = null;
        }
        catch (Exception e) {
            throw new ServiceException("Cannot stop the EasyBeans Smartclient", e);
        }
        this.jmxService.unregisterMBean(SmartclientServiceImpl.getObjectName(this.getDomainName()));
        logger.info("Smartclient service stopped and management bean unregistered", new Object[0]);
    }

    public int getPort() {
        if (this.smartclient == null) {
            return -1;
        }
        return this.smartclient.getPortNumber();
    }

    public boolean isActive() {
        return this.smartclient != null;
    }
}

