/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6;

import org.apache.catalina.startup.ClusterRuleSetFactory;
import org.apache.catalina.startup.ConnectorCreateRule;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetAllPropertiesRule;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.digester.RuleSetBase;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.web.tomcat6.SetParentClassLoaderRule;
import org.ow2.jonas.web.tomcat6.SetSecurityServiceRule;

public class JCatalinaRuleSet
extends RuleSetBase {
    private ClassLoader parentClassLoader = null;
    private SecurityService securityService = null;

    public JCatalinaRuleSet(ClassLoader parentClassLoader, SecurityService securityService) {
        this.parentClassLoader = parentClassLoader;
        this.securityService = securityService;
    }

    public void addRuleInstances(Digester digester) {
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "org.apache.catalina.core.StandardThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "org.apache.catalina.Executor");
        digester.addRule("Server/Service/Connector", (Rule)new ConnectorCreateRule());
        digester.addRule("Server/Service/Connector", (Rule)new SetAllPropertiesRule(new String[]{"executor"}));
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.connector.Connector");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet((RuleSet)new EngineRuleSet("Server/Service/"));
        digester.addRuleSet((RuleSet)new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/"));
        digester.addRuleSet((RuleSet)ClusterRuleSetFactory.getClusterRuleSet((String)"Server/Service/Engine/Host/Cluster/"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", (Rule)new SetParentClassLoaderRule(this.parentClassLoader));
        SetSecurityServiceRule sssr = new SetSecurityServiceRule(this.securityService);
        digester.addRule("Server/Service/Engine/Realm", (Rule)sssr);
        digester.addRule("Server/Service/Engine/Host/Realm", (Rule)sssr);
        digester.addRule("Server/Service/Engine/Host/Context/Realm", (Rule)sssr);
        digester.addRuleSet((RuleSet)ClusterRuleSetFactory.getClusterRuleSet((String)"Server/Service/Engine/Cluster/"));
    }
}

