/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.client.factory;

import java.io.IOException;
import java.net.URL;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.ow2.jonas.ws.jaxws.handler.JOnASHandlerResolver;
import org.ow2.jonas.ws.jaxws.handler.builder.DescriptorHandlerChainBuilder;
import org.ow2.util.ee.builder.webserviceref.Constants;
import org.ow2.util.ee.builder.webserviceref.ReferenceHelper;
import org.ow2.util.ee.builder.webserviceref.factory.WebServiceRefObjectFactory;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.HandlerChainsLoader;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.common.impl.xml.struct.HandlerChains;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CXFWebServiceRefObjectFactory
extends WebServiceRefObjectFactory {
    private static Log logger = LogFactory.getLog(CXFWebServiceRefObjectFactory.class);

    protected void processObjectInstance(Service service, ReferenceHelper reference) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        HandlerChains handlerChain = reference.extract(Constants.HANDLER_CHAIN_STRUCT.name(), HandlerChains.class);
        if (handlerChain != null) {
            JOnASHandlerResolver resolver2 = new JOnASHandlerResolver(service.getClass(), tccl);
            resolver2.setHandlerChainBuilder(new DescriptorHandlerChainBuilder(handlerChain));
            service.setHandlerResolver(resolver2);
        } else {
            String file = reference.extract(Constants.HANDLER_CHAIN_FILE.name());
            String declaringClass = reference.extract(Constants.DECLARING_CLASS.name());
            if (file != null && declaringClass != null) {
                IHandlerChains handlerChainsElement;
                URL location;
                try {
                    location = new URL(file);
                }
                catch (IOException mue) {
                    Class<?> supportingClass = Class.forName(declaringClass, true, tccl);
                    logger.debug("@HandlerChain declaring class -> ''{0}''", supportingClass);
                    location = supportingClass.getResource(file);
                }
                logger.debug("@HandlerChain.file -> ''{0}''", location);
                try {
                    handlerChainsElement = HandlerChainsLoader.loadHandlerChains(location, true);
                }
                catch (ParsingException e) {
                    throw new WebServiceException("Cannot parse <handler-chains>", e);
                }
                JOnASHandlerResolver resolver3 = new JOnASHandlerResolver(service.getClass(), tccl);
                resolver3.setHandlerChainBuilder(new DescriptorHandlerChainBuilder(handlerChainsElement));
                service.setHandlerResolver(resolver3);
            }
        }
    }
}

