/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXWSWebservicesContainer {
    private String name;
    private Map<PortIdentifier, IWebServiceEndpoint> endpoints;
    private String wsdlPublicationDirectory;

    public JAXWSWebservicesContainer(String name) {
        this.name = name;
        this.endpoints = new HashMap<PortIdentifier, IWebServiceEndpoint>();
    }

    public void addEndpoint(IWebServiceEndpoint endpoint) {
        this.endpoints.put(endpoint.getIdentifier(), endpoint);
    }

    public void removeEndpoint(IWebServiceEndpoint endpoint) {
        this.endpoints.remove(endpoint.getIdentifier());
    }

    public String findUpdatedURL(PortIdentifier identifier) {
        IWebServiceEndpoint matching = this.endpoints.get(identifier);
        if (matching != null) {
            return matching.getPortMetaData().getEndpointURL();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Collection<IWebServiceEndpoint> getEndpoints() {
        return this.endpoints.values();
    }

    public void start() {
        for (IWebServiceEndpoint endpoint : this.endpoints.values()) {
            endpoint.start();
        }
    }

    public void stop() {
        for (IWebServiceEndpoint endpoint : this.endpoints.values()) {
            endpoint.stop();
        }
    }

    public void setWsdlPublicationDirectory(String wsdlPublicationDirectory) {
        this.wsdlPublicationDirectory = wsdlPublicationDirectory;
    }

    public String getWsdlPublicationDirectory() {
        return this.wsdlPublicationDirectory;
    }
}

