/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.ow2.jonas.ws.jaxws.handler.PostConstructProcessor;
import org.ow2.jonas.ws.jaxws.handler.builder.AnnotationHandlerChainBuilder;
import org.ow2.jonas.ws.jaxws.handler.builder.HandlerChainBuilder;
import org.ow2.util.annotation.processor.DefaultAnnotationProcessor;
import org.ow2.util.annotation.processor.ProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASHandlerResolver
implements HandlerResolver {
    private ClassLoader applicationClassLoader;
    private final Map<PortInfo, List<Handler>> handlerMap = new HashMap<PortInfo, List<Handler>>();
    private HandlerChainBuilder handlerChainBuilder;

    public JOnASHandlerResolver(Class<?> clazz, ClassLoader appsClassLoader) {
        this.applicationClassLoader = appsClassLoader;
        this.handlerChainBuilder = new AnnotationHandlerChainBuilder(clazz);
    }

    public void setHandlerChainBuilder(HandlerChainBuilder handlerChainBuilder) {
        this.handlerChainBuilder = handlerChainBuilder;
    }

    @Override
    public List<Handler> getHandlerChain(PortInfo portInfo) {
        List<Handler> handlerChain = this.handlerMap.get(portInfo);
        if (handlerChain == null) {
            handlerChain = this.createHandlerChain(portInfo);
            this.handlerMap.put(portInfo, handlerChain);
        }
        return handlerChain;
    }

    private List<Handler> createHandlerChain(PortInfo portInfo) {
        List<Handler> chain = this.handlerChainBuilder.buildHandlerChain(portInfo, this.applicationClassLoader);
        for (Handler h : chain) {
            this.configHandler(h);
            this.callPostConstructs(h);
        }
        return chain;
    }

    private void callPostConstructs(Handler handler) {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        processor.addAnnotationHandler(new PostConstructProcessor());
        try {
            processor.process(handler);
        }
        catch (ProcessorException e) {
            throw new WebServiceException("Cannot start Handler instance", e);
        }
    }

    private void configHandler(Handler handler) {
        if (handler != null) {
            // empty if block
        }
    }
}

