/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.publish.internal.manager;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.ws.publish.PublishableDefinition;
import org.ow2.jonas.ws.publish.WSDLPublisher;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.ow2.jonas.ws.publish.WSDLPublisherManager;
import org.ow2.jonas.ws.publish.internal.manager.WSDLPublisherFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWSDLPublisherManager
extends AbsServiceImpl
implements WSDLPublisherManager {
    private static Log logger = LogFactory.getLog(DefaultWSDLPublisherManager.class);
    private List<WSDLPublisher> publishers = new ArrayList<WSDLPublisher>();
    private JmxService jmxService = null;

    public void setPublishers(String param) {
        List<String> handlers = DefaultWSDLPublisherManager.convertToList(param);
        WSDLPublisherFactory factory = WSDLPublisherFactory.newInstance();
        for (String name : handlers) {
            WSDLPublisher publisher = null;
            try {
                publisher = factory.newPublisher(name);
            }
            catch (WSDLPublisherException e) {
                logger.info("Cannot add the new WSDLPublisher '{0}'", name, e);
            }
            logger.debug("Adding WSDLPublisher ''{0}''", name);
            this.addPublisher(publisher);
        }
    }

    @Override
    public void addPublisher(WSDLPublisher publisher) {
        this.publishers.add(publisher);
    }

    @Override
    public void removePublisher(WSDLPublisher publisher) {
        this.publishers.remove(publisher);
    }

    @Override
    public void publish(PublishableDefinition publishableDefinition) throws WSDLPublisherException {
        for (WSDLPublisher publisher : this.publishers) {
            publisher.publish(publishableDefinition);
        }
    }

    @Override
    public void publish(List<PublishableDefinition> publishableDefinitionList) throws WSDLPublisherException {
        if (publishableDefinitionList != null) {
            for (PublishableDefinition publishableDefinition : publishableDefinitionList) {
                for (WSDLPublisher publisher : this.publishers) {
                    publisher.publish(publishableDefinition);
                }
            }
        }
    }

    @Override
    protected void doStart() throws ServiceException {
        this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        try {
            this.jmxService.registerModelMBean((Object)this, JonasObjectName.wsdlPublisherService(this.getDomainName()));
        }
        catch (Exception e) {
            logger.warn("Cannot register MBean for Deployable Monitor service", e);
        }
    }

    @Override
    protected void doStop() throws ServiceException {
        if (this.jmxService != null) {
            try {
                this.jmxService.unregisterModelMBean(JonasObjectName.wsdlPublisherService(this.getDomainName()));
            }
            catch (Exception e) {
                logger.warn("Cannot unregister MBean for Deployable Monitor service", e);
            }
        }
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }
}

