/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackDeployableHelper {
    private static final int BUFFER = 4096;

    private PackDeployableHelper() {
    }

    public static <T extends IDeployable<T>> File pack(T deployable, File folder, String archiveName) throws DeployerException {
        T workingDeployable = deployable;
        EARDeployable earworkingDeployable = null;
        T unpackedDeployable = deployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            workingDeployable = unpackedDeployable;
        }
        boolean isEar = false;
        if (EARDeployable.class.isAssignableFrom(workingDeployable.getClass())) {
            isEar = true;
            earworkingDeployable = (EARDeployable)EARDeployable.class.cast(workingDeployable);
        }
        URL archiveURL = null;
        try {
            archiveURL = workingDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL for the given archive", e);
        }
        Iterator<URL> itResources = null;
        try {
            itResources = workingDeployable.getArchive().getResources();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the resources for the deployable '" + workingDeployable + "'.", e);
        }
        File file = new File(folder, archiveName);
        FileOutputStream fileOS = null;
        try {
            fileOS = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new DeployerException("Cannot create file output stream on the file '" + file + "'", e);
        }
        JarOutputStream fileJarOutputStream = null;
        try {
            fileJarOutputStream = new JarOutputStream(fileOS);
        }
        catch (IOException e) {
            throw new DeployerException("Cannot create Jar OutputStream", e);
        }
        try {
            byte[] buffer = new byte[4096];
            while (itResources.hasNext()) {
                Object unpackedSubDeployable;
                IDeployable<?> subDeployable;
                URL urlResource = itResources.next();
                String entryName = urlResource.toExternalForm().substring(archiveURL.toExternalForm().length());
                if (isEar && (subDeployable = earworkingDeployable.getDeployable(urlResource)) != null && (unpackedSubDeployable = subDeployable.getUnpackedDeployable()) != null) {
                    try {
                        URL archiveURLtoPack = unpackedSubDeployable.getArchive().getURL();
                        String san = URLUtils.shorterName(archiveURLtoPack);
                        File packedJar = PackDeployableHelper.pack(unpackedSubDeployable, folder, "new-" + san);
                        urlResource = URLUtils.fileToURL(packedJar);
                    }
                    catch (ArchiveException ae) {
                        throw new DeployerException("Cannot pack the deployable '" + deployable + "'", ae);
                    }
                }
                JarEntry jarEntry = new JarEntry(entryName);
                fileJarOutputStream.putNextEntry(jarEntry);
                URLConnection urlConnection = urlResource.openConnection();
                urlConnection.setDefaultUseCaches(false);
                InputStream is = urlConnection.getInputStream();
                int n = is.read(buffer);
                while (n > 0) {
                    fileJarOutputStream.write(buffer, 0, n);
                    n = is.read(buffer);
                }
                is.close();
                fileJarOutputStream.closeEntry();
            }
        }
        catch (IOException ioe) {
            throw new DeployerException("Cannot pack the deployable '" + deployable + "'", ioe);
        }
        finally {
            try {
                fileJarOutputStream.close();
            }
            catch (IOException e) {
                throw new DeployerException("Cannot close jar file output stream", e);
            }
            try {
                fileOS.close();
            }
            catch (IOException e) {
                throw new DeployerException("Cannot close file output stream", e);
            }
        }
        return file;
    }
}

