/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.helper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IFileArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployment.ear.IEARInfo;
import org.ow2.util.ee.deploy.api.deployment.ear.Module;
import org.ow2.util.ee.deploy.impl.deployable.EARDeployableImpl;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.helper.EarUnpackOpts;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnpackDeployableHelper {
    public static final String DEFAULT_FOLDER = "EE-Deployer";
    private static Log logger = LogFactory.getLog(UnpackDeployableHelper.class);

    private UnpackDeployableHelper() {
    }

    public static <T extends IDeployable<T>> T unpack(T deployable) throws DeployerException {
        return UnpackDeployableHelper.unpack(deployable, DEFAULT_FOLDER);
    }

    private static <T extends IDeployable<T>> File createTmpFolder(String pattern, T deployable) {
        File rootFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + pattern + "-" + System.getProperty("user.name", "default"));
        rootFolder.mkdirs();
        File earFolder = new File(rootFolder, deployable.getClass().getSimpleName());
        earFolder.mkdirs();
        return earFolder;
    }

    public static <T extends IDeployable<T>> T unpack(T deployable, String pattern) throws DeployerException {
        return UnpackDeployableHelper.unpack(deployable, UnpackDeployableHelper.createTmpFolder(pattern, deployable), null);
    }

    public static <T extends IDeployable<T>> T unpack(T deployable, File folder, String archiveName) throws DeployerException {
        return UnpackDeployableHelper.unpack(deployable, folder, archiveName, false);
    }

    public static <T extends IDeployable<T>> T unpack(T deployable, File folder, String archiveName, boolean keepExistingFiles) throws DeployerException {
        File unpackedFolder = null;
        if (archiveName == null) {
            URL url = null;
            try {
                url = deployable.getArchive().getURL();
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the deployable '" + deployable + "'.", e);
            }
            String fileName = URLUtils.shorterName(url);
            unpackedFolder = new File(folder, fileName);
        } else {
            unpackedFolder = new File(folder, archiveName);
        }
        unpackedFolder.mkdir();
        return UnpackDeployableHelper.unpack(deployable, unpackedFolder, keepExistingFiles);
    }

    public static <T extends IDeployable<T>> T unpack(T deployable, File unpackedFolder) throws DeployerException {
        return UnpackDeployableHelper.unpack(deployable, unpackedFolder, false);
    }

    public static <T extends IDeployable<T>> T unpack(T deployable, File unpackedFolder, boolean keepExistingFiles) throws DeployerException {
        return UnpackDeployableHelper.unpack(deployable, unpackedFolder, keepExistingFiles, null);
    }

    public static <T extends IDeployable<T>> T unpack(T deployable, String pattern, boolean keepExistingFiles, EarUnpackOpts earUnpackOpts) throws DeployerException {
        File unpackedFolder = new File(UnpackDeployableHelper.createTmpFolder(pattern, deployable), deployable.getShortName());
        unpackedFolder.mkdir();
        return UnpackDeployableHelper.unpack(deployable, unpackedFolder, keepExistingFiles, earUnpackOpts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends IDeployable<T>> T unpack(T deployable, File unpackedFolder, boolean keepExistingFiles, EarUnpackOpts earUnpackOpts) throws DeployerException {
        List<Module> modules;
        IDeployable<?> unpackedDeployable = null;
        IArchive builtArchive = ArchiveManager.getInstance().getArchive(unpackedFolder);
        Iterator<URL> itResouces = null;
        try {
            itResouces = deployable.getArchive().getResources();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the resources on the archive '" + deployable.getArchive() + "'.", e);
        }
        URL deployableURL = null;
        try {
            deployableURL = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the resources on the archive '" + deployable.getArchive() + "'.", e);
        }
        ArrayList<File> entries = new ArrayList<File>();
        while (itResouces.hasNext()) {
            URL url = itResouces.next();
            String entryName = null;
            entryName = url.getPath().contains("!") ? url.getPath().substring(url.getPath().lastIndexOf("!") + 2) : url.getPath().substring(deployableURL.getPath().length());
            File entryFile = new File(unpackedFolder, entryName);
            logger.debug("Dumping url ''{0}'' inputstream into ''{1}''", url, entryFile);
            entryFile.getParentFile().mkdirs();
            if (url.toString().endsWith("/")) {
                entryFile.mkdirs();
                continue;
            }
            URLConnection urlConnection = null;
            try {
                urlConnection = url.openConnection();
            }
            catch (IOException e) {
                throw new DeployerException("Cannot open the connection on the URL '" + url + "'.", e);
            }
            urlConnection.setDefaultUseCaches(false);
            InputStream is = null;
            try {
                is = urlConnection.getInputStream();
            }
            catch (IOException e) {
                throw new DeployerException("Cannot get the input stream on the URL connection '" + urlConnection + "'.", e);
            }
            try {
                if (!entryFile.exists() || !keepExistingFiles) {
                    FileUtils.dump(is, entryFile);
                }
                entries.add(entryFile);
            }
            catch (FileUtilsException e) {
                try {
                    throw new DeployerException("Cannot dump the inputstream of url '" + url + "' into file '" + entryFile + "'.", e);
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        logger.warn("Problem when closing the input stream on url ''{0}''", url, e2);
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("Problem when closing the input stream on url ''{0}''", url, e);
            }
        }
        try {
            unpackedDeployable = DeployableHelper.getDeployable(builtArchive);
        }
        catch (DeployableHelperException e) {
            throw new DeployerException("Cannot get Deployable on the archive '" + builtArchive + "'", e);
        }
        unpackedDeployable.setOriginalDeployable(deployable);
        deployable.setUnpackedDeployable(unpackedDeployable);
        if (!EARDeployableImpl.class.isAssignableFrom(deployable.getClass())) return (T)unpackedDeployable;
        if (!EARDeployableImpl.class.isAssignableFrom(unpackedDeployable.getClass())) {
            throw new DeployerException("The unpacked version of the deployable '" + deployable + "' is not an EAR. Type is '" + unpackedDeployable + "'.");
        }
        EARDeployableImpl earDeployableImpl = (EARDeployableImpl)EARDeployableImpl.class.cast(unpackedDeployable);
        IEARInfo earInfo = earDeployableImpl.getEARInfo();
        ArrayList<File> analyzedFiles = new ArrayList<File>();
        if (earInfo != null && (modules = earInfo.getModules()) != null) {
            for (Module module : modules) {
                File file = new File(unpackedFolder, module.getPath());
                UnpackDeployableHelper.addFileInDeployable(file, earDeployableImpl, earUnpackOpts);
                analyzedFiles.add(file);
            }
        }
        Iterator i$ = entries.iterator();
        while (true) {
            if (!i$.hasNext()) {
                earDeployableImpl.resolveClassPath();
                return (T)unpackedDeployable;
            }
            File entryFile = (File)i$.next();
            if (analyzedFiles.contains(entryFile)) continue;
            UnpackDeployableHelper.addFileInDeployable(entryFile, earDeployableImpl, earUnpackOpts);
        }
    }

    protected static void addFileInDeployable(File file, EARDeployableImpl earDeployableImpl, EarUnpackOpts earUnpackOpts) throws DeployerException {
        IArchive tmpArchive = ArchiveManager.getInstance().getArchive(file);
        if (tmpArchive != null && !(tmpArchive instanceof IFileArchive)) {
            IDeployable<?> tmpDeployable = null;
            try {
                tmpDeployable = DeployableHelper.getDeployable(tmpArchive, false);
            }
            catch (DeployableHelperException e) {
                throw new DeployerException("Cannot get a deployable on the file '" + file + "'.", e);
            }
            earDeployableImpl.addDeployable(tmpDeployable, earUnpackOpts);
        }
    }
}

