/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing;

import java.net.URL;
import java.util.List;
import javax.ejb.TransactionAttributeType;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.CommonDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ActivationConfig;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AroundInvoke;
import org.ow2.util.ee.metadata.common.impl.xml.struct.MethodDD;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IAssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptors;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JApplicationException;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing.EJB3EntityResolver;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.AbsBean;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.AssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.ContainerTransaction;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EJB3;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Interceptor;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.InterceptorBinding;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Interceptors;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MessageDestination;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MessageDriven;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MethodPermission;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.RemoveMethod;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Session;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public final class EJB3DeploymentDescLoader
extends CommonDeploymentDescLoader {
    private static Log logger = LogFactory.getLog(EJB3DeploymentDescLoader.class);
    private EJB3 ejb3 = new EJB3();

    private EJB3DeploymentDescLoader(URL url) {
        super(url);
    }

    public static EJB3 loadDeploymentDescriptor(URL url) throws ParsingException {
        logger.debug("Analyzing url {0}", url);
        EJB3DeploymentDescLoader ejbDeploymentDescLoader = new EJB3DeploymentDescLoader(url);
        ejbDeploymentDescLoader.parse();
        return ejbDeploymentDescLoader.getEJB3();
    }

    public void parse() throws ParsingException {
        NodeList assemblyDescriptorList;
        NodeList interceptorsList;
        Document document = null;
        try {
            document = DocumentParser.getDocument(this.getURL(), EJB3DeploymentDescLoader.isValidating(), (EntityResolver)new EJB3EntityResolver());
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", e);
        }
        Element ejbJarRootElement = document.getDocumentElement();
        this.defineXMLNS(ejbJarRootElement);
        NodeList enterprisebeansList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "enterprise-beans");
        if (enterprisebeansList.getLength() == 1) {
            Element enterpriseBeansElement = (Element)enterprisebeansList.item(0);
            EnterpriseBeans enterpriseBeans = new EnterpriseBeans();
            this.ejb3.setEnterpriseBeans(enterpriseBeans);
            this.analyzeBeans(enterpriseBeansElement, enterpriseBeans);
        }
        if ((interceptorsList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "interceptors")).getLength() == 1) {
            Element interceptorsElement = (Element)interceptorsList.item(0);
            Interceptors interceptors = new Interceptors();
            this.ejb3.setInterceptors(interceptors);
            this.analyzeInterceptorsElement(interceptorsElement, interceptors);
        }
        if ((assemblyDescriptorList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "assembly-descriptor")).getLength() == 1) {
            Element assemblyDescriptorElement = (Element)assemblyDescriptorList.item(0);
            AssemblyDescriptor assemblyDescriptor = new AssemblyDescriptor();
            this.ejb3.setAssemblyDescriptor(assemblyDescriptor);
            this.analyzeAssemblyDescriptor(assemblyDescriptorElement, assemblyDescriptor);
        }
        if ("true".equals(ejbJarRootElement.getAttribute("metadata-complete"))) {
            this.ejb3.setMetadataComplete(true);
        } else {
            this.ejb3.setMetadataComplete(false);
        }
    }

    private void analyzeBeans(Element enterpriseBeansElement, IEnterpriseBeans enterpriseBeans) {
        NodeList sessionBeansList = enterpriseBeansElement.getElementsByTagNameNS(this.getXMLNS(), "session");
        for (int i = 0; i < sessionBeansList.getLength(); ++i) {
            Element sessionElement = (Element)sessionBeansList.item(i);
            Session session = new Session();
            enterpriseBeans.addSession(session);
            this.analyzeSessionBean(sessionElement, session);
        }
        NodeList messageDrivenBeansList = enterpriseBeansElement.getElementsByTagNameNS(this.getXMLNS(), "message-driven");
        for (int i = 0; i < messageDrivenBeansList.getLength(); ++i) {
            Element mdbElement = (Element)messageDrivenBeansList.item(i);
            MessageDriven messageDriven = new MessageDriven();
            enterpriseBeans.addMessageDriven(messageDriven);
            this.analyzeMessageDrivenBean(mdbElement, messageDriven);
        }
    }

    private void analyzeBean(Element beanElement, AbsBean bean) {
        String mappedName;
        String ejbName = XMLUtils.getStringValueElement(this.getXMLNS(), beanElement, "ejb-name");
        bean.setEjbName(ejbName);
        String ejbClass = XMLUtils.getStringValueElement(this.getXMLNS(), beanElement, "ejb-class");
        bean.setEjbClass(ejbClass);
        String runAsRole = XMLUtils.getStringValueElement(this.getXMLNS(), beanElement, "run-as");
        if (runAsRole != null) {
            bean.setRunAsRole(runAsRole);
        }
        if ((mappedName = XMLUtils.getChildStringValueForElement(beanElement, "mapped-name")) != null) {
            bean.setMappedName(mappedName);
        }
        String transactionType = XMLUtils.getStringValueElement(this.getXMLNS(), beanElement, "transaction-type");
        bean.setTransactionType(transactionType);
        this.analyzeEnvironment(beanElement, bean);
    }

    private void analyzeMessageDrivenBean(Element beanElement, MessageDriven bean) {
        this.analyzeBean(beanElement, bean);
        String messageDestinationType = XMLUtils.getChildStringValueForElement(beanElement, "message-destination-type");
        bean.setMessageDestinationType(messageDestinationType);
        String messageDestinationLink = XMLUtils.getChildStringValueForElement(beanElement, "message-destination-link");
        bean.setMessageDestinationLink(messageDestinationLink);
        String messagingType = XMLUtils.getStringValueElement(this.getXMLNS(), beanElement, "messaging-type");
        bean.setMessagingType(messagingType);
        NodeList activationConfigList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "activation-config");
        for (int i = 0; i < activationConfigList.getLength(); ++i) {
            Element activationConfigElement = (Element)activationConfigList.item(i);
            NodeList activationConfigPropertyList = activationConfigElement.getElementsByTagNameNS(this.getXMLNS(), "activation-config-property");
            for (int j = 0; j < activationConfigPropertyList.getLength(); ++j) {
                Element activationConfigPropertyElement = (Element)activationConfigPropertyList.item(j);
                ActivationConfig activationConfig = new ActivationConfig();
                bean.addActivationConfig(activationConfig);
                String name = XMLUtils.getStringValueElement(this.getXMLNS(), activationConfigPropertyElement, "activation-config-property-name");
                String value = XMLUtils.getStringValueElement(this.getXMLNS(), activationConfigPropertyElement, "activation-config-property-value");
                activationConfig.setName(name);
                activationConfig.setValue(value);
            }
        }
    }

    private void analyzeSessionBean(Element beanElement, Session bean) {
        this.analyzeBean(beanElement, bean);
        List<String> businessRemoteList = XMLUtils.getStringListValueElement(this.getXMLNS(), beanElement, "business-remote");
        for (String businessRemote : businessRemoteList) {
            bean.addBusinessRemote(businessRemote);
        }
        List<String> businessLocalList = XMLUtils.getStringListValueElement(this.getXMLNS(), beanElement, "business-local");
        for (String businessLocal : businessLocalList) {
            bean.addBusinessLocal(businessLocal);
        }
        NodeList removeMethodList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "remove-method");
        for (int i = 0; i < removeMethodList.getLength(); ++i) {
            Element removeMethodElement = (Element)removeMethodList.item(i);
            RemoveMethod removeMethod = new RemoveMethod();
            bean.addRemoveMethod(removeMethod);
            NodeList beanMethodList = removeMethodElement.getElementsByTagNameNS(this.getXMLNS(), "bean-method");
            removeMethod.setMethod(this.getMethodFromElement((Element)beanMethodList.item(0)));
            String retainIfExceptionStr = XMLUtils.getStringValueElement(this.getXMLNS(), removeMethodElement, "retain-if-exception");
            if (retainIfExceptionStr == null) continue;
            boolean retainIfException = false;
            retainIfException = Boolean.parseBoolean(retainIfExceptionStr);
            removeMethod.setRetainIfException(retainIfException);
        }
        String remoteHome = XMLUtils.getChildStringValueForElement(beanElement, "home");
        bean.setRemoteHome(remoteHome);
        String localHome = XMLUtils.getChildStringValueForElement(beanElement, "local-home");
        bean.setLocalHome(localHome);
        String sessionType = XMLUtils.getStringValueElement(this.getXMLNS(), beanElement, "session-type");
        bean.setSessionType(sessionType);
    }

    private MethodDD getMethodFromElement(Element methodElement) {
        MethodDD method = new MethodDD();
        String methodName = XMLUtils.getStringValueElement(this.getXMLNS(), methodElement, "method-name");
        method.setName(methodName);
        String ejbName = XMLUtils.getStringValueElement(this.getXMLNS(), methodElement, "ejb-name");
        method.setEjbName(ejbName);
        NodeList methodParamsList = methodElement.getElementsByTagNameNS(this.getXMLNS(), "method-params");
        if (methodParamsList != null && methodParamsList.getLength() == 1) {
            Element methodParamsElement = (Element)methodParamsList.item(0);
            List<String> paramList = XMLUtils.getStringListValueElement(this.getXMLNS(), methodParamsElement, "method-param");
            for (String param : paramList) {
                method.addParam(param);
            }
        }
        return method;
    }

    private void analyzeInterceptorsElement(Element interceptorsElement, IInterceptors interceptors) {
        NodeList interceptorList = interceptorsElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            Interceptor interceptor = new Interceptor();
            interceptors.addInterceptor(interceptor);
            String interceptorClass = XMLUtils.getStringValueElement(this.getXMLNS(), interceptorElement, "interceptor-class");
            interceptor.setInterceptorClass(interceptorClass);
            this.analyzeEnvironment(interceptorElement, interceptor);
        }
    }

    private void analyzeAssemblyDescriptor(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        this.analyzeApplicationException(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeInterceptorBinding(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeContainerTransaction(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeSecurity(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeMessageDestination(assemblyDescriptorElement, assemblyDescriptor);
    }

    private void analyzeInterceptorBinding(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList interceptorBindingList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor-binding");
        for (int i = 0; i < interceptorBindingList.getLength(); ++i) {
            String excludeDefaultInterceptorsStr;
            String excludeClassInterceptorsStr;
            NodeList methodList;
            Element interceptorBindingElement = (Element)interceptorBindingList.item(i);
            InterceptorBinding interceptorBinding = new InterceptorBinding();
            assemblyDescriptor.addInterceptorBinding(interceptorBinding);
            String ejbName = XMLUtils.getStringValueElement(this.getXMLNS(), interceptorBindingElement, "ejb-name");
            interceptorBinding.setEjbName(ejbName);
            NodeList interceptorOrderList = interceptorBindingElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor-order");
            if (interceptorOrderList != null && interceptorOrderList.getLength() == 1) {
                Element interceptorOrderElement = (Element)interceptorOrderList.item(0);
                List<String> interceptorOrderClassList = XMLUtils.getStringListValueElement(this.getXMLNS(), interceptorOrderElement, "interceptor-class");
                for (String interceptorClass : interceptorOrderClassList) {
                    interceptorBinding.addOrderedInterceptorClass(interceptorClass);
                }
            } else {
                List<String> interceptorClassList = XMLUtils.getStringListValueElement(this.getXMLNS(), interceptorBindingElement, "interceptor-class");
                for (String interceptorClass : interceptorClassList) {
                    interceptorBinding.addInterceptorClass(interceptorClass);
                }
            }
            if ((methodList = interceptorBindingElement.getElementsByTagNameNS(this.getXMLNS(), "method")).getLength() > 0) {
                interceptorBinding.setMethod(this.getMethodFromElement((Element)methodList.item(0)));
            }
            if ((excludeClassInterceptorsStr = XMLUtils.getStringValueElement(this.getXMLNS(), interceptorBindingElement, "exclude-class-interceptors")) != null) {
                boolean excludeClassInterceptors = false;
                excludeClassInterceptors = Boolean.parseBoolean(excludeClassInterceptorsStr);
                interceptorBinding.setExcludeClassInterceptors(excludeClassInterceptors);
            }
            if ((excludeDefaultInterceptorsStr = XMLUtils.getStringValueElement(this.getXMLNS(), interceptorBindingElement, "exclude-default-interceptors")) == null) continue;
            boolean excludeDefaultInterceptors = false;
            excludeDefaultInterceptors = Boolean.parseBoolean(excludeDefaultInterceptorsStr);
            interceptorBinding.setExcludeDefaultInterceptors(excludeDefaultInterceptors);
        }
    }

    private void analyzeApplicationException(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList applicationExceptionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "application-exception");
        for (int i = 0; i < applicationExceptionList.getLength(); ++i) {
            Element applicationExceptionElement = (Element)applicationExceptionList.item(i);
            String className = XMLUtils.getStringValueElement(this.getXMLNS(), applicationExceptionElement, "exception-class");
            String rollbackStr = XMLUtils.getStringValueElement(this.getXMLNS(), applicationExceptionElement, "rollback");
            boolean rollback = false;
            if (rollbackStr != null) {
                rollback = Boolean.parseBoolean(rollbackStr);
            }
            JApplicationException applicationException = new JApplicationException(className, rollback);
            assemblyDescriptor.addApplicationException(applicationException);
        }
    }

    private void analyzeContainerTransaction(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList containerTransactionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "container-transaction");
        for (int i = 0; i < containerTransactionList.getLength(); ++i) {
            Element containerTransactionElement = (Element)containerTransactionList.item(i);
            ContainerTransaction containerTransaction = new ContainerTransaction();
            assemblyDescriptor.addContainerTransaction(containerTransaction);
            NodeList methodList = containerTransactionElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                containerTransaction.addMethod(this.getMethodFromElement(methodElement));
            }
            String transactionAttribute = XMLUtils.getStringValueElement(this.getXMLNS(), containerTransactionElement, "trans-attribute");
            if (transactionAttribute == null) continue;
            if ("NotSupported".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.NOT_SUPPORTED);
                continue;
            }
            if ("Supports".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.SUPPORTS);
                continue;
            }
            if ("Required".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.REQUIRED);
                continue;
            }
            if ("RequiresNew".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.REQUIRES_NEW);
                continue;
            }
            if ("Mandatory".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.MANDATORY);
                continue;
            }
            if ("Never".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.NEVER);
                continue;
            }
            throw new IllegalStateException("Invalid transaction attribute '" + transactionAttribute + "'");
        }
    }

    private void analyzeSecurity(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList securityRoleList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "security-role");
        for (int i = 0; i < securityRoleList.getLength(); ++i) {
            Element securityRoleElement = (Element)securityRoleList.item(i);
            String securityRole = XMLUtils.getStringValueElement(this.getXMLNS(), securityRoleElement, "role-name");
            if (securityRole == null) continue;
            assemblyDescriptor.addSecurityRole(securityRole);
        }
        NodeList methodPermissionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "method-permission");
        for (int i = 0; i < methodPermissionList.getLength(); ++i) {
            Element methodPermissionElement = (Element)methodPermissionList.item(i);
            MethodPermission methodPermission = new MethodPermission();
            assemblyDescriptor.addMethodPermission(methodPermission);
            List<String> roles = XMLUtils.getStringListValueElement(this.getXMLNS(), methodPermissionElement, "role-name");
            for (String roleName : roles) {
                methodPermission.addRoleName(roleName);
            }
            NodeList uncheckedList = methodPermissionElement.getElementsByTagNameNS(this.getXMLNS(), "unchecked");
            if (uncheckedList.getLength() > 0) {
                methodPermission.setUnchecked(true);
            }
            NodeList methodList = methodPermissionElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                methodPermission.addMethod(this.getMethodFromElement(methodElement));
            }
        }
        NodeList excludeList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "exclude-list");
        for (int i = 0; i < excludeList.getLength(); ++i) {
            Element excludeListElement = (Element)excludeList.item(i);
            NodeList methodList = excludeListElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                assemblyDescriptor.addExcludeList(this.getMethodFromElement(methodElement));
            }
        }
    }

    private void analyzeMessageDestination(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList messageDestinationList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "message-destination");
        for (int i = 0; i < messageDestinationList.getLength(); ++i) {
            String mappedName;
            Element messageDestinationElement = (Element)messageDestinationList.item(i);
            MessageDestination messageDestination = new MessageDestination();
            String messageDestinationName = XMLUtils.getStringValueElement(this.getXMLNS(), messageDestinationElement, "message-destination-name");
            if (messageDestinationName != null) {
                messageDestination.setName(messageDestinationName);
                assemblyDescriptor.addMessageDestination(messageDestination);
            }
            if ((mappedName = XMLUtils.getStringValueElement(this.getXMLNS(), messageDestinationElement, "mapped-name")) == null) continue;
            messageDestination.setMappedName(mappedName);
        }
    }

    private void analyzeAroundInvoke(Element envElement, IEnvironment env) {
        NodeList aroundInvokeList = envElement.getElementsByTagNameNS(this.getXMLNS(), "around-invoke");
        for (int i = 0; i < aroundInvokeList.getLength(); ++i) {
            Element aroundInvokeElement = (Element)aroundInvokeList.item(i);
            AroundInvoke aroundInvoke = new AroundInvoke();
            env.addAroundInvoke(aroundInvoke);
            String className = XMLUtils.getStringValueElement(this.getXMLNS(), aroundInvokeElement, "class");
            aroundInvoke.setClassName(className);
            String method = XMLUtils.getStringValueElement(this.getXMLNS(), aroundInvokeElement, "method-name");
            aroundInvoke.setMethodName(method);
        }
    }

    protected void analyzeEnvironment(Element envElement, IEnvironment env) {
        this.analyzeLifeCycle(envElement, env, "pre-passivate");
        this.analyzeLifeCycle(envElement, env, "post-activate");
        this.analyzeAroundInvoke(envElement, env);
        super.analyzeEnvironment(envElement, env);
    }

    public EJB3 getEJB3() {
        return this.ejb3;
    }
}

