/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl.xml.parsing;

import java.net.URL;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.war.impl.xml.parsing.AbsWebLoader;
import org.ow2.util.ee.metadata.war.impl.xml.struct.Tag;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WAR;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WARTLDLoader
extends AbsWebLoader {
    private static Log logger = LogFactory.getLog(WARTLDLoader.class);

    private WARTLDLoader(URL url, WAR war) {
        super(url, war);
    }

    public static WAR scanTLD(URL url, WAR war) throws ParsingException {
        logger.debug("Analyzing url {0}", url);
        WARTLDLoader warTldLoader = new WARTLDLoader(url, war);
        warTldLoader.parse();
        return warTldLoader.getWAR();
    }

    public void parse() throws ParsingException {
        Document document = null;
        try {
            document = DocumentParser.getDocument(this.getURL(), false, null);
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", e);
        }
        Element tagLibRootElement = document.getDocumentElement();
        this.analyzeListeners(tagLibRootElement);
        this.analyzeTags(tagLibRootElement);
    }

    protected void analyzeTags(Element rootElement) {
        NodeList tagList = rootElement.getElementsByTagName("tag");
        for (int i = 0; i < tagList.getLength(); ++i) {
            Element tagElement = (Element)tagList.item(i);
            Tag tag = new Tag();
            this.getWAR().addTag(tag);
            this.analyzeTag(tagElement, tag);
        }
    }

    protected void analyzeTag(Element tagElement, Tag tag) {
        String tagClassName = XMLUtils.getStringValueElement(tagElement, "tag-class");
        tag.setTagClassName(tagClassName);
    }
}

