/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.url;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.impl.url.UrlResourceFetcherFactory;
import org.ow2.util.plan.repository.api.IRepositoryManager;

public class UrlFetcherActivator
implements BundleActivator,
ServiceListener {
    private Log logger = LogFactory.getLog(UrlFetcherActivator.class);
    UrlResourceFetcherFactory fetcherFactory = null;
    private ServiceRegistration urlFetcherFactoryServiceRegistration = null;
    private static final String LISTENER_FILTER_STRING = "(objectClass=" + IRepositoryManager.class.getName() + ")";
    private BundleContext bundleContext = null;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.fetcherFactory = new UrlResourceFetcherFactory();
        context.addServiceListener((ServiceListener)this, LISTENER_FILTER_STRING);
        ServiceReference repositoryManagerRef = context.getServiceReference(IRepositoryManager.class.getName());
        if (repositoryManagerRef != null) {
            IRepositoryManager repositoryManager = (IRepositoryManager)context.getService(repositoryManagerRef);
            this.fetcherFactory.setRepositoryManager(repositoryManager);
            this.logger.debug("the repository manager is set to " + repositoryManager, new Object[0]);
        }
        this.urlFetcherFactoryServiceRegistration = context.registerService(IResourceFetcherFactory.class.getName(), (Object)this.fetcherFactory, null);
    }

    public void stop(BundleContext context) throws Exception {
        this.urlFetcherFactoryServiceRegistration.unregister();
        this.logger.debug("URL fetcher factory unregistered.", new Object[0]);
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        Object serviceObject = this.bundleContext.getService(serviceRef);
        if (serviceObject instanceof IRepositoryManager) {
            IRepositoryManager repositoryManager = (IRepositoryManager)serviceObject;
            switch (event.getType()) {
                case 1: {
                    if (this.fetcherFactory.getRepositoryManager() != null) break;
                    this.fetcherFactory.setRepositoryManager(repositoryManager);
                    this.logger.debug("The repository manager is set to '{0}'.", repositoryManager);
                    break;
                }
                case 4: {
                    this.fetcherFactory.setRepositoryManager(null);
                    this.logger.debug("The repository manager is unset.", new Object[0]);
                    break;
                }
            }
        }
    }
}

