/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.weaving;

import java.lang.instrument.ClassFileTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.instrument.InstrumentationSavingAgent;
import org.springframework.instrument.classloading.InstrumentationLoadTimeWeaver;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.ReflectiveLoadTimeWeaver;
import org.springframework.instrument.classloading.glassfish.GlassFishLoadTimeWeaver;
import org.springframework.instrument.classloading.oc4j.OC4JLoadTimeWeaver;
import org.springframework.instrument.classloading.weblogic.WebLogicLoadTimeWeaver;

public class DefaultContextLoadTimeWeaver
implements LoadTimeWeaver,
BeanClassLoaderAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private LoadTimeWeaver loadTimeWeaver;

    public void setBeanClassLoader(ClassLoader classLoader) {
        LoadTimeWeaver serverSpecificLoadTimeWeaver = this.createServerSpecificLoadTimeWeaver(classLoader);
        if (serverSpecificLoadTimeWeaver != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Determined server-specific load-time weaver: " + serverSpecificLoadTimeWeaver.getClass().getName());
            }
            this.loadTimeWeaver = serverSpecificLoadTimeWeaver;
        } else if (InstrumentationSavingAgent.getInstrumentation() != null) {
            this.logger.info("Found Spring's JVM agent for instrumentation");
            this.loadTimeWeaver = new InstrumentationLoadTimeWeaver();
        } else {
            try {
                this.loadTimeWeaver = new ReflectiveLoadTimeWeaver();
                this.logger.info("Using a reflective load-time weaver for class loader: " + this.loadTimeWeaver.getInstrumentableClassLoader());
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException(ex.getMessage() + " Specify a custom LoadTimeWeaver " + "or start your Java virtual machine with Spring's agent: -javaagent:spring-agent.jar");
            }
        }
    }

    protected LoadTimeWeaver createServerSpecificLoadTimeWeaver(ClassLoader classLoader) {
        try {
            if (classLoader.getClass().getName().startsWith("weblogic")) {
                return new WebLogicLoadTimeWeaver(classLoader);
            }
            if (classLoader.getClass().getName().startsWith("oracle")) {
                return new OC4JLoadTimeWeaver(classLoader);
            }
            if (this.isMatchingClassLoaderInHierarchy(classLoader, "com.sun.enterprise")) {
                return new GlassFishLoadTimeWeaver(classLoader);
            }
        }
        catch (IllegalStateException ex) {
            this.logger.info("Could not obtain server-specific LoadTimeWeaver: " + ex.getMessage());
        }
        return null;
    }

    private boolean isMatchingClassLoaderInHierarchy(ClassLoader classLoader, String loaderName) {
        return classLoader != null && (classLoader.getClass().getName().startsWith(loaderName) || this.isMatchingClassLoaderInHierarchy(classLoader.getParent(), loaderName));
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.loadTimeWeaver.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.loadTimeWeaver.getInstrumentableClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.loadTimeWeaver.getThrowawayClassLoader();
    }
}

