/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRuleSet;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;

public class MemoryRealm
extends RealmBase {
    private static Log log = LogFactory.getLog(MemoryRealm.class);
    private static Digester digester = null;
    protected final String info = "org.apache.catalina.realm.MemoryRealm/1.0";
    protected static final String name = "MemoryRealm";
    private String pathname = "conf/tomcat-users.xml";
    private Map<String, GenericPrincipal> principals = new HashMap<String, GenericPrincipal>();
    private static StringManager sm = StringManager.getManager("org.apache.catalina.realm");

    public String getInfo() {
        return "org.apache.catalina.realm.MemoryRealm/1.0";
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    public Principal authenticate(String username, String credentials) {
        GenericPrincipal principal = this.principals.get(username);
        boolean validated = false;
        if (principal != null) {
            validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(principal.getPassword()) : this.digest(credentials).equals(principal.getPassword());
        }
        if (validated) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("memoryRealm.authenticateSuccess", username));
            }
            return principal;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("memoryRealm.authenticateFailure", username));
        }
        return null;
    }

    void addUser(String username, String password, String roles) {
        int comma;
        ArrayList<String> list = new ArrayList<String>();
        roles = roles + ",";
        while ((comma = roles.indexOf(44)) >= 0) {
            String role = roles.substring(0, comma).trim();
            list.add(role);
            roles = roles.substring(comma + 1);
        }
        GenericPrincipal principal = new GenericPrincipal(this, username, password, list);
        this.principals.put(username, principal);
    }

    protected synchronized Digester getDigester() {
        if (digester == null) {
            digester = new Digester();
            digester.setValidating(false);
            digester.addRuleSet(new MemoryRuleSet());
        }
        return digester;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        GenericPrincipal principal = this.principals.get(username);
        if (principal != null) {
            return principal.getPassword();
        }
        return null;
    }

    protected Principal getPrincipal(String username) {
        return this.principals.get(username);
    }

    protected Map getPrincipals() {
        return this.principals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws LifecycleException {
        super.start();
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (!file.exists() || !file.canRead()) {
            throw new LifecycleException(sm.getString("memoryRealm.loadExist", file.getAbsolutePath()));
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("memoryRealm.loadPath", file.getAbsolutePath()));
        }
        Digester digester = this.getDigester();
        try {
            Digester digester2 = digester;
            synchronized (digester2) {
                digester.push(this);
                digester.parse(file);
            }
        }
        catch (Exception e) {
            throw new LifecycleException(sm.getString("memoryRealm.readXml"), e);
        }
        finally {
            digester.reset();
        }
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
    }
}

