/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPlugin;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASConfiguration
implements ConfigurationManager,
ConfigurationPlugin,
Pojo {
    private InstanceManager __IM;
    private boolean __FconfigurationAdmin;
    private ConfigurationAdmin configurationAdmin;
    private static final String JONAS_SERVICE = "jonas.service";
    private boolean __Fbc;
    private BundleContext bc;
    private boolean __FmandatoryServices;
    private List<String> mandatoryServices;
    private boolean __Flogger;
    private Log logger;
    private boolean __FserverProperties;
    private JProp serverProperties;
    private boolean __FlastModified;
    private long lastModified;
    private boolean __Mconfigure;
    private boolean __MhaltServer;
    private boolean __MupdateServiceConfiguration$java_lang_String;
    private boolean __MdeleteServiceConfiguration$java_lang_String;
    private boolean __MmatchService$java_lang_String;
    private boolean __MmanageServiceConfigurations$java_util_List$boolean;
    private boolean __MgetMandatoryServices;
    private boolean __MgetAllServices;
    private boolean __MgetOptionalServices;
    private boolean __MgetServiceProperties$java_lang_String;
    private boolean __MgetConfiguration$java_lang_String;
    private boolean __MgetFactoryPID$java_lang_String;
    private boolean __MmodifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary;
    private boolean __MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin;
    private boolean __MisConfigurationModified$java_util_Dictionary$java_util_Dictionary;
    private boolean __MdeleteServiceConfigurations;
    private boolean __MgetServerProperties;
    private boolean __MremoveDuplicateServices$java_util_List;

    ConfigurationAdmin __getconfigurationAdmin() {
        if (!this.__FconfigurationAdmin) {
            return this.configurationAdmin;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "configurationAdmin");
    }

    void __setconfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__FconfigurationAdmin) {
            this.configurationAdmin = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "configurationAdmin", (Object)configurationAdmin);
    }

    BundleContext __getbc() {
        if (!this.__Fbc) {
            return this.bc;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bc");
    }

    void __setbc(BundleContext bundleContext) {
        if (!this.__Fbc) {
            this.bc = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bc", (Object)bundleContext);
    }

    List __getmandatoryServices() {
        if (!this.__FmandatoryServices) {
            return this.mandatoryServices;
        }
        return (List)this.__IM.onGet((Object)this, "mandatoryServices");
    }

    void __setmandatoryServices(List list) {
        if (!this.__FmandatoryServices) {
            this.mandatoryServices = list;
            return;
        }
        this.__IM.onSet((Object)this, "mandatoryServices", (Object)list);
    }

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    JProp __getserverProperties() {
        if (!this.__FserverProperties) {
            return this.serverProperties;
        }
        return (JProp)this.__IM.onGet((Object)this, "serverProperties");
    }

    void __setserverProperties(JProp jProp) {
        if (!this.__FserverProperties) {
            this.serverProperties = jProp;
            return;
        }
        this.__IM.onSet((Object)this, "serverProperties", (Object)jProp);
    }

    long __getlastModified() {
        if (!this.__FlastModified) {
            return this.lastModified;
        }
        Object object = this.__IM.onGet((Object)this, "lastModified");
        Long l = (Long)object;
        return l;
    }

    void __setlastModified(long l) {
        if (!this.__FlastModified) {
            this.lastModified = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "lastModified", (Object)l2);
    }

    public JOnASConfiguration(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private JOnASConfiguration(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setconfigurationAdmin(null);
        this.__setbc(null);
        this.__setmandatoryServices(null);
        this.__setlogger(LogFactory.getLog(JOnASConfiguration.class));
        this.__setserverProperties(null);
        this.__setbc(bc);
        this.__setmandatoryServices(new ArrayList());
        this.__getmandatoryServices().add("registry");
        this.__getmandatoryServices().add("jmx");
    }

    public void configure() throws Exception {
        if (!this.__Mconfigure) {
            this.__configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    private void __configure() throws Exception {
        this.deleteServiceConfigurations();
        this.manageServiceConfigurations(this.__getmandatoryServices(), false);
        ServiceReference sr = this.__getbc().getServiceReference(ServerProperties.class.getName());
        if (sr == null) {
            this.__getbc().registerService(ServerProperties.class.getName(), (Object)this.getServerProperties(), null);
        }
    }

    public void haltServer() throws Exception {
        if (!this.__MhaltServer) {
            this.__haltServer();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "haltServer", new Object[0]);
            this.__haltServer();
            this.__IM.onExit((Object)this, "haltServer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "haltServer", throwable);
            throw throwable;
        }
    }

    private void __haltServer() throws Exception {
        this.__getbc().getBundle(0L).stop();
    }

    public synchronized void updateServiceConfiguration(String string) throws Exception {
        if (!this.__MupdateServiceConfiguration$java_lang_String) {
            this.__updateServiceConfiguration(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateServiceConfiguration$java_lang_String", new Object[]{string});
            this.__updateServiceConfiguration(string);
            this.__IM.onExit((Object)this, "updateServiceConfiguration$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateServiceConfiguration$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __updateServiceConfiguration(String service) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        services.add(service);
        this.manageServiceConfigurations(services, false);
    }

    public synchronized void deleteServiceConfiguration(String string) throws Exception {
        if (!this.__MdeleteServiceConfiguration$java_lang_String) {
            this.__deleteServiceConfiguration(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteServiceConfiguration$java_lang_String", new Object[]{string});
            this.__deleteServiceConfiguration(string);
            this.__IM.onExit((Object)this, "deleteServiceConfiguration$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteServiceConfiguration$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __deleteServiceConfiguration(String service) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        services.add(service);
        this.manageServiceConfigurations(services, true);
    }

    public boolean matchService(String string) {
        boolean bl;
        if (!this.__MmatchService$java_lang_String) {
            return this.__matchService(string);
        }
        try {
            this.__IM.onEntry((Object)this, "matchService$java_lang_String", new Object[]{string});
            bl = this.__matchService(string);
            this.__IM.onExit((Object)this, "matchService$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "matchService$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __matchService(String service) {
        String serviceClass = "jonas.service." + service + ".class";
        String factoryPID = this.getServerProperties().getValue(serviceClass);
        return factoryPID != null;
    }

    private void manageServiceConfigurations(List<String> list, boolean bl) throws Exception {
        if (!this.__MmanageServiceConfigurations$java_util_List$boolean) {
            this.__manageServiceConfigurations(list, bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "manageServiceConfigurations$java_util_List$boolean", new Object[]{list, new Boolean(bl)});
            this.__manageServiceConfigurations(list, bl);
            this.__IM.onExit((Object)this, "manageServiceConfigurations$java_util_List$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "manageServiceConfigurations$java_util_List$boolean", throwable);
            throw throwable;
        }
    }

    private void __manageServiceConfigurations(List<String> services, boolean delete) throws Exception {
        for (String service : this.removeDuplicateServices(services)) {
            Dictionary<String, String> newProperties = null;
            if (!delete) {
                newProperties = this.getServiceProperties(service);
            }
            Configuration configuration = this.getConfiguration(service);
            if (!delete && configuration == null) {
                configuration = this.__getconfigurationAdmin().createFactoryConfiguration(this.getFactoryPID(service), null);
                configuration.update(newProperties);
                continue;
            }
            if (configuration == null) continue;
            configuration = this.__getconfigurationAdmin().getConfiguration(configuration.getPid(), null);
            if (delete) {
                configuration.delete();
                continue;
            }
            Dictionary storedProperties = configuration.getProperties();
            if (!this.isConfigurationModified(storedProperties, newProperties)) continue;
            configuration.update(newProperties);
        }
    }

    public List<String> getMandatoryServices() {
        List<String> list;
        if (!this.__MgetMandatoryServices) {
            return this.__getMandatoryServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getMandatoryServices", new Object[0]);
            list = this.__getMandatoryServices();
            this.__IM.onExit((Object)this, "getMandatoryServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMandatoryServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getMandatoryServices() {
        return this.__getmandatoryServices();
    }

    public List<String> getAllServices() {
        List<String> list;
        if (!this.__MgetAllServices) {
            return this.__getAllServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getAllServices", new Object[0]);
            list = this.__getAllServices();
            this.__IM.onExit((Object)this, "getAllServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getAllServices() {
        List<String> allServices = this.getOptionalServices();
        for (int i = 0; i < this.__getmandatoryServices().size(); ++i) {
            allServices.add(i, (String)this.__getmandatoryServices().get(i));
        }
        return allServices;
    }

    public List<String> getOptionalServices() {
        List<String> list;
        if (!this.__MgetOptionalServices) {
            return this.__getOptionalServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getOptionalServices", new Object[0]);
            list = this.__getOptionalServices();
            this.__IM.onExit((Object)this, "getOptionalServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOptionalServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getOptionalServices() {
        String[] declaredServices = this.getServerProperties().getValueAsArray("jonas.services");
        ArrayList<String> optionalServices = new ArrayList<String>();
        for (String declaredService : declaredServices) {
            if (this.__getmandatoryServices().contains(declaredService)) continue;
            optionalServices.add(declaredService);
        }
        return optionalServices;
    }

    public Dictionary<String, String> getServiceProperties(String string) {
        Dictionary<String, String> dictionary;
        if (!this.__MgetServiceProperties$java_lang_String) {
            return this.__getServiceProperties(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceProperties$java_lang_String", new Object[]{string});
            dictionary = this.__getServiceProperties(string);
            this.__IM.onExit((Object)this, "getServiceProperties$java_lang_String", dictionary);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceProperties$java_lang_String", throwable);
            throw throwable;
        }
        return dictionary;
    }

    private Dictionary<String, String> __getServiceProperties(String service) {
        JProp serverProperties = this.getServerProperties();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(JONAS_SERVICE, service);
        for (Object key : serverProperties.getConfigFileEnv().keySet()) {
            String servicePrefix;
            String name = (String)key;
            if (!name.startsWith(servicePrefix = "jonas.service." + service + ".")) continue;
            String value = serverProperties.getValue(name);
            name = name.substring(servicePrefix.length());
            ((Dictionary)props).put(name, value);
        }
        return props;
    }

    private Configuration getConfiguration(String string) throws Exception {
        Configuration configuration;
        if (!this.__MgetConfiguration$java_lang_String) {
            return this.__getConfiguration(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getConfiguration$java_lang_String", new Object[]{string});
            configuration = this.__getConfiguration(string);
            this.__IM.onExit((Object)this, "getConfiguration$java_lang_String", (Object)configuration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConfiguration$java_lang_String", throwable);
            throw throwable;
        }
        return configuration;
    }

    private Configuration __getConfiguration(String service) throws Exception {
        Configuration[] storedConfigurations = this.__getconfigurationAdmin().listConfigurations("(service.factoryPid=" + this.getFactoryPID(service) + ")");
        if (storedConfigurations != null && storedConfigurations.length == 1) {
            return storedConfigurations[0];
        }
        return null;
    }

    private String getFactoryPID(String string) {
        String string2;
        if (!this.__MgetFactoryPID$java_lang_String) {
            return this.__getFactoryPID(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getFactoryPID$java_lang_String", new Object[]{string});
            string2 = this.__getFactoryPID(string);
            this.__IM.onExit((Object)this, "getFactoryPID$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFactoryPID$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getFactoryPID(String service) {
        String serviceClass = "jonas.service." + service + ".class";
        return this.getServerProperties().getValue(serviceClass);
    }

    public void modifyConfiguration(ServiceReference serviceReference, Dictionary dictionary) {
        if (!this.__MmodifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary) {
            this.__modifyConfiguration(serviceReference, dictionary);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary", new Object[]{serviceReference, dictionary});
            this.__modifyConfiguration(serviceReference, dictionary);
            this.__IM.onExit((Object)this, "modifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __modifyConfiguration(ServiceReference serviceReference, Dictionary storedProperties) {
        try {
            Dictionary<String, String> newProperties;
            String serviceName = (String)storedProperties.get(JONAS_SERVICE);
            if (serviceName != null && this.isConfigurationModified(storedProperties, newProperties = this.getServiceProperties(serviceName))) {
                Enumeration<String> enProps = newProperties.keys();
                while (enProps.hasMoreElements()) {
                    String key = enProps.nextElement();
                    storedProperties.put(key, newProperties.get(key));
                }
            }
        }
        catch (Exception e) {
            this.__getlogger().error((Object)e, new Object[0]);
        }
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin) {
            this.__setConfigurationAdmin(configurationAdmin);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", new Object[]{configurationAdmin});
            this.__setConfigurationAdmin(configurationAdmin);
            this.__IM.onExit((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", throwable);
            throw throwable;
        }
    }

    private void __setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.__setconfigurationAdmin(configurationAdmin);
    }

    private boolean isConfigurationModified(Dictionary<String, String> dictionary, Dictionary<String, String> dictionary2) {
        boolean bl;
        if (!this.__MisConfigurationModified$java_util_Dictionary$java_util_Dictionary) {
            return this.__isConfigurationModified(dictionary, dictionary2);
        }
        try {
            this.__IM.onEntry((Object)this, "isConfigurationModified$java_util_Dictionary$java_util_Dictionary", new Object[]{dictionary, dictionary2});
            bl = this.__isConfigurationModified(dictionary, dictionary2);
            this.__IM.onExit((Object)this, "isConfigurationModified$java_util_Dictionary$java_util_Dictionary", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isConfigurationModified$java_util_Dictionary$java_util_Dictionary", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isConfigurationModified(Dictionary<String, String> storedProperties, Dictionary<String, String> newProperties) {
        storedProperties.remove("service.pid");
        storedProperties.remove("service.factoryPid");
        storedProperties.remove("service.bundleLocation");
        if (storedProperties.size() != newProperties.size()) {
            return true;
        }
        Enumeration<String> enProps = storedProperties.keys();
        while (enProps.hasMoreElements()) {
            String key = enProps.nextElement();
            if (newProperties.get(key) == null) {
                return true;
            }
            if (storedProperties.get(key).equals(newProperties.get(key))) continue;
            return true;
        }
        return false;
    }

    private void deleteServiceConfigurations() throws Exception {
        if (!this.__MdeleteServiceConfigurations) {
            this.__deleteServiceConfigurations();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteServiceConfigurations", new Object[0]);
            this.__deleteServiceConfigurations();
            this.__IM.onExit((Object)this, "deleteServiceConfigurations", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteServiceConfigurations", throwable);
            throw throwable;
        }
    }

    private void __deleteServiceConfigurations() throws Exception {
        Configuration[] storedConfigurations = this.__getconfigurationAdmin().listConfigurations(null);
        if (storedConfigurations != null) {
            for (Configuration configuration : storedConfigurations) {
                String serviceName = (String)configuration.getProperties().get(JONAS_SERVICE);
                if (serviceName == null) continue;
                configuration.delete();
            }
        }
    }

    private JProp getServerProperties() {
        JProp jProp;
        if (!this.__MgetServerProperties) {
            return this.__getServerProperties();
        }
        try {
            this.__IM.onEntry((Object)this, "getServerProperties", new Object[0]);
            jProp = this.__getServerProperties();
            this.__IM.onExit((Object)this, "getServerProperties", (Object)jProp);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServerProperties", throwable);
            throw throwable;
        }
        return jProp;
    }

    private JProp __getServerProperties() {
        File conf = new File(JProp.getJonasBase(), "conf");
        File jonasPropertyFile = new File(conf, "jonas.properties");
        long currentLastModified = jonasPropertyFile.lastModified();
        if (currentLastModified != this.__getlastModified()) {
            this.__setserverProperties(new JProp());
            this.__setlastModified(currentLastModified);
        }
        return this.__getserverProperties();
    }

    private List<String> removeDuplicateServices(List<String> list) {
        List<String> list2;
        if (!this.__MremoveDuplicateServices$java_util_List) {
            return this.__removeDuplicateServices(list);
        }
        try {
            this.__IM.onEntry((Object)this, "removeDuplicateServices$java_util_List", new Object[]{list});
            list2 = this.__removeDuplicateServices(list);
            this.__IM.onExit((Object)this, "removeDuplicateServices$java_util_List", list2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeDuplicateServices$java_util_List", throwable);
            throw throwable;
        }
        return list2;
    }

    private List<String> __removeDuplicateServices(List<String> services) {
        LinkedList<String> result = new LinkedList<String>();
        for (String service : services) {
            if (!result.contains(service)) {
                result.add(service);
                continue;
            }
            this.__getlogger().warn((Object)"Service ''{0}'' declared many times in jonas.properties", new Object[]{service});
        }
        return result;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("serverProperties")) {
                this.__FserverProperties = true;
            }
            if (set.contains("bc")) {
                this.__Fbc = true;
            }
            if (set.contains("configurationAdmin")) {
                this.__FconfigurationAdmin = true;
            }
            if (set.contains("lastModified")) {
                this.__FlastModified = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("mandatoryServices")) {
                this.__FmandatoryServices = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("haltServer")) {
                this.__MhaltServer = true;
            }
            if (set.contains("updateServiceConfiguration$java_lang_String")) {
                this.__MupdateServiceConfiguration$java_lang_String = true;
            }
            if (set.contains("deleteServiceConfiguration$java_lang_String")) {
                this.__MdeleteServiceConfiguration$java_lang_String = true;
            }
            if (set.contains("matchService$java_lang_String")) {
                this.__MmatchService$java_lang_String = true;
            }
            if (set.contains("manageServiceConfigurations$java_util_List$boolean")) {
                this.__MmanageServiceConfigurations$java_util_List$boolean = true;
            }
            if (set.contains("getMandatoryServices")) {
                this.__MgetMandatoryServices = true;
            }
            if (set.contains("getAllServices")) {
                this.__MgetAllServices = true;
            }
            if (set.contains("getOptionalServices")) {
                this.__MgetOptionalServices = true;
            }
            if (set.contains("getServiceProperties$java_lang_String")) {
                this.__MgetServiceProperties$java_lang_String = true;
            }
            if (set.contains("getConfiguration$java_lang_String")) {
                this.__MgetConfiguration$java_lang_String = true;
            }
            if (set.contains("getFactoryPID$java_lang_String")) {
                this.__MgetFactoryPID$java_lang_String = true;
            }
            if (set.contains("modifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary")) {
                this.__MmodifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary = true;
            }
            if (set.contains("setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin")) {
                this.__MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin = true;
            }
            if (set.contains("isConfigurationModified$java_util_Dictionary$java_util_Dictionary")) {
                this.__MisConfigurationModified$java_util_Dictionary$java_util_Dictionary = true;
            }
            if (set.contains("deleteServiceConfigurations")) {
                this.__MdeleteServiceConfigurations = true;
            }
            if (set.contains("getServerProperties")) {
                this.__MgetServerProperties = true;
            }
            if (set.contains("removeDuplicateServices$java_util_List")) {
                this.__MremoveDuplicateServices$java_util_List = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

