/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.easybeans.ext;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.ClassLoaderResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.container.EmptyLifeCycleCallBack;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.jonas.ws.cxf.JOnASJaxWsImplementorInfo;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansEndpoint;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansJaxWsServerFactoryBean;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansJaxWsServiceFactoryBean;
import org.ow2.jonas.ws.cxf.jaxws.CXFWSEndpoint;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesModule;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.base.JAXWSWebservicesContainer;
import org.ow2.jonas.ws.jaxws.util.JAXWSClassUtils;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.ow2.jonas.ws.publish.WSDLPublisherManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleCallback
extends EmptyLifeCycleCallBack {
    private static Log logger = LogFactory.getLog(LifeCycleCallback.class);
    private IWebServiceDeploymentManager manager;
    private WSDLPublisherManager publisherManager;
    private Map<String, WebservicesModule> modules = new HashMap<String, WebservicesModule>();

    public void start(EZBContainerCallbackInfo info) {
        String name = info.getArchive().getName();
        WebservicesModule module = null;
        Map factories = info.getFactories();
        for (Factory f : factories.values()) {
            String directory;
            WebservicesContainer container;
            StatelessSessionFactory factory;
            Class klass;
            if (!(f instanceof StatelessSessionFactory) || !JAXWSClassUtils.isWebService((Class)(klass = (factory = (StatelessSessionFactory)f).getBeanClass()))) continue;
            IBeanInfo beanInfo = factory.getBeanInfo();
            IWebServiceInfo webServiceInfo = beanInfo.getWebServiceInfo();
            PortMetaData pmd = new PortMetaData();
            String contextRoot = LifeCycleCallback.extractContextRoot(info.getArchive().getName());
            pmd.setContextRoot(contextRoot);
            JOnASJaxWsImplementorInfo jaxWsImplementorInfo = webServiceInfo != null ? new JOnASJaxWsImplementorInfo(klass, webServiceInfo) : new JOnASJaxWsImplementorInfo(klass);
            module = this.modules.get(name);
            if (module == null) {
                module = new WebservicesModule(name);
                this.modules.put(name, module);
            }
            if ((container = (WebservicesContainer)module.findContainer(jaxWsImplementorInfo.getWsdlLocation())) == null) {
                container = new WebservicesContainer(jaxWsImplementorInfo.getWsdlLocation());
                module.addContainer(container);
                ResourceManager manager = (ResourceManager)container.getBus().getExtension(ResourceManager.class);
                manager.addResourceResolver((ResourceResolver)new ClassLoaderResolver(klass.getClassLoader()));
            }
            String pattern = this.getUrlPattern(klass, webServiceInfo, jaxWsImplementorInfo);
            pmd.setUrlPattern(pattern);
            EasyBeansEndpoint easybeansEndpoint = this.createEasyBeansEndpoint(factory, container.getBus(), jaxWsImplementorInfo);
            CXFWSEndpoint endpoint = new CXFWSEndpoint(easybeansEndpoint, IWebServiceEndpoint.EndpointType.EJB, pmd, container);
            container.addEndpoint(endpoint);
            if (webServiceInfo == null || (directory = webServiceInfo.getWsdlPublicationDirectory()) == null) continue;
            container.setWsdlPublicationDirectory(directory);
        }
        if (module != null) {
            module.start();
            for (JAXWSWebservicesContainer container : module.getContainers()) {
                for (IWebServiceEndpoint endpoint : container.getEndpoints()) {
                    try {
                        this.manager.registerWSEndpoint(endpoint);
                        endpoint.displayInfos();
                    }
                    catch (WSException e) {
                        logger.error((Object)"Unable to register endpoint ''{0}''", new Object[]{endpoint, e});
                        try {
                            this.manager.unregisterWSEndpoint(endpoint);
                        }
                        catch (WSException e1) {
                            logger.error((Object)"Unable to unregister endpoint ''{0}'' after a failed deployment", new Object[]{endpoint, e});
                        }
                    }
                }
                this.publishWSDL((WebservicesContainer)container);
            }
        }
    }

    protected void checkEnableMtom(JaxWsServiceFactoryBean jaxWsServiceFactoryBean, JOnASJaxWsImplementorInfo info) {
        String protocolBinding;
        if (info == null) {
            return;
        }
        if (info.isMTOMEnabled() && (protocolBinding = info.getBindingType()) != null && ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(protocolBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(protocolBinding))) {
            ArrayList<MTOMFeature> wsFeatures = jaxWsServiceFactoryBean.getWsFeatures();
            if (wsFeatures == null) {
                wsFeatures = new ArrayList<MTOMFeature>();
                jaxWsServiceFactoryBean.setWsFeatures(wsFeatures);
            }
            wsFeatures.add(new MTOMFeature(true));
        }
    }

    private String getUrlPattern(Class<?> klass, IWebServiceInfo webServiceInfo, JaxWsImplementorInfo jaxWsImplementorInfo) {
        String pattern;
        if (webServiceInfo != null && webServiceInfo.getEndpointAddress() != null) {
            pattern = webServiceInfo.getEndpointAddress();
            if (!pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
        } else {
            String serviceName = jaxWsImplementorInfo.getServiceName().getLocalPart();
            pattern = !"".equals(serviceName) ? "/" + serviceName : "/" + klass.getSimpleName() + "Service";
        }
        return pattern;
    }

    private void publishWSDL(WebservicesContainer container) {
        try {
            this.publisherManager.publish(container.getPublishableDefinitions());
        }
        catch (WSDLPublisherException e) {
            logger.error((Object)"Unable to publish WSDL for the container ''{0}''", new Object[]{container.getName(), e});
        }
    }

    private static String extractContextRoot(String filename) {
        String context = filename.substring(filename.lastIndexOf(File.separator) + 1);
        int underscoreIndex = context.indexOf(95);
        context = underscoreIndex == -1 ? context.substring(0, context.lastIndexOf(46)) : context.substring(0, underscoreIndex);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EasyBeansEndpoint createEasyBeansEndpoint(StatelessSessionFactory factory, Bus bus, JOnASJaxWsImplementorInfo info) {
        EasyBeansJaxWsServiceFactoryBean jaxWsServiceFactoryBean = new EasyBeansJaxWsServiceFactoryBean(info, factory);
        jaxWsServiceFactoryBean.setBus(bus);
        this.checkEnableMtom(jaxWsServiceFactoryBean, info);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Bus.class.getClassLoader());
            jaxWsServiceFactoryBean.setServiceName(info.getServiceName());
            jaxWsServiceFactoryBean.create();
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
        EasyBeansJaxWsServerFactoryBean factoryBean = new EasyBeansJaxWsServerFactoryBean(jaxWsServiceFactoryBean, factory);
        EasyBeansEndpoint endpoint = new EasyBeansEndpoint(factory, bus, factoryBean);
        endpoint.setServiceFactory(jaxWsServiceFactoryBean);
        HashMap<String, QName> properties = new HashMap<String, QName>();
        if (info.getServiceName() != null) {
            properties.put("javax.xml.ws.wsdl.service", info.getServiceName());
        }
        if (info.getEndpointName() != null) {
            properties.put("javax.xml.ws.wsdl.port", info.getEndpointName());
        }
        endpoint.setProperties(properties);
        return endpoint;
    }

    public void stop(EZBContainerCallbackInfo info) {
        String name = info.getArchive().getName();
        WebservicesModule module = this.modules.get(name);
        if (module != null) {
            this.stopWebservicesModule(module);
            this.modules.remove(name);
        }
    }

    public void stop() {
        logger.debug((Object)"Stop ''{0}''", new Object[]{this});
        for (Map.Entry<String, WebservicesModule> entry : this.modules.entrySet()) {
            WebservicesModule module = entry.getValue();
            this.stopWebservicesModule(module);
        }
        this.modules.clear();
    }

    private void stopWebservicesModule(WebservicesModule module) {
        for (JAXWSWebservicesContainer container : module.getContainers()) {
            for (IWebServiceEndpoint endpoint : container.getEndpoints()) {
                try {
                    this.manager.unregisterWSEndpoint(endpoint);
                }
                catch (WSException wse) {
                    logger.warn((Object)"Cannot unregister endpoint ''{0}'', continue processing", new Object[]{endpoint, wse});
                }
            }
        }
        module.stop();
    }

    public void setManager(IWebServiceDeploymentManager manager) {
        this.manager = manager;
    }

    public void setWSDLPublisherManager(WSDLPublisherManager publisherManager) {
        this.publisherManager = publisherManager;
    }
}

