/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.xml2mi.lib;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXParserHelper
implements EntityResolver,
ErrorHandler {
    private Properties publicid2location = null;
    private ClassLoader classLoader;
    private List errors;
    private DocumentBuilder parser;
    private Logger logger;

    public SAXParserHelper(Properties publicid2location, Logger logger) throws SAXException {
        this.publicid2location = publicid2location;
        this.logger = logger;
        this.classLoader = this.getClass().getClassLoader();
        if (this.classLoader == null) {
            this.classLoader = ClassLoader.getSystemClassLoader();
        }
        this.init(true);
    }

    public SAXParserHelper(Properties publicid2location, Logger logger, ClassLoader cl, boolean dtdverify) throws SAXException {
        this.publicid2location = publicid2location;
        this.logger = logger;
        this.classLoader = cl;
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
            if (this.classLoader == null) {
                this.classLoader = ClassLoader.getSystemClassLoader();
            }
        }
        this.init(dtdverify);
    }

    public Document parse(String xmlFileName) throws SAXException {
        InputStream is = null;
        try {
            is = new FileInputStream(xmlFileName);
        }
        catch (FileNotFoundException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(xmlFileName + " is not a local file "));
        }
        if (is == null) {
            URL urldtd = null;
            try {
                urldtd = new URL(xmlFileName);
                is = urldtd.openStream();
            }
            catch (IOException e) {
                this.logger.log(BasicLevel.DEBUG, (Object)(xmlFileName + " is not an URL "));
            }
        }
        if (is == null && (is = this.classLoader.getResourceAsStream(xmlFileName)) == null) {
            this.logger.log(BasicLevel.DEBUG, (Object)(xmlFileName + " is not availlable in the classpath"));
        }
        if (is == null) {
            int idx = xmlFileName.indexOf(".jar!");
            if (idx != -1) {
                try {
                    ZipEntry zipentry;
                    JarFile jarfile = new JarFile(xmlFileName.substring(0, idx));
                    if (jarfile != null && (zipentry = jarfile.getEntry(xmlFileName.substring(idx + 5, xmlFileName.length()))) != null) {
                        is = jarfile.getInputStream(zipentry);
                    }
                }
                catch (Exception e) {
                    this.logger.log(BasicLevel.DEBUG, (Object)(xmlFileName + " is not in a jar file"));
                }
            } else {
                this.logger.log(BasicLevel.DEBUG, (Object)(xmlFileName + " is not in a jar file"));
            }
        }
        if (is == null) {
            throw new SAXException("No XML file '" + xmlFileName + "' found");
        }
        return this.parse(is);
    }

    public Document parse(InputStream is) throws SAXException {
        if (this.errors != null) {
            this.errors.clear();
        }
        try {
            Document d = this.parser.parse(is, ".");
            if (d == null) {
                throw new SAXException("No document");
            }
            return d;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void init(boolean dtdverify) throws SAXException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setValidating(dtdverify);
        try {
            this.parser = domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        this.parser.setEntityResolver(this);
        this.parser.setErrorHandler(this);
    }

    private List getErrorList() {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        return this.errors;
    }

    public void error(SAXParseException e) throws SAXException {
        this.logger.log(BasicLevel.ERROR, (Object)e.getMessage(), (Throwable)e);
        this.getErrorList().add(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.logger.log(BasicLevel.FATAL, (Object)e.getMessage(), (Throwable)e);
        this.getErrorList().add(e);
    }

    public void warning(SAXParseException e) throws SAXException {
        this.logger.log(BasicLevel.WARN, (Object)e.getMessage(), (Throwable)e);
        this.getErrorList().add(e);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        int idx;
        String publicid = publicId;
        String location = null;
        if (publicid == null) {
            location = systemId;
        } else {
            this.logger.log(BasicLevel.DEBUG, (Object)("Looking for the publicId: " + publicid));
            Iterator<Map.Entry<Object, Object>> it = this.publicid2location.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> me = it.next();
                String current = (String)me.getKey();
                this.logger.log(BasicLevel.DEBUG, (Object)("Current public id: " + current));
                if (!current.equals(publicid)) continue;
                location = (String)me.getValue();
                break;
            }
        }
        if (location == null) {
            this.logger.log(BasicLevel.INFO, (Object)("No dtd location found for the publicId: " + publicid));
            if (systemId == null) {
                throw new SAXException("Could not resolve publicid: " + publicid);
            }
            this.logger.log(BasicLevel.INFO, (Object)("Try to resolve " + publicid + " with the default location " + systemId));
            location = systemId;
        }
        InputStream is = null;
        try {
            is = new FileInputStream(location);
            this.logger.log(BasicLevel.DEBUG, (Object)("Resolved " + publicid + " to local file " + location));
        }
        catch (FileNotFoundException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(location + " is not a local file "));
        }
        if (is == null) {
            URL urldtd = null;
            try {
                urldtd = new URL(location);
                is = urldtd.openStream();
                this.logger.log(BasicLevel.DEBUG, (Object)("Resolved " + publicid + " to url " + urldtd));
            }
            catch (IOException e) {
                this.logger.log(BasicLevel.DEBUG, (Object)(location + " is not an URL "));
            }
        }
        if (is == null) {
            is = this.classLoader.getResourceAsStream(location);
            if (is != null) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Resolved " + publicid + " to resource " + location));
            } else {
                this.logger.log(BasicLevel.DEBUG, (Object)(location + " is not availlable in the classpath"));
            }
        }
        if (is == null && (idx = location.indexOf(".jar!")) != -1) {
            try {
                ZipEntry zipentry;
                JarFile jarfile = new JarFile(location.substring(0, idx));
                if (jarfile != null && (zipentry = jarfile.getEntry(location.substring(idx + 5, location.length()))) != null) {
                    is = jarfile.getInputStream(zipentry);
                }
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.DEBUG, (Object)(location + " is not an jar file"));
            }
        }
        if (is != null) {
            return new InputSource(is);
        }
        throw new SAXException("Could not resolve publicid: [" + publicid + "] location [" + location + "]");
    }
}

