/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.distributed;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.AttributeController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.perseus.concurrency.api.ConcurrencyException;
import org.objectweb.perseus.concurrency.api.ConcurrencyManager;
import org.objectweb.perseus.concurrency.distributed.globallock.api.DeadLockException;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLock;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLockException;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLockManager;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLockWaiter;
import org.objectweb.perseus.concurrency.pessimistic.Lock;
import org.objectweb.perseus.concurrency.pessimistic.PessimisticConcurrencyManager;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class DistributedConcurrencyManager
extends PessimisticConcurrencyManager
implements AttributeController {
    public static final String GLOBAL_LOCK_MANAGER_BINDING = "global-lock-manager";
    private long timeout = 0L;
    private GlobalLockManager gLockMgr;

    public void setTimeOut(long timeout) {
        this.timeout = timeout;
    }

    public String[] listFc() {
        String[] super_res = super.listFc();
        String[] res = new String[super_res.length + 1];
        for (int cpt = 0; cpt < super_res.length; ++cpt) {
            res[cpt] = super_res[cpt];
        }
        res[cpt] = GLOBAL_LOCK_MANAGER_BINDING;
        return res;
    }

    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (GLOBAL_LOCK_MANAGER_BINDING.equals(s)) {
            return this.gLockMgr;
        }
        return super.lookupFc(s);
    }

    public void bindFc(String s, Object o) throws IllegalBindingException, NoSuchInterfaceException {
        if (GLOBAL_LOCK_MANAGER_BINDING.equals(s)) {
            if (this.gLockMgr != null) {
                throw new IllegalBindingException(s + ": Already bound");
            }
            try {
                this.gLockMgr = (GlobalLockManager)o;
            }
            catch (ClassCastException e) {
                throw new IllegalBindingException(s + ":" + e.getMessage());
            }
        } else {
            super.bindFc(s, o);
        }
    }

    public void unbindFc(String s) throws NoSuchInterfaceException {
        if (GLOBAL_LOCK_MANAGER_BINDING.equals(s)) {
            this.gLockMgr = null;
        } else {
            super.unbindFc(s);
        }
    }

    public void begin(Object ctx) {
        super.begin(ctx);
    }

    public void finalize(Object ctx) {
        this.freeLocks(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeLocks(Object ctx) {
        Map map = this.locks;
        synchronized (map) {
            Iterator entries = this.locks.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Lock lock = (Lock)entry.getValue();
                Object resourceId = entry.getKey();
                GlobalLock gl = null;
                try {
                    gl = this.getDistLock(resourceId, lock.hints, true);
                }
                catch (ConcurrencyException e) {
                    this.logger.log(BasicLevel.ERROR, (Object)("Error during the finalize of the context " + ctx + ": oid=" + resourceId), (Throwable)e);
                }
                if (lock.close(ctx)) {
                    gl.downgrade((byte)0);
                    entries.remove();
                } else {
                    gl.downgrade(lock.getMax());
                }
                if (gl.getGrantable() != 0) continue;
                this.invalidateState(resourceId, lock.hints);
            }
        }
        this.contextInfos.remove(ctx);
    }

    public void abort(Object ctx) {
        this.freeLocks(ctx);
    }

    private Object accessIntention(Object ctx, Object resourceId, Object thinLock, byte lck, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        try {
            Lock l = this.getLock(resourceId, thinLock);
            GlobalLock gl = this.getDistLock(resourceId, l.hints, true);
            GlobalLockWaiter w = gl.upgrade(lck, false, this.timeout);
            if (w != null && !w.waitLock(this.timeout)) {
                w.signalHandled();
                throw new DeadLockException();
            }
            if (lck == 1) {
                l.readIntention(ctx);
            } else {
                l.writeIntention(ctx);
            }
            if (w != null) {
                w.signalHandled();
            }
            if (resProv == null) {
                return null;
            }
            return resProv.getResource(ctx, resourceId, resourceHints, thinLock, false, null, l.oid);
        }
        catch (ConcurrencyException e) {
            this.getContextInfo((Object)ctx).rollback = true;
            throw e;
        }
        catch (Exception e) {
            throw new ConcurrencyException(e);
        }
    }

    public Object readIntention(Object ctx, Object resourceId, Object hints, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        return this.accessIntention(ctx, resourceId, hints, (byte)1, resProv, resourceHints);
    }

    public Object writeIntention(Object ctx, Object resourceId, Object hints, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        return this.accessIntention(ctx, resourceId, hints, (byte)3, resProv, resourceHints);
    }

    public void uncacheGlobal(Object oid) {
        try {
            GlobalLock gl = this.gLockMgr.getGlobalLock((Serializable)oid, false);
            if (gl != null) {
                gl.uncache();
            }
        }
        catch (GlobalLockException globalLockException) {
            // empty catch block
        }
    }

    public boolean isDistGrantable(Object resId, byte lck, Object hints) throws ConcurrencyException {
        GlobalLock distLock = this.getDistLock(resId, hints, false);
        return distLock.getGrantable() >= lck;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected GlobalLock getDistLock(Object resourceId, Object hints, boolean doInvalidate) throws ConcurrencyException {
        GlobalLock gl;
        try {
            gl = this.gLockMgr.getGlobalLock((Serializable)resourceId, true);
        }
        catch (GlobalLockException e) {
            throw new ConcurrencyException(e);
        }
        if (doInvalidate && gl.getGrantable() == 0) {
            this.invalidateState(resourceId, hints);
        }
        return gl;
    }

    protected abstract void invalidateState(Object var1, Object var2);
}

