/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.osgi;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(OSGiDeployer.class);
    private BundleContext bundleContext = null;
    private Map<String, Bundle> installedBundles = new HashMap<String, Bundle>();

    protected void undeployBundle(OSGiDeployable osgiDeployable) throws DeployerException {
        this.logger.debug((Object)"Undeploying {0}", new Object[]{osgiDeployable});
        Bundle osgiBundle = null;
        if (!this.isDeployed((IDeployable<?>)osgiDeployable)) {
            throw new DeployerException("Cannot undeploy the bundle '" + osgiDeployable + "' as it was not deployed.");
        }
        osgiBundle = this.installedBundles.get(this.getURL((IDeployable<?>)osgiDeployable).toExternalForm());
        if (osgiBundle == null) {
            throw new DeployerException("No bundle found for the '" + osgiDeployable + "'.");
        }
        try {
            osgiBundle.stop();
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot stop the bundle '" + osgiDeployable + "'.", (Throwable)e);
        }
        try {
            osgiBundle.uninstall();
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot uninstall the bundle '" + osgiDeployable + "'.", (Throwable)e);
        }
        this.installedBundles.remove(this.getURL((IDeployable<?>)osgiDeployable).toExternalForm());
    }

    protected void deployBundle(OSGiDeployable osgiDeployable) throws DeployerException {
        this.logger.debug((Object)"Deploying {0}", new Object[]{osgiDeployable});
        Bundle osgiBundle = null;
        try {
            String url = this.getURL((IDeployable<?>)osgiDeployable).toExternalForm();
            if (osgiDeployable.isReference().booleanValue()) {
                url = "reference:".concat(url);
            }
            osgiBundle = this.bundleContext.installBundle(url);
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot install the bundle '" + osgiDeployable + "'.", (Throwable)e);
        }
        if (osgiDeployable.isStart().booleanValue()) {
            try {
                osgiBundle.start();
            }
            catch (BundleException e) {
                this.logger.error((Object)"Cannot start the bundle ''{0}''.", new Object[]{osgiDeployable, e});
            }
        }
        this.installedBundles.put(this.getURL((IDeployable<?>)osgiDeployable).toExternalForm(), osgiBundle);
    }

    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof OSGiDeployable) {
            this.deployBundle((OSGiDeployable)deployable);
        }
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        return this.installedBundles.get(this.getURL(deployable).toExternalForm()) != null;
    }

    protected URL getURL(IDeployable<?> deployable) throws DeployerException {
        URL url = null;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from deployable '" + deployable + "'.", (Throwable)e);
        }
        return url;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof OSGiDeployable;
    }

    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof OSGiDeployable) {
            this.undeployBundle((OSGiDeployable)deployable);
        }
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (this.bundleContext == null) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not available as there is no bundle context set on this deployer.");
        }
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }
}

