/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.tools.ant.Task;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptorHandler
extends DefaultHandler {
    private static final int STATE_LOOKING_EJBJAR = 1;
    private static final int STATE_IN_EJBJAR = 2;
    private static final int STATE_IN_BEANS = 3;
    private static final int STATE_IN_SESSION = 4;
    private static final int STATE_IN_ENTITY = 5;
    private static final int STATE_IN_MESSAGE = 6;
    private static final int STATE_IN_SERVICE_REF = 7;
    private static final int STATE_IN_PORT_COMPONENT_REF = 8;
    private static final int STATE_IN_HANDLER = 9;
    private Task owningTask;
    private String publicId = null;
    private static final String EJB_REF = "ejb-ref";
    private static final String EJB_LOCAL_REF = "ejb-local-ref";
    private static final String HOME_INTERFACE = "home";
    private static final String REMOTE_INTERFACE = "remote";
    private static final String LOCAL_HOME_INTERFACE = "local-home";
    private static final String LOCAL_INTERFACE = "local";
    private static final String ENDPOINT_INTERFACE = "service-endpoint";
    private static final String BEAN_CLASS = "ejb-class";
    private static final String PK_CLASS = "prim-key-class";
    private static final String EJB_NAME = "ejb-name";
    private static final String EJB_JAR = "ejb-jar";
    private static final String ENTERPRISE_BEANS = "enterprise-beans";
    private static final String ENTITY_BEAN = "entity";
    private static final String SESSION_BEAN = "session";
    private static final String MESSAGE_BEAN = "message-driven";
    private static final String SERVICE_REF = "service-ref";
    private static final String SERVICE_INTERFACE = "service-interface";
    private static final String WSDL_FILE = "wsdl-file";
    private static final String JAXRPC_MAPPING_FILE = "jaxrpc-mapping-file";
    private static final String PORT_COMPONENT_REF = "port-component-ref";
    private static final String SERVICE_ENDPOINT_INTERFACE = "service-endpoint-interface";
    private static final String HANDLER = "handler";
    private static final String HANDLER_CLASS = "handler-class";
    private int parseState = 1;
    private int oldParseState;
    protected String currentElement = null;
    protected String currentText = null;
    protected Hashtable ejbFiles = null;
    protected String ejbName = null;
    private Hashtable fileDTDs = new Hashtable();
    private Hashtable resourceDTDs = new Hashtable();
    private boolean inEJBRef = false;
    private Hashtable urlDTDs = new Hashtable();
    private File srcDir;

    public DescriptorHandler(Task task, File srcDir) {
        this.owningTask = task;
        this.srcDir = srcDir;
    }

    public void registerDTD(String publicId, String location) {
        if (location == null) {
            return;
        }
        File fileDTD = new File(location);
        if (!fileDTD.exists()) {
            fileDTD = this.owningTask.getProject().resolveFile(location);
        }
        if (fileDTD.exists()) {
            if (publicId != null) {
                this.fileDTDs.put(publicId, fileDTD);
                this.owningTask.log("Mapped publicId " + publicId + " to file " + fileDTD, 3);
            }
            return;
        }
        if (this.getClass().getResource(location) != null && publicId != null) {
            this.resourceDTDs.put(publicId, location);
            this.owningTask.log("Mapped publicId " + publicId + " to resource " + location, 3);
        }
        try {
            if (publicId != null) {
                URL urldtd = new URL(location);
                this.urlDTDs.put(publicId, urldtd);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputStream is;
        String dtdResourceName;
        this.publicId = publicId;
        File dtdFile = (File)this.fileDTDs.get(publicId);
        if (dtdFile != null) {
            try {
                this.owningTask.log("Resolved " + publicId + " to local file " + dtdFile, 3);
                return new InputSource(new FileInputStream(dtdFile));
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        if ((dtdResourceName = (String)this.resourceDTDs.get(publicId)) != null && (is = this.getClass().getResourceAsStream(dtdResourceName)) != null) {
            this.owningTask.log("Resolved " + publicId + " to local resource " + dtdResourceName, 3);
            return new InputSource(is);
        }
        URL dtdUrl = (URL)this.urlDTDs.get(publicId);
        if (dtdUrl != null) {
            try {
                InputStream is2 = dtdUrl.openStream();
                this.owningTask.log("Resolved " + publicId + " to url " + dtdUrl, 3);
                return new InputSource(is2);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.owningTask.log("Could not resolve ( publicId: " + publicId + ", systemId: " + systemId + ") to a local entity", 2);
        return null;
    }

    public Hashtable getFiles() {
        return this.ejbFiles == null ? new Hashtable() : this.ejbFiles;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void startDocument() throws SAXException {
        this.ejbFiles = new Hashtable(10, 1.0f);
        this.currentElement = null;
        this.inEJBRef = false;
    }

    public void startElement(String uri, String localname, String qname, Attributes attrs) throws SAXException {
        String name;
        this.currentElement = name = qname;
        this.currentText = "";
        if (name.equals(EJB_REF) || name.equals(EJB_LOCAL_REF)) {
            this.inEJBRef = true;
        } else if (this.parseState == 1 && name.equals(EJB_JAR)) {
            this.parseState = 2;
        } else if (this.parseState == 2 && name.equals(ENTERPRISE_BEANS)) {
            this.parseState = 3;
        } else if (this.parseState == 3 && name.equals(SESSION_BEAN)) {
            this.parseState = 4;
        } else if (this.parseState == 3 && name.equals(ENTITY_BEAN)) {
            this.parseState = 5;
        } else if (this.parseState == 3 && name.equals(MESSAGE_BEAN)) {
            this.parseState = 6;
        } else if ((this.parseState == 4 || this.parseState == 5 || this.parseState == 6) && name.equals(SERVICE_REF)) {
            this.oldParseState = this.parseState;
            this.parseState = 7;
        } else if (this.parseState == 7 && name.equals(PORT_COMPONENT_REF)) {
            this.parseState = 8;
        } else if (this.parseState == 7 && name.equals(HANDLER)) {
            this.parseState = 9;
        }
    }

    public void endElement(String uri, String localname, String qname) throws SAXException {
        String name = qname;
        this.processElement();
        this.currentText = "";
        this.currentElement = "";
        if (name.equals(EJB_REF) || name.equals(EJB_LOCAL_REF)) {
            this.inEJBRef = false;
        } else if (this.parseState == 9 && name.equals(HANDLER)) {
            this.parseState = 7;
        } else if (this.parseState == 8 && name.equals(PORT_COMPONENT_REF)) {
            this.parseState = 7;
        } else if (this.parseState == 7 && name.equals(SERVICE_REF)) {
            this.parseState = this.oldParseState;
        } else if (this.parseState == 5 && name.equals(ENTITY_BEAN)) {
            this.parseState = 3;
        } else if (this.parseState == 4 && name.equals(SESSION_BEAN)) {
            this.parseState = 3;
        } else if (this.parseState == 6 && name.equals(MESSAGE_BEAN)) {
            this.parseState = 3;
        } else if (this.parseState == 3 && name.equals(ENTERPRISE_BEANS)) {
            this.parseState = 2;
        } else if (this.parseState == 2 && name.equals(EJB_JAR)) {
            this.parseState = 1;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText = this.currentText + new String(ch, start, length);
    }

    protected void processElement() {
        if (this.inEJBRef || this.parseState != 5 && this.parseState != 4 && this.parseState != 6 && this.parseState != 7 && this.parseState != 8 && this.parseState != 9) {
            return;
        }
        if (this.currentElement.equals(HOME_INTERFACE) || this.currentElement.equals(REMOTE_INTERFACE) || this.currentElement.equals(LOCAL_INTERFACE) || this.currentElement.equals(ENDPOINT_INTERFACE) || this.currentElement.equals(LOCAL_HOME_INTERFACE) || this.currentElement.equals(BEAN_CLASS) || this.currentElement.equals(PK_CLASS) || this.currentElement.equals(SERVICE_INTERFACE) || this.currentElement.equals(SERVICE_ENDPOINT_INTERFACE) || this.currentElement.equals(HANDLER_CLASS)) {
            File classFile = null;
            String className = this.currentText.trim();
            if (!className.startsWith("java.") && !className.startsWith("javax.")) {
                className = className.replace('.', File.separatorChar);
                className = className + ".class";
                classFile = new File(this.srcDir, className);
                this.ejbFiles.put(className, classFile);
            }
        }
        if (this.currentElement.equals(WSDL_FILE) || this.currentElement.equals(JAXRPC_MAPPING_FILE)) {
            String filename = this.currentText.trim();
            File file = new File(this.srcDir, filename);
            this.ejbFiles.put(filename, file);
        }
        if (this.currentElement.equals(EJB_NAME) && this.ejbName == null) {
            this.ejbName = this.currentText.trim();
        }
    }
}

