/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.FileSet;

public class Checksum
extends MatchingTask
implements Condition {
    private File file = null;
    private File todir;
    private String algorithm = "MD5";
    private String provider = null;
    private String fileext;
    private String property;
    private Map allDigests = new HashMap();
    private Map relativeFilePaths = new HashMap();
    private String totalproperty;
    private boolean forceOverwrite;
    private String verifyProperty;
    private Vector filesets = new Vector();
    private Hashtable includeFileMap = new Hashtable();
    private MessageDigest messageDigest;
    private boolean isCondition;
    private int readBufferSize = 8192;

    public void setFile(File file) {
        this.file = file;
    }

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setFileext(String fileext) {
        this.fileext = fileext;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setTotalproperty(String totalproperty) {
        this.totalproperty = totalproperty;
    }

    public void setVerifyproperty(String verifyProperty) {
        this.verifyProperty = verifyProperty;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public void setReadBufferSize(int size) {
        this.readBufferSize = size;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        this.isCondition = false;
        boolean value = this.validateAndExecute();
        if (this.verifyProperty != null) {
            this.getProject().setNewProperty(this.verifyProperty, new Boolean(value).toString());
        }
    }

    public boolean eval() throws BuildException {
        this.isCondition = true;
        return this.validateAndExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateAndExecute() throws BuildException {
        String savedFileExt = this.fileext;
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Checksum cannot be generated for directories");
        }
        if (this.file != null && this.totalproperty != null) {
            throw new BuildException("File and Totalproperty cannot co-exist.");
        }
        if (this.property != null && this.fileext != null) {
            throw new BuildException("Property and FileExt cannot co-exist.");
        }
        if (this.property != null) {
            if (this.forceOverwrite) {
                throw new BuildException("ForceOverwrite cannot be used when Property is specified");
            }
            if (this.file != null ? this.filesets.size() > 0 : this.filesets.size() > 1) {
                throw new BuildException("Multiple files cannot be used when Property is specified");
            }
        }
        if (this.verifyProperty != null) {
            this.isCondition = true;
        }
        if (this.verifyProperty != null && this.forceOverwrite) {
            throw new BuildException("VerifyProperty and ForceOverwrite cannot co-exist.");
        }
        if (this.isCondition && this.forceOverwrite) {
            throw new BuildException("ForceOverwrite cannot be used when conditions are being used.");
        }
        this.messageDigest = null;
        if (this.provider != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(this.algorithm, this.provider);
            }
            catch (NoSuchAlgorithmException noalgo) {
                throw new BuildException(noalgo, this.getLocation());
            }
            catch (NoSuchProviderException noprovider) {
                throw new BuildException(noprovider, this.getLocation());
            }
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noalgo) {
            throw new BuildException(noalgo, this.getLocation());
        }
        if (this.messageDigest == null) {
            throw new BuildException("Unable to create Message Digest", this.getLocation());
        }
        if (this.fileext == null) {
            this.fileext = "." + this.algorithm;
        } else if (this.fileext.trim().length() == 0) {
            throw new BuildException("File extension when specified must not be an empty string");
        }
        try {
            int sizeofFileSet = this.filesets.size();
            int i = 0;
            while (i < sizeofFileSet) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
                int j = 0;
                while (j < srcFiles.length) {
                    File src = new File(fs.getDir(this.getProject()), srcFiles[j]);
                    if (this.totalproperty != null || this.todir != null) {
                        String relativePath = srcFiles[j].replace(File.separatorChar, '/');
                        this.relativeFilePaths.put(src, relativePath);
                    }
                    this.addToIncludeFileMap(src);
                    ++j;
                }
                ++i;
            }
            this.addToIncludeFileMap(this.file);
            boolean bl = this.generateChecksums();
            Object var11_14 = null;
            this.fileext = savedFileExt;
            this.includeFileMap.clear();
            return bl;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.fileext = savedFileExt;
            this.includeFileMap.clear();
            throw throwable;
        }
    }

    private void addToIncludeFileMap(File file) throws BuildException {
        if (file != null) {
            if (file.exists()) {
                if (this.property == null) {
                    File checksumFile = this.getChecksumFile(file);
                    if (this.forceOverwrite || this.isCondition || file.lastModified() > checksumFile.lastModified()) {
                        this.includeFileMap.put(file, checksumFile);
                    } else {
                        this.log(file + " omitted as " + checksumFile + " is up to date.", 3);
                        if (this.totalproperty != null) {
                            String checksum = null;
                            try {
                                BufferedReader diskChecksumReader = new BufferedReader(new FileReader(checksumFile));
                                checksum = diskChecksumReader.readLine();
                            }
                            catch (IOException e) {
                                throw new BuildException("Couldn't read checksum file " + checksumFile, e);
                            }
                            byte[] digest = Checksum.decodeHex(checksum.toCharArray());
                            this.allDigests.put(file, digest);
                        }
                    }
                } else {
                    this.includeFileMap.put(file, this.property);
                }
            } else {
                String message = "Could not find file " + file.getAbsolutePath() + " to generate checksum for.";
                this.log(message);
                throw new BuildException(message, this.getLocation());
            }
        }
    }

    private File getChecksumFile(File file) {
        File directory;
        if (this.todir != null) {
            String path = (String)this.relativeFilePaths.get(file);
            directory = new File(this.todir, path).getParentFile();
            directory.mkdirs();
        } else {
            directory = file.getParentFile();
        }
        File checksumFile = new File(directory, file.getName() + this.fileext);
        return checksumFile;
    }

    private boolean generateChecksums() throws BuildException {
        boolean checksumMatches = true;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] buf = new byte[this.readBufferSize];
        try {
            Enumeration e = this.includeFileMap.keys();
            while (e.hasMoreElements()) {
                this.messageDigest.reset();
                File src = (File)e.nextElement();
                if (!this.isCondition) {
                    this.log("Calculating " + this.algorithm + " checksum for " + src, 3);
                }
                fis = new FileInputStream(src);
                DigestInputStream dis = new DigestInputStream(fis, this.messageDigest);
                while (dis.read(buf, 0, this.readBufferSize) != -1) {
                }
                dis.close();
                fis.close();
                fis = null;
                byte[] fileDigest = this.messageDigest.digest();
                if (this.totalproperty != null) {
                    this.allDigests.put(src, fileDigest);
                }
                String checksum = this.createDigestString(fileDigest);
                Object destination = this.includeFileMap.get(src);
                if (destination instanceof String) {
                    String prop = (String)destination;
                    if (this.isCondition) {
                        checksumMatches = checksumMatches && checksum.equals(this.property);
                        continue;
                    }
                    this.getProject().setNewProperty(prop, checksum);
                    continue;
                }
                if (!(destination instanceof File)) continue;
                if (this.isCondition) {
                    File existingFile = (File)destination;
                    if (existingFile.exists()) {
                        fis = new FileInputStream(existingFile);
                        InputStreamReader isr = new InputStreamReader(fis);
                        BufferedReader br = new BufferedReader(isr);
                        String suppliedChecksum = br.readLine();
                        fis.close();
                        fis = null;
                        br.close();
                        isr.close();
                        checksumMatches = checksumMatches && checksum.equals(suppliedChecksum);
                        continue;
                    }
                    checksumMatches = false;
                    continue;
                }
                File dest = (File)destination;
                fos = new FileOutputStream(dest);
                fos.write(checksum.getBytes());
                fos.close();
                fos = null;
            }
            if (this.totalproperty != null) {
                Set keys = this.allDigests.keySet();
                Object[] keyArray = keys.toArray();
                Arrays.sort(keyArray);
                this.messageDigest.reset();
                int i = 0;
                while (i < keyArray.length) {
                    File src = (File)keyArray[i];
                    byte[] digest = (byte[])this.allDigests.get(src);
                    this.messageDigest.update(digest);
                    String fileName = (String)this.relativeFilePaths.get(src);
                    this.messageDigest.update(fileName.getBytes());
                    ++i;
                }
                String totalChecksum = this.createDigestString(this.messageDigest.digest());
                this.getProject().setNewProperty(this.totalproperty, totalChecksum);
            }
        }
        catch (Exception e) {
            throw new BuildException(e, this.getLocation());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return checksumMatches;
    }

    private String createDigestString(byte[] fileDigest) {
        StringBuffer checksumSb = new StringBuffer();
        int i = 0;
        while (i < fileDigest.length) {
            String hexStr = Integer.toHexString(0xFF & fileDigest[i]);
            if (hexStr.length() < 2) {
                checksumSb.append("0");
            }
            checksumSb.append(hexStr);
            ++i;
        }
        return checksumSb.toString();
    }

    public static byte[] decodeHex(char[] data) throws BuildException {
        int l = data.length;
        if ((l & 1) != 0) {
            throw new BuildException("odd number of characters.");
        }
        byte[] out = new byte[l >> 1];
        int i = 0;
        int j = 0;
        while (j < l) {
            int f = Character.digit(data[j++], 16) << 4;
            out[i] = (byte)((f |= Character.digit(data[j++], 16)) & 0xFF);
            ++i;
        }
        return out;
    }
}

