/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class PortableRemoteObjectDelegateImpl
implements PortableRemoteObjectDelegate {
    private static ORB _orb = null;

    public static synchronized ORB getORB() {
        if (_orb == null) {
            System.out.println("Unknwon ORB");
            _orb = ORB.init(new String[0], null);
        }
        return _orb;
    }

    public static synchronized void setORB(ORB oRB) {
        if (_orb != null) {
            throw new IllegalStateException("RMI orb has already been initialized");
        }
        _orb = oRB;
    }

    public void exportObject(Remote remote) throws RemoteException {
        if (remote == null) {
            throw new NullPointerException();
        }
        if (remote instanceof Stub) {
            throw new ExportException("Attempted to export a stub class");
        }
        Tie tie = Util.getTie((Remote)remote);
        if (tie != null) {
            throw new ExportException("Object already exported");
        }
        tie = PortableRemoteObjectDelegateImpl.toTie(remote);
        tie.orb(PortableRemoteObjectDelegateImpl.getORB());
        Util.registerTarget((Tie)tie, (Remote)remote);
    }

    public Remote toStub(Remote remote) throws NoSuchObjectException {
        if (remote instanceof Stub) {
            return remote;
        }
        Tie tie = null;
        if (remote instanceof Tie) {
            tie = (Tie)remote;
            remote = tie.getTarget();
        } else {
            tie = Util.getTie((Remote)remote);
        }
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        Object object = tie.thisObject();
        if (object instanceof Remote) {
            return (Remote)((java.lang.Object)object);
        }
        throw new NoSuchObjectException("Object not exported");
    }

    public void unexportObject(Remote remote) throws NoSuchObjectException {
        Tie tie = Util.getTie((Remote)remote);
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        Util.unexportObject((Remote)remote);
    }

    public java.lang.Object narrow(java.lang.Object object, Class clazz) throws ClassCastException {
        java.lang.Object object2;
        Class<?> clazz2;
        block8: {
            if (clazz == null) {
                throw new ClassCastException("Can't narrow to null class");
            }
            if (object == null) {
                return null;
            }
            clazz2 = object.getClass();
            object2 = null;
            try {
                if (clazz.isAssignableFrom(clazz2)) {
                    object2 = object;
                    break block8;
                }
                Class<?>[] classArray = clazz2.getInterfaces();
                Exception exception = new Exception();
                try {
                    throw exception;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                object2 = null;
            }
        }
        if (object2 == null) {
            throw new ClassCastException("Can't narrow from " + clazz2 + " to " + clazz);
        }
        return object2;
    }

    public void connect(Remote remote, Remote remote2) throws RemoteException {
        throw new Error("Not implemented for PortableRemoteObjectDelegateImpl");
    }

    static Tie toTie(Remote remote) throws ExportException {
        for (Class<?> clazz = remote.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                String string = clazz.getName();
                String[] stringArray = string.split("\\.");
                stringArray[stringArray.length - 1] = "_" + stringArray[stringArray.length - 1] + "_Tie";
                StringBuffer stringBuffer = new StringBuffer("org.omg.stub");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append("." + stringArray[i]);
                }
                Class clazz2 = Util.loadClass((String)stringBuffer.toString(), (String)Util.getCodebase(clazz), (ClassLoader)clazz.getClassLoader());
                return (Tie)clazz2.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new ExportException("InstantiationException: " + instantiationException, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ExportException("IllegalAccessException: " + illegalAccessException, illegalAccessException);
            }
        }
        throw new ExportException("Tie class not found ");
    }
}

