/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MetadataHelper;

public class EmbeddableAccessor
extends ClassAccessor {
    public EmbeddableAccessor() {
        super("<embeddable>");
    }

    public EmbeddableAccessor(Annotation annotation, Class cls, MetadataProject project) {
        super(annotation, cls, project);
    }

    public void process() {
        if (this.isAnnotationPresent(Cache.class)) {
            throw ValidationException.cacheNotSupportedWithEmbeddable(this.getJavaClass());
        }
        this.processEmbeddable();
        this.processCustomizer();
        this.processConverters();
        this.processCopyPolicy();
        this.processChangeTracking();
        this.processProperties();
        this.processAccessors();
    }

    public void processAccessType() {
        if (this.havePersistenceAnnotationsDefined(MetadataHelper.getFields(this.getJavaClass())) || this.getDescriptor().isXmlFieldAccess()) {
            this.getDescriptor().setUsesPropertyAccess(false);
        } else if (this.havePersistenceAnnotationsDefined(MetadataHelper.getDeclaredMethods(this.getJavaClass())) || this.getDescriptor().isXmlPropertyAccess()) {
            this.getDescriptor().setUsesPropertyAccess(true);
        }
        if (this.getDescriptor().usesPropertyAccess()) {
            this.getLogger().logConfigMessage("metadata_field_access_type", this.getJavaClass());
        } else {
            this.getLogger().logConfigMessage("metadata_property_access_type", this.getJavaClass());
        }
    }

    protected void processEmbeddable() {
        if (this.getAccess() != null) {
            this.getDescriptor().setXMLAccess(this.getAccess());
        }
        this.processAccessType();
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        }
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        }
    }
}

