/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.loader.EZBClassLoader;
import org.ow2.easybeans.asm.ClassAdapter;
import org.ow2.easybeans.asm.ClassReader;
import org.ow2.easybeans.asm.ClassWriter;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.enhancer.DefinedClass;
import org.ow2.easybeans.enhancer.EnhancerException;
import org.ow2.easybeans.enhancer.bean.BeanClassAdapter;
import org.ow2.easybeans.enhancer.bean.Migration21ClassAdapter;
import org.ow2.easybeans.enhancer.injection.InjectionClassAdapter;
import org.ow2.easybeans.enhancer.interceptors.InterceptorClassAdapter;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enhancer {
    private static Log logger = LogFactory.getLog(Enhancer.class);
    private EjbJarArchiveMetadata ejbJarAnnotationMetadata = null;
    private ClassLoader loader = null;
    private Map<String, Object> map = null;

    public Enhancer(ClassLoader loader, EjbJarArchiveMetadata ejbJarAnnotationMetadata, Map<String, Object> map) {
        this.loader = loader;
        this.ejbJarAnnotationMetadata = ejbJarAnnotationMetadata;
        this.map = map;
    }

    public void enhance() throws EnhancerException {
        for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.ejbJarAnnotationMetadata.getEjbJarClassMetadataCollection()) {
            if (!classAnnotationMetadata.isInterceptor() || classAnnotationMetadata.isBean() || classAnnotationMetadata.wasModified()) continue;
            logger.debug((Object)"ClassAdapter on interceptor : {0}", new Object[]{classAnnotationMetadata.getClassName()});
            this.enhanceSuperClass(classAnnotationMetadata, null);
            ClassReader cr = this.getClassReader(classAnnotationMetadata);
            ClassWriter cw = new ClassWriter(1);
            InterceptorClassAdapter cv = new InterceptorClassAdapter(classAnnotationMetadata, cw);
            InjectionClassAdapter cv2 = new InjectionClassAdapter(classAnnotationMetadata, cv, this.map, null, false);
            cr.accept(cv2, 0);
            classAnnotationMetadata.setModified();
            Enhancer.defineClass(this.loader, classAnnotationMetadata.getClassName().replace("/", "."), cw.toByteArray());
        }
        logger.info((Object)"Beans found are {0}", new Object[]{this.ejbJarAnnotationMetadata.getBeanNames()});
        List beanNames = this.ejbJarAnnotationMetadata.getBeanNames();
        for (String beanName : beanNames) {
            for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.ejbJarAnnotationMetadata.getClassesForBean(beanName)) {
                InjectionClassAdapter cv2;
                if (!classAnnotationMetadata.isBean()) continue;
                this.enhanceSuperClass(classAnnotationMetadata, classAnnotationMetadata);
                ClassReader cr = this.getClassReader(classAnnotationMetadata);
                ClassWriter cw = new ClassWriter(1);
                BeanClassAdapter cv = new BeanClassAdapter(classAnnotationMetadata, cw);
                InterceptorClassAdapter itcpClassAdapter = new InterceptorClassAdapter(classAnnotationMetadata, cv);
                ClassAdapter beanVisitor = cv2 = new InjectionClassAdapter(classAnnotationMetadata, itcpClassAdapter, this.map, classAnnotationMetadata, false);
                if (classAnnotationMetadata.getRemoteHome() != null || classAnnotationMetadata.getLocalHome() != null) {
                    Migration21ClassAdapter ejb21Adapter = new Migration21ClassAdapter(classAnnotationMetadata, cv2);
                    beanVisitor = ejb21Adapter;
                }
                cr.accept(beanVisitor, 0);
                Enhancer.loadDefinedClasses(this.loader, itcpClassAdapter.getDefinedClasses());
                Enhancer.defineClass(this.loader, classAnnotationMetadata.getClassName().replace("/", "."), cw.toByteArray());
            }
        }
    }

    protected void enhanceSuperClass(EasyBeansEjbJarClassMetadata classAnnotationMetadata, EasyBeansEjbJarClassMetadata beanClassMetadata) throws EnhancerException {
        EasyBeansEjbJarClassMetadata superMetaData;
        String superClass = classAnnotationMetadata.getSuperName();
        if (!superClass.equals("java/lang/Object") && (superMetaData = (EasyBeansEjbJarClassMetadata)classAnnotationMetadata.getLinkedClassMetadata(superClass)) != null && !superMetaData.wasModified()) {
            ClassReader cr = this.getClassReader(superMetaData);
            ClassWriter cw = new ClassWriter(1);
            InterceptorClassAdapter itcpClassAdapter = new InterceptorClassAdapter(superMetaData, cw);
            InjectionClassAdapter cv = new InjectionClassAdapter(superMetaData, itcpClassAdapter, this.map, beanClassMetadata, false);
            cr.accept(cv, 0);
            superMetaData.setModified();
            Enhancer.defineClass(this.loader, superMetaData.getClassName().replace("/", "."), cw.toByteArray());
            this.enhanceSuperClass(superMetaData, beanClassMetadata);
        }
    }

    private static void loadDefinedClasses(ClassLoader loader, List<DefinedClass> lst) {
        if (lst != null) {
            for (DefinedClass definedClass : lst) {
                Enhancer.defineClass(loader, definedClass.getClassName(), definedClass.getBytes());
            }
        }
    }

    protected ClassReader getClassReader(EasyBeansEjbJarClassMetadata classAnnotationMetadata) throws EnhancerException {
        String className = classAnnotationMetadata.getClassName() + ".class";
        InputStream is = this.loader.getResourceAsStream(className);
        if (is == null) {
            throw new EnhancerException("Cannot find input stream in classloader " + this.loader + " for class " + className);
        }
        ClassReader cr = null;
        try {
            cr = new ClassReader(is);
        }
        catch (IOException e) {
            throw new EnhancerException("Cannot load input stream for class '" + className + "' in classloader '" + this.loader, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new EnhancerException("Cannot close input stream for class '" + className + "' in classloader '" + this.loader, e);
            }
        }
        return cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defineClass(ClassLoader loader, String className, byte[] b) {
        if (loader instanceof EZBClassLoader) {
            ((EZBClassLoader)loader).addClassDefinition(className, b);
        } else {
            try {
                Class<?> cls = Class.forName("java.lang.ClassLoader");
                Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                try {
                    Object[] args = new Object[]{className, b, 0, b.length};
                    method.invoke((Object)loader, args);
                }
                finally {
                    method.setAccessible(false);
                }
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof LinkageError) {
                    logger.error((Object)"Unable to define the class ''{0}''", new Object[]{className, ite});
                } else {
                    logger.warn((Object)"Unable to define the class ''{0}''", new Object[]{className, ite});
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected EjbJarArchiveMetadata getEjbJarAnnotationMetadata() {
        return this.ejbJarAnnotationMetadata;
    }

    protected Map<String, Object> getMap() {
        return this.map;
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }
}

