/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.easybeans.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.container.EmptyLifeCycleCallBack;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.jonas.ws.axis2.JOnASJaxWsImplementorInfo;
import org.ow2.jonas.ws.axis2.jaxws.Axis2WSEndpoint;
import org.ow2.jonas.ws.axis2.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.axis2.jaxws.WebservicesModule;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.base.JAXWSWebservicesContainer;
import org.ow2.jonas.ws.jaxws.util.JAXWSClassUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class LifeCycleCallback
extends EmptyLifeCycleCallBack {
    private static Log logger = LogFactory.getLog(LifeCycleCallback.class);
    private IWebServiceDeploymentManager manager;
    private List<IWebServiceEndpoint> endpoints = new ArrayList<IWebServiceEndpoint>();
    private Map<String, WebservicesModule> modules = new HashMap<String, WebservicesModule>();

    public void setManager(IWebServiceDeploymentManager manager) {
        this.manager = manager;
    }

    public void start(EZBContainerCallbackInfo info) {
        String moduleName = info.getArchive().getName();
        WebservicesModule module = null;
        Map factories = info.getFactories();
        for (Factory f : factories.values()) {
            String wsdlLocation;
            WebservicesContainer container;
            if (!(f instanceof StatelessSessionFactory)) continue;
            StatelessSessionFactory factory = (StatelessSessionFactory)f;
            Class klass = factory.getBeanClass();
            WebService ws = klass.getAnnotation(WebService.class);
            if (!JAXWSClassUtils.isWebService((Class)klass)) continue;
            IBeanInfo beanInfo = factory.getBeanInfo();
            IWebServiceInfo webServiceInfo = beanInfo.getWebServiceInfo();
            JOnASJaxWsImplementorInfo jaxWsImplementorInfo = webServiceInfo != null ? new JOnASJaxWsImplementorInfo(klass, webServiceInfo) : new JOnASJaxWsImplementorInfo(klass);
            module = this.modules.get(moduleName);
            if (module == null) {
                module = new WebservicesModule(moduleName);
                this.modules.put(moduleName, module);
            }
            if ((container = (WebservicesContainer)module.findContainer(jaxWsImplementorInfo.getWsdlLocation())) == null) {
                container = new WebservicesContainer(jaxWsImplementorInfo.getWsdlLocation());
                module.addContainer(container);
            }
            if ((wsdlLocation = jaxWsImplementorInfo.getWsdlLocation()) == null || wsdlLocation.equals("")) {
                logger.warn((Object)"The wsdl location is not specified!", new Object[0]);
            }
            String pattern = null;
            String serviceName = ws.serviceName();
            String portName = ws.portName();
            String name = ws.name();
            pattern = !"".equals(portName) ? "/" + serviceName + "/" + portName : "/" + serviceName + "/" + name;
            PortMetaData pmd = new PortMetaData();
            String contextRoot = LifeCycleCallback.extractContextRoot(info.getArchive().getName());
            StringBuffer handlerXML = new StringBuffer();
            try {
                HandlerChain hc = klass.getAnnotation(HandlerChain.class);
                if (hc != null) {
                    URL handlerURL = klass.getClassLoader().getResource(hc.file());
                    BufferedReader br = new BufferedReader(new InputStreamReader(handlerURL.openStream()));
                    String temp = null;
                    temp = br.readLine();
                    while (temp != null) {
                        handlerXML.append(temp);
                        temp = br.readLine();
                    }
                    pmd.setHandlerXML(handlerXML.toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to Get the handler description file for " + serviceName + "!", e);
            }
            finally {
                if (pmd.getHandlerXML() != null) {
                    logger.debug((Object)"Found handlers in this package!", new Object[0]);
                }
            }
            pmd.setContextRoot(contextRoot);
            pmd.setUrlPattern(pattern);
            if (wsdlLocation != null && !wsdlLocation.equals("")) {
                pmd.setWSDLLocation(wsdlLocation);
            }
            logger.info((Object)"PortMetaData [context:{0}, pattern:{1}]", new Object[]{pmd.getContextRoot(), pmd.getUrlPattern()});
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(klass.getClassLoader());
            Axis2WSEndpoint endpoint = new Axis2WSEndpoint(klass, IWebServiceEndpoint.EndpointType.EJB, pmd, factory);
            try {
                endpoint.init();
            }
            catch (Exception e1) {
                throw new RuntimeException("Exception occurs when creating endpoint for" + serviceName + "!", e1);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            container.addEndpoint(endpoint);
        }
        if (module != null) {
            module.start();
            for (JAXWSWebservicesContainer container : module.getContainers()) {
                for (IWebServiceEndpoint endpoint : container.getEndpoints()) {
                    try {
                        this.manager.registerWSEndpoint(endpoint);
                        endpoint.displayInfos();
                    }
                    catch (WSException e) {
                        logger.error((Object)"Unable to register endpoint ''{0}''", new Object[]{endpoint, e});
                        try {
                            this.manager.unregisterWSEndpoint(endpoint);
                        }
                        catch (WSException e1) {
                            logger.error((Object)"Unable to unregister endpoint ''{0}'' after a failed deployment", new Object[]{endpoint, e});
                        }
                    }
                }
            }
        }
    }

    private static String extractContextRoot(String filename) {
        String context = filename.substring(filename.lastIndexOf(File.separator) + 1);
        context = context.substring(0, context.lastIndexOf(95));
        return context;
    }

    public void stop(EZBContainerCallbackInfo info) {
        this.stop();
        logger.info((Object)("axis2 stopped for " + info.getArchive()), new Object[0]);
    }

    public void stop() {
        logger.debug((Object)"Stop ''{0}''", new Object[]{this});
        for (Map.Entry<String, WebservicesModule> entry : this.modules.entrySet()) {
            WebservicesModule module = entry.getValue();
            this.stopWebservicesModule(module);
        }
        this.modules.clear();
    }

    private void stopWebservicesModule(WebservicesModule module) {
        for (JAXWSWebservicesContainer container : module.getContainers()) {
            for (IWebServiceEndpoint endpoint : container.getEndpoints()) {
                try {
                    this.manager.unregisterWSEndpoint(endpoint);
                }
                catch (WSException wse) {
                    logger.warn((Object)"Cannot unregister endpoint ''{0}'', continue processing", new Object[]{endpoint, wse});
                }
            }
        }
        module.stop();
    }
}

