/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ComponentFactory
extends IPojoFactory
implements TrackerCustomizer {
    protected Tracker m_tracker;
    private FactoryClassloader m_classLoader;
    private byte[] m_clazz;
    private String m_classname;
    private PojoMetadata m_manipulation;

    public ComponentFactory(BundleContext context, byte[] clazz, Element element) throws ConfigurationException {
        this(context, element);
        this.m_clazz = clazz;
    }

    public ComponentFactory(BundleContext context, Element element) throws ConfigurationException {
        super(context, element);
        this.check(element);
    }

    public ComponentTypeDescription getComponentTypeDescription() {
        return new PrimitiveTypeDescription(this);
    }

    public void check(Element element) throws ConfigurationException {
        this.m_classname = element.getAttribute("classname");
        if (this.m_classname == null) {
            throw new ConfigurationException("A component needs a class name : " + element);
        }
        this.m_manipulation = new PojoMetadata(this.m_componentMetadata);
    }

    public String getClassName() {
        return this.m_classname;
    }

    public ComponentInstance createInstance(Dictionary config, IPojoContext context, HandlerManager[] handlers) throws ConfigurationException {
        InstanceManager instance = new InstanceManager(this, context, handlers);
        try {
            instance.configure(this.m_componentMetadata, config);
            instance.start();
            return instance;
        }
        catch (ConfigurationException e) {
            if (instance != null) {
                instance.dispose();
                instance = null;
            }
            throw e;
        }
        catch (Throwable e) {
            if (instance != null) {
                instance.dispose();
                instance = null;
            }
            this.m_logger.log(1, e.getMessage(), e);
            throw new ConfigurationException(e.getMessage());
        }
    }

    public synchronized Class defineClass(String name, byte[] clazz, ProtectionDomain domain) {
        if (this.m_classLoader == null) {
            this.m_classLoader = new FactoryClassloader();
        }
        return this.m_classLoader.defineClass(name, clazz, domain);
    }

    public URL getResource(String resName) {
        return this.m_context.getBundle().getResource(resName);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.m_clazz != null && this.m_classname.equals(className)) {
            return this.defineClass(className, this.m_clazz, null);
        }
        return this.m_context.getBundle().loadClass(className);
    }

    public void starting() {
        if (this.m_tracker != null) {
            return;
        }
        if (this.m_requiredHandlers.size() != 0) {
            try {
                String filter = "(&(handler.type=primitive)(factory.state=1))";
                this.m_tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
                this.m_tracker.open();
            }
            catch (InvalidSyntaxException e) {
                this.m_logger.log(1, "A factory filter is not valid: " + e.getMessage());
                this.stop();
            }
        }
    }

    public void stopping() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
    }

    public String getFactoryName() {
        String name = this.m_componentMetadata.getAttribute("name");
        if (name == null) {
            name = this.m_componentMetadata.getAttribute("classname");
        }
        return name;
    }

    public List getRequiredHandlerList() {
        String imm;
        ArrayList<IPojoFactory.RequiredHandler> list = new ArrayList<IPojoFactory.RequiredHandler>();
        Element[] elems = this.m_componentMetadata.getElements();
        for (int i = 0; i < elems.length; ++i) {
            IPojoFactory.RequiredHandler req;
            Element current = elems[i];
            if ("manipulation".equals(current.getName()) || list.contains(req = new IPojoFactory.RequiredHandler(this, current.getName(), current.getNameSpace()))) continue;
            list.add(req);
        }
        String arch = this.m_componentMetadata.getAttribute("architecture");
        if (arch == null || arch.equalsIgnoreCase("true")) {
            list.add(new IPojoFactory.RequiredHandler(this, "architecture", null));
        }
        if (this.m_componentMetadata.getElements("provides") == null && (imm = this.m_componentMetadata.getAttribute("immediate")) == null) {
            this.getLogger().log(3, "The component type " + this.getFactoryName() + " becomes immediate");
            this.m_componentMetadata.addAttribute(new Attribute("immediate", "true"));
        }
        IPojoFactory.RequiredHandler reqCallback = new IPojoFactory.RequiredHandler(this, "callback", null);
        String imm2 = this.m_componentMetadata.getAttribute("immediate");
        if (!list.contains(reqCallback) && imm2 != null && imm2.equalsIgnoreCase("true")) {
            list.add(reqCallback);
        }
        return list;
    }

    public synchronized boolean addingService(ServiceReference reference) {
        for (int i = 0; i < this.m_requiredHandlers.size(); ++i) {
            IPojoFactory.RequiredHandler req = (IPojoFactory.RequiredHandler)this.m_requiredHandlers.get(i);
            if (req.getReference() != null || !this.match(req, reference)) continue;
            int oldP = req.getLevel();
            req.setReference(reference);
            if (oldP != req.getLevel()) {
                Collections.sort(this.m_requiredHandlers);
            }
            return true;
        }
        return false;
    }

    public synchronized void addedService(ServiceReference reference) {
        if (this.m_state == 0) {
            this.computeFactoryState();
        }
    }

    public synchronized void removedService(ServiceReference reference, Object service) {
        for (int i = 0; i < this.m_requiredHandlers.size(); ++i) {
            IPojoFactory.RequiredHandler req = (IPojoFactory.RequiredHandler)this.m_requiredHandlers.get(i);
            if (!reference.equals(req.getReference())) continue;
            req.unRef();
            this.computeFactoryState();
            return;
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public PojoMetadata getPojoMetadata() {
        return this.m_manipulation;
    }

    private final class PrimitiveTypeDescription
    extends ComponentTypeDescription {
        public PrimitiveTypeDescription(Factory factory) {
            super(factory);
        }

        public Dictionary getPropertiesToPublish() {
            Dictionary dict = super.getPropertiesToPublish();
            if (ComponentFactory.this.m_classname != null) {
                dict.put("component.class", ComponentFactory.this.m_classname);
            }
            return dict;
        }

        public Element getDescription() {
            Element elem = super.getDescription();
            elem.addAttribute(new Attribute("Implementation-Class", ComponentFactory.this.m_classname));
            return elem;
        }
    }

    private class FactoryClassloader
    extends ClassLoader {
        private final Map m_definedClasses = new HashMap();

        private FactoryClassloader() {
        }

        public Class defineClass(String name, byte[] clazz, ProtectionDomain domain) {
            if (this.m_definedClasses.containsKey(name)) {
                return (Class)this.m_definedClasses.get(name);
            }
            Class<?> clas = super.defineClass(name, clazz, 0, clazz.length, domain);
            this.m_definedClasses.put(name, clas);
            return clas;
        }

        public URL getResource(String arg) {
            return ComponentFactory.this.m_context.getBundle().getResource(arg);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return ComponentFactory.this.m_context.getBundle().loadClass(name);
        }
    }
}

