/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IURLPolicy;

public class URLPolicyImpl
implements IURLPolicy {
    private Logger m_logger = null;
    private URLStreamHandler m_streamHandler = null;
    private IModule m_module = null;
    private static SecureAction m_secureAction = new SecureAction();

    public URLPolicyImpl(Logger logger, URLStreamHandler streamHandler, IModule module) {
        this.m_logger = logger;
        this.m_streamHandler = streamHandler;
        this.m_module = module;
    }

    public URL createURL(int port, String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            return m_secureAction.createURL("bundle", this.m_module.getId(), port, path, this.m_streamHandler);
        }
        catch (MalformedURLException ex) {
            this.m_logger.log(1, "Unable to create resource URL.", ex);
            return null;
        }
    }
}

