/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.osgi.framework.AdminPermission;

final class AdminPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3747361397420496672L;
    private HashMap m_map = new HashMap();

    AdminPermissionCollection() {
    }

    public void add(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            throw new IllegalArgumentException("Invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Cannot add to read-only permission collection.");
        }
        AdminPermission admin = (AdminPermission)permission;
        AdminPermission current = (AdminPermission)this.m_map.get(admin.getName());
        if (current != null) {
            if (admin.m_actionMask != current.m_actionMask) {
                this.m_map.put(admin.getName(), new AdminPermission(admin.getName(), admin.m_actionMask | current.m_actionMask));
            }
        } else {
            this.m_map.put(admin.getName(), admin);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        Iterator iter = this.m_map.values().iterator();
        while (iter.hasNext()) {
            if (!((AdminPermission)iter.next()).implies(permission)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.m_map.values());
    }
}

