/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.messages;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.util.Transaction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Vector;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.excepts.MessageException;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.util.monolog.api.BasicLevel;

public final class Message
implements Serializable {
    private static final long serialVersionUID = 2L;
    public transient long order;
    public transient int acksCounter;
    public transient int durableAcksCounter;
    private transient org.objectweb.joram.shared.messages.Message msg;
    private transient SoftReference bodySoftRef = null;
    private transient boolean soft;
    private static final boolean globalUseSoftRef = AgentServer.getBoolean("org.objectweb.joram.mom.messages.SWAPALLOWED");
    transient String txname = null;

    public Message(org.objectweb.joram.shared.messages.Message msg) {
        this.msg = msg;
        Boolean msgUseSoftRef = (Boolean)msg.getProperty("JMS_JORAM_SWAPALLOWED");
        this.soft = msgUseSoftRef != null ? msgUseSoftRef != false && msg.persistent && msg.body != null : globalUseSoftRef && msg.persistent && msg.body != null;
    }

    public org.objectweb.joram.shared.messages.Message getHeaderMessage() {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.getHeaderMessage()" + this.msg));
        }
        return this.msg;
    }

    public org.objectweb.joram.shared.messages.Message getFullMessage() {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.getFullMessage() " + this.txname));
        }
        if (!this.soft || this.msg.body != null) {
            return this.msg;
        }
        if (this.bodySoftRef != null) {
            this.msg.body = (byte[])this.bodySoftRef.get();
            this.bodySoftRef = null;
            if (this.msg.body != null) {
                return this.msg;
            }
        }
        try {
            this.msg.body = AgentServer.getTransaction().loadByteArray(this.txname + "B");
            if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("Loaded body: " + this.msg.body));
            }
            this.bodySoftRef = null;
        }
        catch (Exception exc) {
            JoramTracing.dbgMessage.log(BasicLevel.ERROR, (Object)("Body of message named [" + this.txname + "] could not be loaded"), (Throwable)exc);
        }
        return this.msg;
    }

    public void releaseFullMessage() {
        if (this.soft) {
            this.bodySoftRef = new SoftReference<byte[]>(this.msg.body);
            this.msg.body = null;
        }
    }

    public int getType() {
        return this.msg.type;
    }

    public String getIdentifier() {
        return this.msg.id;
    }

    public void setIdentifier(String id) {
        this.msg.id = id;
    }

    public boolean isPersistent() {
        return this.msg.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.msg.persistent = persistent;
    }

    public int getPriority() {
        return this.msg.priority;
    }

    public void setPriority(int priority) {
        if (priority >= 0 && priority <= 9) {
            this.msg.priority = priority;
        }
    }

    public long getExpiration() {
        return this.msg.expiration;
    }

    public void setExpiration(long expiration) {
        if (expiration >= 0L) {
            this.msg.expiration = expiration;
        }
    }

    public long getTimestamp() {
        return this.msg.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.msg.timestamp = timestamp;
    }

    public final String getCorrelationId() {
        return this.msg.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.msg.correlationId = correlationId;
    }

    public int getDeliveryCount() {
        return this.msg.deliveryCount;
    }

    public void setDeliveryCount(int deliveryCount) {
        this.msg.deliveryCount = deliveryCount;
    }

    public void incDeliveryCount() {
        ++this.msg.deliveryCount;
    }

    public void setRedelivered() {
        this.msg.redelivered = true;
    }

    public void setObjectProperty(String name, Object value) throws MessageException {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (!(value instanceof Boolean || value instanceof Number || value instanceof String)) {
            throw new MessageValueException("Can't set non primitive Java object as a property value.");
        }
        this.msg.setProperty(name, value);
    }

    public boolean isValid(long currentTime) {
        return this.msg.expiration == 0L || this.msg.expiration > currentTime;
    }

    public void setTxName(String txname) {
        this.txname = txname;
    }

    public String getTxName() {
        return this.txname;
    }

    public static Message load(String txname) throws IOException, ClassNotFoundException {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("Message.load:" + txname));
        }
        Message msg = (Message)AgentServer.getTransaction().load(txname);
        msg.txname = txname;
        return msg;
    }

    public void save() {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("Message.save:" + this.txname));
        }
        if (!this.isPersistent()) {
            return;
        }
        if (this.soft) {
            byte[] body = this.msg.body;
            this.msg.body = null;
            try {
                AgentServer.getTransaction().save(this, this.txname);
            }
            catch (IOException exc) {
                JoramTracing.dbgMessage.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
            try {
                AgentServer.getTransaction().saveByteArray(body, this.txname + "B");
            }
            catch (IOException exc) {
                JoramTracing.dbgMessage.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
            this.msg.body = body;
        } else {
            try {
                AgentServer.getTransaction().save(this, this.txname);
            }
            catch (IOException exc) {
                JoramTracing.dbgMessage.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
        }
    }

    public void saveHeader() {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("Message.saveHeader:" + this.txname));
        }
        if (!this.isPersistent()) {
            return;
        }
        if (this.soft) {
            byte[] body = this.msg.body;
            this.msg.body = null;
            try {
                AgentServer.getTransaction().save(this, this.txname);
            }
            catch (IOException exc) {
                JoramTracing.dbgMessage.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
            this.msg.body = body;
        } else {
            this.save();
        }
    }

    public void delete() {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("Message.delete:" + this.txname));
        }
        if (!this.isPersistent()) {
            return;
        }
        AgentServer.getTransaction().delete(this.txname);
        if (this.soft) {
            AgentServer.getTransaction().delete(this.txname + "B");
        }
    }

    public static Vector loadAll(String msgTxname) {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.loadAll() " + msgTxname));
        }
        Vector<Message> messages = new Vector<Message>();
        Transaction tx = AgentServer.getTransaction();
        String[] names = tx.getList(msgTxname);
        for (int i = 0; i < names.length; ++i) {
            if (names[i].charAt(names[i].length() - 1) == 'B') continue;
            try {
                Message msg = (Message)tx.load(names[i]);
                msg.txname = names[i];
                if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("loadAll: names[" + i + "] = " + msg));
                }
                messages.add(msg);
                continue;
            }
            catch (Exception exc) {
                JoramTracing.dbgMessage.log(BasicLevel.ERROR, (Object)("Message named [" + names[i] + "] could not be loaded"), (Throwable)exc);
            }
        }
        return messages;
    }

    public static void deleteAll(String msgTxname) {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.deleteAll() " + msgTxname));
        }
        Transaction tx = AgentServer.getTransaction();
        String[] names = tx.getList(msgTxname);
        for (int i = 0; i < names.length; ++i) {
            tx.delete(names[i]);
            tx.delete(names[i] + "B");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.order);
        out.writeBoolean(this.soft);
        this.msg.writeHeaderTo(out);
        StreamUtil.writeTo(this.msg.body, (OutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.order = in.readLong();
        this.soft = in.readBoolean();
        this.acksCounter = 0;
        this.durableAcksCounter = 0;
        this.msg = new org.objectweb.joram.shared.messages.Message();
        this.msg.readHeaderFrom(in);
        this.msg.body = StreamUtil.readByteArrayFrom(in);
    }
}

