/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.joram.mom.proxies.tcp.TcpConnection;
import org.objectweb.joram.mom.proxies.tcp.TcpConnectionListener;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpProxyService {
    public static final String SO_TIMEOUT_PROP = "org.objectweb.joram.mom.proxies.tcp.soTimeout";
    public static final int DEFAULT_SO_TIMEOUT = 10000;
    public static final String POOL_SIZE_PROP = "org.objectweb.joram.mom.proxies.tcp.poolSize";
    public static final int DEFAULT_POOL_SIZE = 1;
    public static final String BACKLOG_PROP = "org.objectweb.joram.mom.proxies.tcp.backlog";
    public static final int DEFAULT_BACKLOG = 10;
    public static final int DEFAULT_PORT = 16010;
    public static final String DEFAULT_BINDADDRESS = "0.0.0.0";
    protected static TcpProxyService proxyService;
    private static int port;
    private static String address;
    private Vector connections = new Vector();
    private TcpConnectionListener[] connectionListeners;

    public static final int getListenPort() {
        return port;
    }

    public static final String getListenAddress() {
        return address;
    }

    public static void init(String args, boolean firstTime) throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("TcpProxyService.init(" + args + ',' + firstTime + ')'));
        }
        port = 16010;
        address = DEFAULT_BINDADDRESS;
        if (args != null) {
            StringTokenizer st = new StringTokenizer(args);
            port = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                address = st.nextToken();
            }
        }
        int backlog = AgentServer.getInteger(BACKLOG_PROP, 10);
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("SSLTcpProxyService.init() - binding to " + address + ", port " + port));
        }
        ServerSocket serverSocket = address.equals(DEFAULT_BINDADDRESS) ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, InetAddress.getByName(address));
        int poolSize = AgentServer.getInteger(POOL_SIZE_PROP, 1);
        int timeout = AgentServer.getInteger(SO_TIMEOUT_PROP, 10000);
        proxyService = new TcpProxyService(serverSocket, poolSize, timeout);
        proxyService.start();
    }

    public static void stopService() {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"TcpProxyService.stop()");
        }
        proxyService.stop();
    }

    public TcpProxyService(ServerSocket serverSocket, int poolSize, int timeout) {
        this.connectionListeners = new TcpConnectionListener[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            this.connectionListeners[i] = new TcpConnectionListener(serverSocket, this, timeout);
        }
    }

    protected void start() {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"TcpProxyService.start()");
        }
        for (int i = 0; i < this.connectionListeners.length; ++i) {
            this.connectionListeners[i].start();
        }
    }

    void registerConnection(TcpConnection tcpConnection) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("TcpProxyService.registerConnection(" + tcpConnection + ')'));
        }
        this.connections.addElement(tcpConnection);
    }

    void unregisterConnection(TcpConnection tcpConnection) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("TcpProxyService.unregisterConnection(" + tcpConnection + ')'));
        }
        this.connections.removeElement(tcpConnection);
    }

    TcpConnection getConnection(AgentId proxyId, int key) {
        for (int i = 0; i < this.connections.size(); ++i) {
            TcpConnection tc = (TcpConnection)this.connections.elementAt(i);
            if (tc.getProxyId() != proxyId || tc.getKey() != key) continue;
            return tc;
        }
        return null;
    }

    private void stop() {
        int i;
        Vector stopList = (Vector)this.connections.clone();
        for (i = 0; i < stopList.size(); ++i) {
            TcpConnection tc = (TcpConnection)stopList.elementAt(i);
            tc.close();
        }
        for (i = 0; i < this.connectionListeners.length; ++i) {
            this.connectionListeners[i].stop();
        }
    }
}

