/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;

public abstract class IPojoFactory
implements Factory,
ManagedServiceFactory {
    protected static final List INSTANCE_NAME = new ArrayList();
    protected ComponentTypeDescription m_componentDesc;
    protected final Map m_componentInstances = new HashMap();
    protected final Element m_componentMetadata;
    protected final BundleContext m_context;
    protected String m_factoryName;
    protected List m_requiredHandlers = new ArrayList();
    protected List m_listeners = new ArrayList(1);
    protected final Logger m_logger;
    protected final boolean m_isPublic;
    protected ServiceRegistration m_sr;
    protected int m_state = 0;
    private long m_index = 0L;
    private boolean m_described;

    public IPojoFactory(BundleContext context, Element metadata) throws ConfigurationException {
        this.m_context = context;
        this.m_componentMetadata = metadata;
        this.m_factoryName = this.getFactoryName();
        String fac = metadata.getAttribute("public");
        this.m_isPublic = fac == null || !fac.equalsIgnoreCase("false");
        this.m_logger = new Logger(this.m_context, this.m_factoryName);
        this.m_requiredHandlers = this.getRequiredHandlerList();
    }

    public ComponentTypeDescription getComponentTypeDescription() {
        return new ComponentTypeDescription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFactoryStateListener(FactoryStateListener listener) {
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            this.m_listeners.add(listener);
        }
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public abstract String getFactoryName();

    public abstract List getRequiredHandlerList();

    public abstract ComponentInstance createInstance(Dictionary var1, IPojoContext var2, HandlerManager[] var3) throws ConfigurationException;

    public ComponentInstance createComponentInstance(Dictionary configuration) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        return this.createComponentInstance(configuration, null);
    }

    public synchronized ComponentInstance createComponentInstance(Dictionary configuration, ServiceContext serviceContext) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        String name;
        if (configuration == null) {
            configuration = new Properties();
        }
        IPojoContext context = null;
        context = serviceContext == null ? new IPojoContext(this.m_context) : new IPojoContext(this.m_context, serviceContext);
        try {
            this.checkAcceptability(configuration);
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
            throw new UnacceptableConfiguration("The configuration " + configuration + " is not acceptable for " + this.m_factoryName + ": " + e.getMessage());
        }
        if (configuration.get("instance.name") == null && configuration.get("name") == null) {
            name = this.generateName();
            configuration.put("instance.name", name);
        } else {
            name = (String)configuration.get("instance.name");
            if (name == null) {
                name = (String)configuration.get("name");
                this.getLogger().log(2, "The 'name' (" + name + ") attribute, used as the instance name, is deprecated, please use the 'instance.name' attribute");
                configuration.put("instance.name", name);
            }
            if (INSTANCE_NAME.contains(name)) {
                this.m_logger.log(1, "The configuration is not acceptable : Name already used");
                throw new UnacceptableConfiguration(this.getFactoryName() + " : Name already used : " + name);
            }
        }
        HandlerManager[] handlers = new HandlerManager[this.m_requiredHandlers.size()];
        for (int i = 0; i < handlers.length; ++i) {
            RequiredHandler req = (RequiredHandler)this.m_requiredHandlers.get(i);
            handlers[i] = this.getHandler(req, serviceContext);
        }
        try {
            ComponentInstance instance = this.createInstance(configuration, context, handlers);
            INSTANCE_NAME.add(name);
            this.m_componentInstances.put(name, instance);
            return instance;
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, e.getMessage());
            throw new ConfigurationException(e.getMessage(), this.m_factoryName);
        }
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public abstract String getClassName();

    public synchronized ComponentTypeDescription getComponentDescription() {
        return this.m_componentDesc;
    }

    public synchronized Element getDescription() {
        if (this.m_componentDesc == null) {
            return new Element("No description available for " + this.m_factoryName, "");
        }
        return this.m_componentDesc.getDescription();
    }

    public List getMissingHandlers() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.m_requiredHandlers.size(); ++i) {
            RequiredHandler req = (RequiredHandler)this.m_requiredHandlers.get(i);
            if (req.getReference() != null) continue;
            list.add(req.getFullName());
        }
        return list;
    }

    public String getName() {
        return this.m_factoryName;
    }

    public synchronized List getRequiredHandlers() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.m_requiredHandlers.size(); ++i) {
            RequiredHandler req = (RequiredHandler)this.m_requiredHandlers.get(i);
            list.add(req.getFullName());
        }
        return list;
    }

    public synchronized int getState() {
        return this.m_state;
    }

    public boolean isAcceptable(Dictionary conf) {
        try {
            this.checkAcceptability(conf);
        }
        catch (MissingHandlerException e) {
            return false;
        }
        catch (UnacceptableConfiguration e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAcceptability(Dictionary conf) throws UnacceptableConfiguration, MissingHandlerException {
        PropertyDescription[] props;
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            if (this.m_state == 0) {
                throw new MissingHandlerException(this.getMissingHandlers());
            }
            props = this.m_componentDesc.getProperties();
        }
        for (int i = 0; i < props.length; ++i) {
            if (props[i].isImmutable() && conf.get(props[i].getName()) != null) {
                throw new UnacceptableConfiguration("The property " + props[i] + " cannot be overide : immutable property");
            }
            if (!props[i].isMandatory() || props[i].getValue() != null || conf.get(props[i].getName()) != null) continue;
            throw new UnacceptableConfiguration("The mandatory property " + props[i].getName() + " is missing");
        }
    }

    public synchronized void reconfigure(Dictionary properties) throws UnacceptableConfiguration, MissingHandlerException {
        ComponentInstance instance;
        if (properties == null || properties.get("instance.name") == null && properties.get("name") == null) {
            throw new UnacceptableConfiguration("The configuration does not contains the \"instance.name\" property");
        }
        String name = (String)properties.get("instance.name");
        if (name == null) {
            name = (String)properties.get("name");
        }
        if ((instance = (ComponentInstance)this.m_componentInstances.get(name)) == null) {
            return;
        }
        this.checkAcceptability(properties);
        instance.reconfigure(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFactoryStateListener(FactoryStateListener listener) {
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            this.m_listeners.remove(listener);
        }
    }

    public abstract void stopping();

    public synchronized void stop() {
        int i;
        if (this.m_sr != null) {
            this.m_sr.unregister();
            this.m_sr = null;
        }
        this.stopping();
        this.m_state = 0;
        Set col = this.m_componentInstances.keySet();
        Iterator it = col.iterator();
        ComponentInstance[] instances = new ComponentInstance[col.size()];
        int index = 0;
        while (it.hasNext()) {
            instances[index] = (ComponentInstance)this.m_componentInstances.get(it.next());
            ++index;
        }
        if (this.m_state == 1) {
            for (i = 0; i < this.m_listeners.size(); ++i) {
                ((FactoryStateListener)this.m_listeners.get(i)).stateChanged(this, 0);
            }
        }
        for (i = 0; i < instances.length; ++i) {
            ComponentInstance instance = instances[i];
            if (instance.getState() == -1) continue;
            instance.dispose();
        }
        for (i = 0; i < this.m_requiredHandlers.size(); ++i) {
            ((RequiredHandler)this.m_requiredHandlers.get(i)).unRef();
        }
        this.m_described = false;
        this.m_componentDesc = null;
        this.m_componentInstances.clear();
    }

    synchronized void dispose() {
        this.stop();
        this.m_requiredHandlers = null;
        this.m_listeners = null;
    }

    public abstract void starting();

    public synchronized void start() {
        if (this.m_described) {
            return;
        }
        this.m_componentDesc = this.getComponentTypeDescription();
        this.starting();
        this.computeFactoryState();
        if (this.m_isPublic) {
            this.m_sr = this.m_context.registerService(this.m_componentDesc.getFactoryInterfacesToPublish(), (Object)this, this.m_componentDesc.getPropertiesToPublish());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String name, Dictionary properties) throws org.osgi.service.cm.ConfigurationException {
        InstanceManager instance;
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            instance = (InstanceManager)this.m_componentInstances.get(name);
        }
        if (instance == null) {
            try {
                properties.put("instance.name", name);
                this.createComponentInstance(properties);
            }
            catch (UnacceptableConfiguration e) {
                this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
            }
            catch (MissingHandlerException e) {
                this.m_logger.log(1, "Handler not available : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
            }
            catch (ConfigurationException e) {
                this.m_logger.log(1, "The Component Type metadata are not correct : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
            }
        }
        try {
            properties.put("instance.name", name);
            this.reconfigure(properties);
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
            throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The factory is not valid, at least one handler is missing : " + e.getMessage());
            throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
        }
    }

    public synchronized void deleted(String name) {
        INSTANCE_NAME.remove(name);
        ComponentInstance instance = (ComponentInstance)this.m_componentInstances.remove(name);
        if (instance != null) {
            instance.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(ComponentInstance instance) {
        String name = instance.getInstanceName();
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            INSTANCE_NAME.remove(name);
            this.m_componentInstances.remove(name);
        }
    }

    protected void computeDescription() {
        for (int i = 0; i < this.m_requiredHandlers.size(); ++i) {
            RequiredHandler req = (RequiredHandler)this.m_requiredHandlers.get(i);
            Handler handler = this.getHandler(req, null).getHandler();
            try {
                handler.setFactory(this);
                handler.initializeComponentFactory(this.m_componentDesc, this.m_componentMetadata);
                ((Pojo)((Object)handler)).getComponentInstance().dispose();
                continue;
            }
            catch (ConfigurationException e) {
                ((Pojo)((Object)handler)).getComponentInstance().dispose();
                this.m_logger.log(1, e.getMessage());
                this.stop();
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    protected void computeFactoryState() {
        int i;
        boolean isValid = true;
        for (i = 0; i < this.m_requiredHandlers.size(); ++i) {
            RequiredHandler req = (RequiredHandler)this.m_requiredHandlers.get(i);
            if (req.getReference() != null) continue;
            isValid = false;
            break;
        }
        if (isValid) {
            if (this.m_state == 0) {
                if (!this.m_described) {
                    this.computeDescription();
                    this.m_described = true;
                }
                this.m_state = 1;
                if (this.m_sr != null) {
                    this.m_sr.setProperties(this.m_componentDesc.getPropertiesToPublish());
                }
                for (i = 0; i < this.m_listeners.size(); ++i) {
                    ((FactoryStateListener)this.m_listeners.get(i)).stateChanged(this, 1);
                }
                return;
            }
        } else if (this.m_state == 1) {
            this.m_state = 0;
            for (i = 0; i < this.m_listeners.size(); ++i) {
                ((FactoryStateListener)this.m_listeners.get(i)).stateChanged(this, 0);
            }
            Set col = this.m_componentInstances.keySet();
            String[] keys = col.toArray(new String[col.size()]);
            for (int i2 = 0; i2 < keys.length; ++i2) {
                ComponentInstance instance = (ComponentInstance)this.m_componentInstances.get(keys[i2]);
                if (instance.getState() != -1) {
                    instance.dispose();
                }
                INSTANCE_NAME.remove(instance.getInstanceName());
            }
            this.m_componentInstances.clear();
            if (this.m_sr != null) {
                this.m_sr.setProperties(this.m_componentDesc.getPropertiesToPublish());
            }
            return;
        }
    }

    protected boolean match(RequiredHandler req, ServiceReference ref) {
        String name = (String)ref.getProperty("handler.name");
        String namespace = (String)ref.getProperty("handler.namespace");
        if ("org.apache.felix.ipojo".equals(namespace)) {
            return name.equals(req.getName()) && req.getNamespace() == null;
        }
        return name.equals(req.getName()) && namespace.equals(req.getNamespace());
    }

    protected HandlerManager getHandler(RequiredHandler req, ServiceContext context) {
        try {
            return (HandlerManager)req.getFactory().createComponentInstance(null, context);
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The creation of the handler " + req.getFullName() + " has failed: " + e.getMessage());
            this.stop();
            return null;
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The creation of the handler " + req.getFullName() + " has failed (UnacceptableConfiguration): " + e.getMessage());
            this.stop();
            return null;
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "The configuration of the handler " + req.getFullName() + " has failed (ConfigurationException): " + e.getMessage());
            this.stop();
            return null;
        }
    }

    protected String generateName() {
        String name = this.m_factoryName + "-" + this.m_index;
        while (INSTANCE_NAME.contains(name)) {
            ++this.m_index;
            name = this.m_factoryName + "-" + this.m_index;
        }
        return name;
    }

    protected class RequiredHandler
    implements Comparable {
        private HandlerFactory m_factory;
        private final String m_name;
        private int m_level = Integer.MAX_VALUE;
        private final String m_namespace;
        private ServiceReference m_reference;

        public RequiredHandler(String name, String namespace) {
            this.m_name = name;
            this.m_namespace = namespace;
        }

        public boolean equals(Object object) {
            if (object instanceof RequiredHandler) {
                RequiredHandler req = (RequiredHandler)object;
                if (this.m_namespace == null) {
                    return req.m_name.equalsIgnoreCase(this.m_name) && req.m_namespace == null;
                }
                return req.m_name.equalsIgnoreCase(this.m_name) && this.m_namespace.equalsIgnoreCase(req.m_namespace);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public HandlerFactory getFactory() {
            if (this.m_reference == null) {
                return null;
            }
            if (this.m_factory == null) {
                this.m_factory = (HandlerFactory)IPojoFactory.this.m_context.getService(this.getReference());
            }
            return this.m_factory;
        }

        public String getFullName() {
            if (this.m_namespace == null) {
                return "org.apache.felix.ipojo:" + this.m_name;
            }
            return this.m_namespace + ":" + this.m_name;
        }

        public String getName() {
            return this.m_name;
        }

        public String getNamespace() {
            return this.m_namespace;
        }

        public ServiceReference getReference() {
            return this.m_reference;
        }

        public int getLevel() {
            return this.m_level;
        }

        public void unRef() {
            if (this.m_reference != null) {
                this.m_factory = null;
                this.m_reference = null;
            }
        }

        public void setReference(ServiceReference ref) {
            this.m_reference = ref;
            Integer level = (Integer)this.m_reference.getProperty("handler.level");
            if (level != null) {
                this.m_level = level;
            }
        }

        public int compareTo(Object object) {
            if (object instanceof RequiredHandler) {
                RequiredHandler req = (RequiredHandler)object;
                if (this.m_level == req.m_level) {
                    return 0;
                }
                if (this.m_level < req.m_level) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

